/*
 * Decompiled with CFR 0.152.
 */
package arcus.gui;

import arcus.I18N;
import arcus.Main;
import arcus.Version;
import arcus.algorithm.LayerByLayerAlgorithm;
import arcus.gui.About;
import arcus.gui.BasicGraphicsEngine;
import arcus.gui.CanceledException;
import arcus.gui.Editor;
import arcus.gui.Images;
import arcus.gui.PatternGrabber;
import arcus.gui.PatternStore;
import arcus.gui.PrefUI;
import arcus.gui.TabbedContainer;
import arcus.gui.ToolBarPanel;
import arcus.gui.ext.XFrame;
import arcus.gui.ext.XTabbedPane;
import arcus.gui.ext.XTextField;
import arcus.model.CubeEvent;
import arcus.model.CubeInstance;
import arcus.model.ExtensionFileFilter;
import arcus.model.Preferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MainFrame
extends XFrame {
    private Vector<CubeInstance> instances = new Vector();
    private Vector<JPanel> instanceGUI = new Vector();
    private Vector<Editor> editors = new Vector();
    private Vector<JPanel> editorGUI = new Vector();
    private JPanel instancePanel;
    private JPanel editorPanel;
    private JProgressBar progressBar;
    private int instanceCount = 0;
    private int editorCount = 0;
    private boolean modified = false;
    private File file = null;
    private String path = (String)Preferences.instance.get("sessionPath");
    private SaveAction saveAction = new SaveAction();

    private void shutdown() {
        try {
            PatternStore.instance.close();
            this.close();
            System.exit(0);
        }
        catch (CanceledException canceledException) {
            // empty catch block
        }
    }

    public void setSessionFile(File file) {
        this.file = file;
        this.path = this.file.getParent();
        Preferences.instance.set("sessionPath", this.path);
        Preferences.instance.save();
        this.setTitle(this.file + " - Arcus");
    }

    public MainFrame() {
        this.setTitle("Arcus");
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        this.instancePanel = new JPanel();
        this.instancePanel.setLayout(new BoxLayout(this.instancePanel, 1));
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(new BoxLayout(this.editorPanel, 1));
        this.add((Component)this.instancePanel, "Before");
        this.add((Component)this.editorPanel, "After");
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(false);
        this.add((Component)this.progressBar, "Last");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(I18N.get("MainFrame.menu.file"));
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.menu.file.new.instance")){

            public void actionPerformed(ActionEvent actionEvent) {
                CubeInstance cubeInstance = new CubeInstance(MainFrame.this);
                cubeInstance.setName(I18N.get("MainFrame.default.instance") + " " + ++MainFrame.this.instanceCount);
                MainFrame.this.addInstance(cubeInstance);
            }
        }));
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.menu.file.new.editor")){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor editor = new Editor(MainFrame.this);
                editor.setName(I18N.get("MainFrame.default.editor") + " " + ++MainFrame.this.editorCount);
                MainFrame.this.addEditor(editor);
            }
        }));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.menu.file.open")){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            MainFrame.this.close();
                        }
                        catch (CanceledException canceledException) {
                            return;
                        }
                        JFileChooser jFileChooser = new JFileChooser(MainFrame.this.path);
                        jFileChooser.setFileFilter(new ExtensionFileFilter("arcus", I18N.get("Extension.arcus") + " (*.arcus)"));
                        if (jFileChooser.showOpenDialog(MainFrame.this) == 0) {
                            if (!MainFrame.this.load(jFileChooser.getSelectedFile(), false)) {
                                JOptionPane.showMessageDialog(MainFrame.this, I18N.get("Message.error.fopen"), I18N.get("Dialog.title.error"), 0);
                            } else {
                                MainFrame.this.setSessionFile(jFileChooser.getSelectedFile());
                            }
                        }
                    }
                };
                thread.start();
            }
        }));
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.menu.file.append")){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(MainFrame.this.path);
                jFileChooser.setFileFilter(new ExtensionFileFilter("arcus", I18N.get("Extension.arcus") + " (*.arcus)"));
                if (jFileChooser.showDialog(MainFrame.this, I18N.get("MainFrame.menu.file.append")) == 0) {
                    final File file = jFileChooser.getSelectedFile();
                    MainFrame.this.path = file.getParent();
                    Preferences.instance.set("sessionPath", MainFrame.this.path);
                    Preferences.instance.save();
                    Thread thread = new Thread(){

                        public void run() {
                            if (!MainFrame.this.load(file, true)) {
                                JOptionPane.showMessageDialog(MainFrame.this, I18N.get("Message.error.fopen"), I18N.get("Dialog.title.error"), 0);
                            }
                        }
                    };
                    thread.start();
                }
            }
        }));
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.menu.file.close")){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            MainFrame.this.close();
                        }
                        catch (CanceledException canceledException) {
                            // empty catch block
                        }
                    }
                };
                thread.start();
            }
        }));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.saveAction));
        this.saveAction.setEnabled(false);
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.menu.file.saveas")){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            MainFrame.this.saveAs();
                        }
                        catch (CanceledException canceledException) {
                            // empty catch block
                        }
                    }
                };
                thread.start();
            }
        }));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.menu.file.exit")){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.shutdown();
            }
        }));
        jMenuBar.add(jMenu);
        jMenu = new JMenu(I18N.get("MainFrame.menu.tabs"));
        final AbstractAction abstractAction = new AbstractAction(I18N.get("MainFrame.menu.tabs.display")){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedContainer.grEngineTabs.setVisible(((AbstractButton)actionEvent.getSource()).isSelected());
            }
        };
        abstractAction.setEnabled(false);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(abstractAction);
        TabbedContainer.grEngineTabs.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                abstractAction.setEnabled(true);
                jCheckBoxMenuItem.setSelected(true);
            }

            public void componentHidden(ComponentEvent componentEvent) {
                jCheckBoxMenuItem.setSelected(false);
                if (TabbedContainer.grEngineTabs.getTabCount() == 0) {
                    abstractAction.setEnabled(false);
                }
            }
        });
        final AbstractAction abstractAction2 = new AbstractAction(I18N.get("MainFrame.menu.tabs.console")){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedContainer.consoleTabs.setVisible(((AbstractButton)actionEvent.getSource()).isSelected());
            }
        };
        abstractAction2.setEnabled(false);
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(abstractAction2);
        TabbedContainer.consoleTabs.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                abstractAction2.setEnabled(true);
                jCheckBoxMenuItem2.setSelected(true);
            }

            public void componentHidden(ComponentEvent componentEvent) {
                jCheckBoxMenuItem2.setSelected(false);
                if (TabbedContainer.consoleTabs.getTabCount() == 0) {
                    abstractAction2.setEnabled(false);
                }
            }
        });
        final AbstractAction abstractAction3 = new AbstractAction(I18N.get("MainFrame.menu.tabs.history")){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedContainer.historyTabs.setVisible(((AbstractButton)actionEvent.getSource()).isSelected());
            }
        };
        abstractAction3.setEnabled(false);
        final JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem(abstractAction3);
        TabbedContainer.historyTabs.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                abstractAction3.setEnabled(true);
                jCheckBoxMenuItem3.setSelected(true);
            }

            public void componentHidden(ComponentEvent componentEvent) {
                jCheckBoxMenuItem3.setSelected(false);
                if (TabbedContainer.historyTabs.getTabCount() == 0) {
                    abstractAction3.setEnabled(false);
                }
            }
        });
        final AbstractAction abstractAction4 = new AbstractAction(I18N.get("MainFrame.menu.tabs.editor")){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedContainer.editorTabs.setVisible(((AbstractButton)actionEvent.getSource()).isSelected());
            }
        };
        abstractAction4.setEnabled(false);
        final JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem(abstractAction4);
        TabbedContainer.editorTabs.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                abstractAction4.setEnabled(true);
                jCheckBoxMenuItem4.setSelected(true);
            }

            public void componentHidden(ComponentEvent componentEvent) {
                jCheckBoxMenuItem4.setSelected(false);
                if (TabbedContainer.editorTabs.getTabCount() == 0) {
                    abstractAction4.setEnabled(false);
                }
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        jMenu.add(jCheckBoxMenuItem2);
        jMenu.add(jCheckBoxMenuItem3);
        jMenu.add(jCheckBoxMenuItem4);
        jMenuBar.add(jMenu);
        jMenu = new JMenu(I18N.get("MainFrame.menu.tools"));
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.menu.tools.pattern.store")){

            public void actionPerformed(ActionEvent actionEvent) {
                PatternStore.instance.setVisible(true);
            }
        }));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.menu.tools.preferences")){

            public void actionPerformed(ActionEvent actionEvent) {
                PrefUI.instance.setVisible(true);
            }
        }));
        jMenuBar.add(jMenu);
        jMenu = new JMenu(I18N.get("MainFrame.menu.help"));
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.menu.help.homepage")){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[]{(String)Preferences.instance.get("browser"), "firefox", "mozilla", "netscape", "opera", "konqueror", "safari", "rundll32 url.dll,FileProtocolHandler", "start"};
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        Runtime.getRuntime().exec(stringArray[i] + " " + Main.homepage);
                        return;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                Object[] objectArray = new Object[]{I18N.get("Button.yes"), I18N.get("Button.no")};
                if (JOptionPane.showOptionDialog(MainFrame.this, I18N.get("Message.error.browser.failed"), I18N.get("Dialog.title.error"), 0, 0, null, objectArray, objectArray[0]) == 0) {
                    PrefUI.instance.setSelectedTab("misc");
                    PrefUI.instance.setVisible(true);
                }
            }
        }));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.menu.help.about")){

            public void actionPerformed(ActionEvent actionEvent) {
                About.instance.setVisible(true);
            }
        }));
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.setSize(300, 100);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.shutdown();
            }
        });
    }

    private void addInstance(final CubeInstance cubeInstance) {
        this.modified = true;
        this.saveAction.setEnabled(true);
        this.instances.addElement(cubeInstance);
        final ToolBarPanel toolBarPanel = new ToolBarPanel();
        toolBarPanel.add(cubeInstance.graphicsEngine);
        toolBarPanel.addToolButton(new JButton(new AbstractAction(null, Images.getImageIcon("store")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!cubeInstance.graphicsEngine.isBusy()) {
                    PatternStore.instance.add(cubeInstance.graphicsEngine.getGraphicsDescriptor());
                }
            }
        }){
            {
                this.setToolTipText(I18N.get("View.add.to.pattern.store"));
            }
        });
        toolBarPanel.addToolBarSeparator();
        TabbedContainer.consoleTabs.addComponent(cubeInstance.console);
        TabbedContainer.historyTabs.addComponent(cubeInstance.history);
        TabbedContainer.grEngineTabs.addComponent(toolBarPanel);
        String string = cubeInstance.getName();
        MainFrame.setTitle(string, toolBarPanel);
        MainFrame.setTitle(string, cubeInstance.history);
        MainFrame.setTitle(string, cubeInstance.console);
        final JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.LIGHT_GRAY));
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.popup.detach"), Images.getImageIcon("tab2win")){

            public void actionPerformed(ActionEvent actionEvent) {
                Container container = SwingUtilities.getAncestorNamed("COMPONENT_HOLDER", toolBarPanel);
                if (container instanceof XTabbedPane) {
                    ((XTabbedPane)container).detach(toolBarPanel);
                }
                if ((container = SwingUtilities.getAncestorNamed("COMPONENT_HOLDER", cubeInstance.history)) instanceof XTabbedPane) {
                    ((XTabbedPane)container).detach(cubeInstance.history);
                }
                if ((container = SwingUtilities.getAncestorNamed("COMPONENT_HOLDER", cubeInstance.console)) instanceof XTabbedPane) {
                    ((XTabbedPane)container).detach(cubeInstance.console);
                }
            }
        }));
        jPopupMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.popup.attach"), Images.getImageIcon("win2tab")){

            public void actionPerformed(ActionEvent actionEvent) {
                Container container = SwingUtilities.getAncestorNamed("COMPONENT_HOLDER", toolBarPanel);
                if (container instanceof XFrame) {
                    ((XFrame)container).dispatchEvent(new WindowEvent(SwingUtilities.windowForComponent(MainFrame.this.instancePanel), 201));
                }
                if ((container = SwingUtilities.getAncestorNamed("COMPONENT_HOLDER", cubeInstance.history)) instanceof XFrame) {
                    ((XFrame)container).dispatchEvent(new WindowEvent(SwingUtilities.windowForComponent(MainFrame.this.instancePanel), 201));
                }
                if ((container = SwingUtilities.getAncestorNamed("COMPONENT_HOLDER", cubeInstance.console)) instanceof XFrame) {
                    ((XFrame)container).dispatchEvent(new WindowEvent(SwingUtilities.windowForComponent(MainFrame.this.instancePanel), 201));
                }
            }
        }));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(new AbstractAction(I18N.get("MainFrame.popup.show"), Images.getImageIcon("select")){

            public void actionPerformed(ActionEvent actionEvent) {
                Container container = SwingUtilities.getAncestorNamed("COMPONENT_HOLDER", toolBarPanel);
                if (container instanceof XFrame) {
                    ((XFrame)container).toFront();
                } else if (container instanceof XTabbedPane) {
                    ((XTabbedPane)container).setSelectedComponent(toolBarPanel);
                    TabbedContainer.grEngineTabs.toFront();
                    TabbedContainer.grEngineTabs.setVisible(true);
                }
                container = SwingUtilities.getAncestorNamed("COMPONENT_HOLDER", cubeInstance.history);
                if (container instanceof XFrame) {
                    ((XFrame)container).toFront();
                } else if (container instanceof XTabbedPane) {
                    ((XTabbedPane)container).setSelectedComponent(cubeInstance.history);
                    TabbedContainer.historyTabs.toFront();
                    TabbedContainer.historyTabs.setVisible(true);
                }
                container = SwingUtilities.getAncestorNamed("COMPONENT_HOLDER", cubeInstance.console);
                if (container instanceof XFrame) {
                    ((XFrame)container).toFront();
                } else if (container instanceof XTabbedPane) {
                    ((XTabbedPane)container).setSelectedComponent(cubeInstance.console);
                    TabbedContainer.consoleTabs.toFront();
                    TabbedContainer.consoleTabs.setVisible(true);
                }
            }
        }));
        final XTextField xTextField = new XTextField(string);
        xTextField.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = xTextField.getText();
                cubeInstance.setName(string);
                MainFrame.setTitle(string, toolBarPanel);
                MainFrame.setTitle(string, cubeInstance.history);
                MainFrame.setTitle(string, cubeInstance.console);
            }
        });
        JButton jButton = new JButton(new AbstractAction(null, Images.getImageIcon("clone")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (cubeInstance.getState() == 1) {
                    return;
                }
                CubeInstance cubeInstance2 = (CubeInstance)cubeInstance.clone();
                cubeInstance2.setName(cubeInstance.getName() + " " + I18N.get("MainFrame.default.clone"));
                MainFrame.this.addInstance(cubeInstance2);
            }
        }){
            {
                this.setToolTipText(I18N.get("MainFrame.button.clone"));
            }
        };
        JButton jButton2 = new JButton(new AbstractAction(null, Images.getImageIcon("kill")){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[]{I18N.get("Button.yes"), I18N.get("Button.no")};
                if (JOptionPane.showOptionDialog(MainFrame.this, I18N.get("Message.confirm.remove.instance"), I18N.get("Dialog.title.warning"), 0, 3, null, objectArray, objectArray[0]) == 0) {
                    TabbedContainer.grEngineTabs.removeComponent(toolBarPanel);
                    TabbedContainer.historyTabs.removeComponent(cubeInstance.history);
                    TabbedContainer.consoleTabs.removeComponent(cubeInstance.console);
                    MainFrame.this.instances.remove(cubeInstance);
                    MainFrame.this.instanceGUI.remove(jPanel);
                    MainFrame.this.instancePanel.remove(jPanel);
                    MainFrame.this.pack();
                    MainFrame.this.modified = true;
                    MainFrame.this.saveAction.setEnabled(true);
                }
            }
        }){
            {
                this.setToolTipText(I18N.get("MainFrame.remove"));
            }
        };
        final JButton jButton3 = new JButton();
        jButton3.setAction(new AbstractAction(null, Images.getImageIcon("window")){

            public void actionPerformed(ActionEvent actionEvent) {
                jPopupMenu.show(jButton3, 0, 0);
            }
        });
        AbstractAction abstractAction = new AbstractAction(null, Images.getImageIcon("scramble")){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = -10;
                int n2 = -10;
                int n3 = -10;
                int n4 = -10;
                for (int i = 0; i < 10; ++i) {
                    int n5;
                    do {
                        n = n3;
                        n2 = n4;
                        n3 = (int)(Math.random() * 3.0);
                        n4 = (int)(Math.random() * 3.0) - 1;
                        n5 = (int)(Math.random() * 3.0) - 1;
                    } while (n3 == n);
                    cubeInstance.addEvent(new CubeEvent(n3, n4, n5, 1, true));
                }
            }
        };
        toolBarPanel.addToolButton(new JButton(abstractAction){
            {
                this.setToolTipText(I18N.get("View.scramble"));
            }
        });
        toolBarPanel.addToolButton(new JButton(new AbstractAction(null, Images.getImageIcon("solve")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (cubeInstance.getState() != 0) {
                    JOptionPane.showMessageDialog(MainFrame.this, I18N.get("Message.invalid.state"), I18N.get("View.solve"), 2);
                    return;
                }
                LayerByLayerAlgorithm layerByLayerAlgorithm = new LayerByLayerAlgorithm(cubeInstance);
                layerByLayerAlgorithm.init(cubeInstance.graphicsEngine.getGraphicsDescriptor(), new BasicGraphicsEngine().getGraphicsDescriptor());
                new Thread(layerByLayerAlgorithm).start();
            }
        }){
            {
                this.setToolTipText(I18N.get("View.solve"));
            }
        });
        final JToggleButton jToggleButton = new JToggleButton();
        AbstractAction abstractAction2 = new AbstractAction(null, Images.getImageIcon("solve_as")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!jToggleButton.isSelected()) {
                    PatternGrabber.instance.delete();
                    return;
                }
                if (cubeInstance.getState() != 0) {
                    jToggleButton.setSelected(false);
                    return;
                }
                PatternGrabber.instance.activate(new AbstractAction(I18N.get("View.solve"), Images.getImageIcon("solve")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (cubeInstance.getState() != 0) {
                            JOptionPane.showMessageDialog(MainFrame.this, I18N.get("Message.invalid.state"), I18N.get("View.solve"), 2);
                            return;
                        }
                        if (!PatternGrabber.instance.isValid()) {
                            JOptionPane.showMessageDialog(MainFrame.this, I18N.get("Message.invalid.pattern"), I18N.get("View.solve"), 2);
                            return;
                        }
                        LayerByLayerAlgorithm layerByLayerAlgorithm = new LayerByLayerAlgorithm(cubeInstance);
                        layerByLayerAlgorithm.init(cubeInstance.graphicsEngine.getGraphicsDescriptor(), PatternGrabber.instance.getGraphicsDescriptor());
                        PatternGrabber.instance.delete();
                        jToggleButton.setSelected(false);
                        new Thread(layerByLayerAlgorithm).start();
                    }
                }, new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        jToggleButton.setSelected(false);
                    }
                });
            }
        };
        jToggleButton.setAction(abstractAction2);
        jToggleButton.setToolTipText(I18N.get("View.solveas"));
        toolBarPanel.addToolButton(jToggleButton);
        xTextField.setPreferredSize(new Dimension(100, 24));
        if (!UIManager.getLookAndFeel().getID().equals("Motif")) {
            jButton.setPreferredSize(new Dimension(24, 24));
            jButton2.setPreferredSize(new Dimension(24, 24));
            jButton3.setPreferredSize(new Dimension(24, 24));
        }
        jPanel.add(xTextField);
        jPanel.add(new JSeparator(1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        this.instanceGUI.addElement(jPanel);
        this.instancePanel.add(jPanel);
        this.pack();
    }

    public static void setTitle(String string, Component component) {
        Container container = SwingUtilities.getAncestorNamed("COMPONENT_HOLDER", component);
        if (container instanceof XFrame) {
            ((XFrame)container).setTitle(string);
        } else if (container instanceof XTabbedPane) {
            ((XTabbedPane)container).setTitleAt(((XTabbedPane)container).indexOfComponent(component), string);
        }
    }

    private void addEditor(final Editor editor) {
        this.modified = true;
        this.saveAction.setEnabled(true);
        this.editors.addElement(editor);
        TabbedContainer.editorTabs.addComponent(editor);
        String string = editor.getName();
        MainFrame.setTitle(string, editor);
        final JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, Color.LIGHT_GRAY));
        final XTextField xTextField = new XTextField(string);
        xTextField.setPreferredSize(new Dimension(100, 24));
        xTextField.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = xTextField.getText();
                editor.setName(string);
                MainFrame.setTitle(string, editor);
            }
        });
        JButton jButton = new JButton(new AbstractAction(null, Images.getImageIcon("kill")){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[]{I18N.get("Button.yes"), I18N.get("Button.no")};
                if (JOptionPane.showOptionDialog(MainFrame.this, I18N.get("Message.confirm.remove.editor"), I18N.get("Dialog.title.warning"), 0, 3, null, objectArray, objectArray[0]) == 0) {
                    TabbedContainer.editorTabs.removeComponent(editor);
                    MainFrame.this.editors.remove(editor);
                    MainFrame.this.editorGUI.remove(jPanel);
                    MainFrame.this.editorPanel.remove(jPanel);
                    MainFrame.this.pack();
                    MainFrame.this.modified = true;
                    MainFrame.this.saveAction.setEnabled(true);
                }
            }
        }){
            {
                this.setToolTipText(I18N.get("MainFrame.remove"));
            }
        };
        JButton jButton2 = new JButton(new AbstractAction(null, Images.getImageIcon("clone")){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor editor2 = (Editor)editor.clone();
                editor2.setName(editor.getName() + " " + I18N.get("MainFrame.default.clone"));
                MainFrame.this.addEditor(editor2);
            }
        }){
            {
                this.setToolTipText(I18N.get("MainFrame.button.clone"));
            }
        };
        if (!UIManager.getLookAndFeel().getID().equals("Motif")) {
            jButton2.setPreferredSize(new Dimension(24, 24));
            jButton.setPreferredSize(new Dimension(24, 24));
        }
        jPanel.add(xTextField);
        jPanel.add(new JSeparator(1));
        jPanel.add(jButton2);
        jPanel.add(jButton);
        this.editorGUI.addElement(jPanel);
        this.editorPanel.add(jPanel);
        this.pack();
    }

    public void setModified(boolean bl) {
        this.saveAction.setEnabled(bl);
        this.modified = bl;
    }

    private boolean isModified() {
        int n;
        for (n = 0; n < this.instances.size(); ++n) {
            if (!this.instances.get(n).isModified()) continue;
            return true;
        }
        for (n = 0; n < this.editors.size(); ++n) {
            if (!this.editors.get(n).isModified()) continue;
            return true;
        }
        return this.modified;
    }

    private void close() throws CanceledException {
        Object[] objectArray = new Object[]{I18N.get("Button.save"), I18N.get("Button.dontsave"), I18N.get("Button.cancel")};
        if (this.isModified()) {
            int n = JOptionPane.showOptionDialog(this, I18N.get("Message.confirm.save.session"), I18N.get("MainFrame.menu.file.close"), 1, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                this.save(this.file);
            } else if (n == 2 || n == -1) {
                throw new CanceledException();
            }
        }
        this.instances = new Vector();
        this.instanceGUI = new Vector();
        this.editors = new Vector();
        this.editorGUI = new Vector();
        this.instancePanel.removeAll();
        this.editorPanel.removeAll();
        TabbedContainer.grEngineTabs.removeAll();
        TabbedContainer.historyTabs.removeAll();
        TabbedContainer.consoleTabs.removeAll();
        TabbedContainer.editorTabs.removeAll();
        this.instanceCount = 0;
        this.editorCount = 0;
        this.file = null;
        this.setTitle("Arcus");
        this.pack();
        this.setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(File file, boolean bl) {
        boolean bl2;
        try {
            Cloneable cloneable;
            int n;
            XMLDecoder xMLDecoder = new XMLDecoder(new GZIPInputStream(new FileInputStream(file)));
            bl2 = false;
            Object object = xMLDecoder.readObject();
            if (object instanceof String) {
                if (!((String)object).startsWith("arcus.session")) {
                    xMLDecoder.close();
                    boolean bl3 = false;
                    return bl3;
                }
                object = xMLDecoder.readObject();
            } else {
                bl2 = true;
            }
            int n2 = (Integer)object;
            this.progressBar.setVisible(true);
            this.progressBar.setMaximum(n2);
            this.progressBar.setValue(0);
            for (n = 0; n < n2; ++n) {
                cloneable = new CubeInstance(this);
                ((CubeInstance)cloneable).setName((String)xMLDecoder.readObject());
                ((CubeInstance)cloneable).history.load(xMLDecoder);
                ((CubeInstance)cloneable).console.load(xMLDecoder);
                ((CubeInstance)cloneable).setModified(false);
                this.addInstance((CubeInstance)cloneable);
                ++this.instanceCount;
                this.progressBar.setValue(n + 1);
            }
            n2 = (Integer)xMLDecoder.readObject();
            this.progressBar.setMaximum(n2);
            this.progressBar.setValue(0);
            for (n = 0; n < n2; ++n) {
                cloneable = new Editor(this);
                ((Editor)cloneable).setName((String)xMLDecoder.readObject());
                ((Editor)cloneable).load(xMLDecoder);
                ((Editor)cloneable).setModified(false);
                this.addEditor((Editor)cloneable);
                ++this.editorCount;
                this.progressBar.setValue(n + 1);
            }
            xMLDecoder.close();
            this.setModified(bl || bl2);
            if (bl2) {
                JOptionPane.showMessageDialog(this, I18N.get("Message.update.session"), I18N.get("Dialog.title.info"), 1);
            }
        }
        catch (Exception exception) {
            this.setModified(false);
            bl2 = false;
            return bl2;
        }
        finally {
            this.progressBar.setVisible(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(File file) throws CanceledException {
        if (file == null) {
            this.saveAs();
            return;
        }
        try {
            int n;
            XMLEncoder xMLEncoder = new XMLEncoder(new GZIPOutputStream(new FileOutputStream(file)));
            xMLEncoder.writeObject(new String("arcus.session." + new Version()));
            xMLEncoder.writeObject(new Integer(this.instances.size()));
            this.progressBar.setVisible(true);
            this.progressBar.setMaximum(this.instances.size());
            this.progressBar.setValue(0);
            for (n = 0; n < this.instances.size(); ++n) {
                xMLEncoder.writeObject(this.instances.get(n).getName());
                this.instances.get((int)n).history.save(xMLEncoder);
                this.instances.get((int)n).console.save(xMLEncoder);
                this.instances.get(n).setModified(false);
                this.progressBar.setValue(n + 1);
            }
            xMLEncoder.writeObject(new Integer(this.editors.size()));
            this.progressBar.setMaximum(this.editors.size());
            this.progressBar.setValue(0);
            for (n = 0; n < this.editors.size(); ++n) {
                xMLEncoder.writeObject(this.editors.get(n).getName());
                this.editors.get(n).save(xMLEncoder);
                this.editors.get(n).setModified(false);
                this.progressBar.setValue(n + 1);
            }
            this.setModified(false);
            xMLEncoder.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, I18N.get("Message.error.fsave") + "\n" + exception, I18N.get("Dialog.title.error"), 0);
        }
        finally {
            this.progressBar.setVisible(false);
        }
    }

    private void saveAs() throws CanceledException {
        File file;
        JFileChooser jFileChooser = new JFileChooser(this.path);
        jFileChooser.setFileFilter(new ExtensionFileFilter("arcus", I18N.get("Extension.arcus") + " (*.arcus)"));
        if (jFileChooser.showDialog(this, I18N.get("MainFrame.menu.file.saveas")) == 0) {
            file = jFileChooser.getSelectedFile();
            this.path = file.getParent();
            Preferences.instance.set("sessionPath", this.path);
            Preferences.instance.save();
            if (!file.toString().endsWith(".arcus")) {
                file = new File(file.toString() + ".arcus");
            }
            if (file.exists()) {
                Object[] objectArray = new Object[]{I18N.get("Button.yes"), I18N.get("Button.no")};
                if (JOptionPane.showOptionDialog(this, I18N.get("Message.confirm.overwrite"), I18N.get("MainFrame.menu.file.saveas"), 0, 3, null, objectArray, objectArray[0]) != 0) {
                    throw new CanceledException();
                }
            }
        } else {
            throw new CanceledException();
        }
        this.file = file;
        this.setTitle(this.file + " - Arcus");
        this.save(this.file);
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super(I18N.get("MainFrame.menu.file.save"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        MainFrame.this.save(MainFrame.this.file);
                    }
                    catch (CanceledException canceledException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        }
    }
}

