/*
 * Decompiled with CFR 0.152.
 */
package arcus.gui;

import arcus.gui.BasicGraphicsEngine;
import arcus.gui.PatternStore;
import arcus.model.Preferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class StoreGraphicsEngine
extends BasicGraphicsEngine
implements FocusListener {
    private static boolean dragInProgress = false;
    private boolean hasMouseOver = false;

    public StoreGraphicsEngine() {
        this.addFocusListener(this);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isFocusOwner()) {
            graphics2D.setPaint(Color.BLUE);
            graphics2D.drawRoundRect(2, 2, this.dim.width - 5, this.dim.height - 5, 5, 5);
        } else if (dragInProgress && this.hasMouseOver) {
            graphics2D.setPaint(Color.GRAY);
            graphics2D.drawRoundRect(2, 2, this.dim.width - 5, this.dim.height - 5, 5, 5);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (mouseEvent.getButton() == Preferences.instance.getInt("mouseButtonTurn")) {
            PatternStore.instance.setCursor(Cursor.getPredefinedCursor(12));
            dragInProgress = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (mouseEvent.getButton() == Preferences.instance.getInt("mouseButtonTurn")) {
            PatternStore.instance.setCursor(null);
            dragInProgress = false;
            Point point = SwingUtilities.convertPoint(this, mouseEvent.getX(), mouseEvent.getY(), PatternStore.instance);
            Component component = SwingUtilities.getDeepestComponentAt(PatternStore.instance, point.x, point.y);
            if (component instanceof StoreGraphicsEngine) {
                PatternStore.instance.move(this, (StoreGraphicsEngine)component);
                component.requestFocusInWindow();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        this.hasMouseOver = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        this.hasMouseOver = false;
        this.repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }
}

