/*
 * Decompiled with CFR 0.152.
 */
package arcus.model;

import arcus.I18N;
import arcus.model.CubeEvent;
import arcus.model.CubeInstance;
import arcus.model.ParserException;
import arcus.model.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parser {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public String F = (String)Preferences.instance.get("F");
    public String B = (String)Preferences.instance.get("B");
    public String D = (String)Preferences.instance.get("D");
    public String U = (String)Preferences.instance.get("U");
    public String R = (String)Preferences.instance.get("R");
    public String L = (String)Preferences.instance.get("L");
    public String CWISE = (String)Preferences.instance.get("cwise");
    public String CCWISE = (String)Preferences.instance.get("ccwise");
    public String TWICE = (String)Preferences.instance.get("twice");
    public String OUTER = (String)Preferences.instance.get("outer");
    public String INNER = (String)Preferences.instance.get("inner");
    public String PAR = (String)Preferences.instance.get("par");
    public String ALL = (String)Preferences.instance.get("all");
    public boolean success = false;
    private String ILL_CHAR_REGEX = "[^" + this.F + this.B + this.D + this.U + this.R + this.L + this.CWISE + this.CCWISE + this.TWICE + this.OUTER + this.INNER + this.PAR + this.ALL + " ()0-9]";
    private String CMD_REGEX = "[" + this.F + this.B + this.D + this.U + this.R + this.L + "]" + "[" + this.OUTER + this.INNER + this.PAR + this.ALL + "]?" + "[" + this.CWISE + this.CCWISE + this.TWICE + "]?";
    private String MAC_REGEX = "(\\()((" + this.CMD_REGEX + ")+)" + "(" + "\\)" + ")" + "(" + "\\d+" + ")";

    public String parse(String string, CubeInstance cubeInstance) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.checkSyntax(new StringBuilder(string));
            this.perform(this.expand(new StringBuilder(string.replaceAll(" ", ""))), cubeInstance);
            this.success = true;
        }
        catch (ParserException parserException) {
            this.success = false;
            while (parserException.next()) {
                stringBuilder.append(parserException.msg + "\n");
                stringBuilder.append(string + "\n");
                for (int i = 0; i < parserException.pos; ++i) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append("^\n\n");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void checkSyntax(StringBuilder var1_1) throws ParserException {
        var2_2 = new ParserException();
        var3_3 = Pattern.compile(this.ILL_CHAR_REGEX).matcher(var1_1);
        while (var3_3.find()) {
            var2_2.add(I18N.get("Parser.error.illegal.char"), var3_3.start());
            var1_1.setCharAt(var3_3.start(), ' ');
        }
        var3_3 = Pattern.compile("\\) *[^ 0-9]").matcher(var1_1);
        while (var3_3.find()) {
            var2_2.add(I18N.get("Parser.error.num.expected"), var3_3.start());
        }
        var3_3 = Pattern.compile("\\) *$").matcher(var1_1);
        if (var3_3.find()) {
            var2_2.add(I18N.get("Parser.error.num.expected"), var3_3.start());
        }
        while (true) lbl-1000:
        // 4 sources

        {
            for (var4_4 = 0; var4_4 < var1_1.length() && var1_1.charAt(var4_4) != '('; ++var4_4) {
            }
            if (var4_4 == var1_1.length()) break;
            var5_5 = var4_4;
            var6_6 = 0;
            do {
                if (var1_1.charAt(var5_5) == '(') {
                    ++var6_6;
                }
                if (var1_1.charAt(var5_5) != ')') continue;
                --var6_6;
            } while (var6_6 > 0 && ++var5_5 < var1_1.length());
            var1_1.setCharAt(var4_4, ' ');
            if (var6_6 > 0) {
                var2_2.add(I18N.get("Parser.error.parentheses"), var4_4);
                ** continue;
            }
            var1_1.setCharAt(var5_5, ' ');
            var7_7 = var5_5;
            while (true) {
                if (var7_7 < var1_1.length() && (var1_1.charAt(var7_7) == ' ' || Character.isDigit(var1_1.charAt(var7_7)))) ** break;
                ** continue;
                var1_1.setCharAt(var7_7, ' ');
                ++var7_7;
            }
            break;
        }
        var3_3 = Pattern.compile("\\) *[0-9]*").matcher(var1_1);
        while (var3_3.find()) {
            var2_2.add(I18N.get("Parser.error.parentheses"), var3_3.start());
            for (var4_4 = var3_3.start(); var4_4 < var3_3.end(); ++var4_4) {
                var1_1.setCharAt(var4_4, ' ');
            }
        }
        var4_4 = 0;
        var5_5 = 0;
        var3_3 = Pattern.compile(" *" + this.CMD_REGEX + " *").matcher(var1_1);
        while (var3_3.find()) {
            var4_4 = var3_3.start();
            if (var4_4 != var5_5) {
                var2_2.add(I18N.get("Parser.error.syntax"), var5_5);
            }
            var5_5 = var3_3.end();
        }
        if (var1_1.length() != var5_5) {
            var2_2.add(I18N.get("Parser.error.syntax"), var5_5);
        }
        if (var2_2.isDirty()) {
            throw var2_2;
        }
    }

    private String expand(StringBuilder stringBuilder) {
        boolean bl = false;
        Pattern pattern = Pattern.compile(this.MAC_REGEX);
        do {
            Matcher matcher;
            if ((matcher = pattern.matcher(stringBuilder)).find()) {
                StringBuilder stringBuilder2 = new StringBuilder();
                int n = new Integer(matcher.group(5));
                for (int i = 0; i < n; ++i) {
                    stringBuilder2.append(matcher.group(2));
                }
                stringBuilder.replace(matcher.start(), matcher.end(), stringBuilder2.toString());
                bl = true;
                continue;
            }
            bl = false;
        } while (bl);
        return stringBuilder.toString();
    }

    private void perform(String string, CubeInstance cubeInstance) {
        Matcher matcher = Pattern.compile(this.CMD_REGEX).matcher(string);
        while (matcher.find()) {
            int n = 0;
            int n2 = 0;
            if (matcher.group().matches(this.R + ".*")) {
                n = 0;
                n2 = 1;
            } else if (matcher.group().matches(this.L + ".*")) {
                n = 0;
                n2 = -1;
            } else if (matcher.group().matches(this.D + ".*")) {
                n = 1;
                n2 = -1;
            } else if (matcher.group().matches(this.U + ".*")) {
                n = 1;
                n2 = 1;
            } else if (matcher.group().matches(this.F + ".*")) {
                n = 2;
                n2 = 1;
            } else if (matcher.group().matches(this.B + ".*")) {
                n = 2;
                n2 = -1;
            }
            int n3 = -10;
            if (matcher.group().matches(".*" + this.CWISE + ".*") && this.CWISE.length() > 0) {
                n3 = -1;
            } else if (matcher.group().matches(".*" + this.CCWISE + ".*") && this.CCWISE.length() > 0) {
                n3 = 1;
            } else if (matcher.group().matches(".*" + this.TWICE + ".*") && this.TWICE.length() > 0) {
                n3 = 0;
            }
            if (n3 == -10) {
                if (this.CWISE.length() == 0) {
                    n3 = -1;
                } else if (this.CCWISE.length() == 0) {
                    n3 = 1;
                } else if (this.TWICE.length() == 0) {
                    n3 = 0;
                }
            }
            n3 *= n2;
            int n4 = -10;
            int n5 = -10;
            int n6 = -10;
            if (matcher.group().matches("." + this.OUTER + ".*") && this.OUTER.length() > 0) {
                n4 = 1;
            } else if (matcher.group().matches("." + this.INNER + ".*") && this.INNER.length() > 0) {
                n4 = 0;
            } else if (matcher.group().matches("." + this.PAR + ".*") && this.PAR.length() > 0) {
                n4 = 1;
                n5 = -1;
            } else if (matcher.group().matches("." + this.ALL + ".*") && this.ALL.length() > 0) {
                n4 = 1;
                n5 = 0;
                n6 = -1;
            }
            if (n4 == -10) {
                if (this.OUTER.length() == 0) {
                    n4 = 1;
                } else if (this.INNER.length() == 0) {
                    n4 = 0;
                } else if (this.PAR.length() == 0) {
                    n4 = 1;
                    n5 = -1;
                } else if (this.ALL.length() == 0) {
                    n4 = 1;
                    n5 = 0;
                    n6 = -1;
                }
            }
            cubeInstance.addEvent(new CubeEvent(n, n4 *= n2, n3, 3, true));
            if (n5 != -10) {
                cubeInstance.addEvent(new CubeEvent(n, n5 *= n2, n3, 3, true));
            }
            if (n6 == -10) continue;
            cubeInstance.addEvent(new CubeEvent(n, n6 *= n2, n3, 3, true));
        }
    }

    public String coordsToString(int n, int n2, int n3) {
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        if (n == 0) {
            string = n2 == -1 ? this.L : this.R;
        }
        if (n == 1) {
            string = n2 == -1 ? this.D : this.U;
        }
        if (n == 2) {
            string = n2 == -1 ? this.B : this.F;
        }
        string2 = n2 == 0 ? this.INNER : this.OUTER;
        int n4 = 0;
        n4 = n2 != 0 ? n3 * n2 : n3;
        switch (n4) {
            case -2: 
            case 0: 
            case 2: {
                string3 = this.TWICE;
                break;
            }
            case -1: {
                string3 = this.CWISE;
                break;
            }
            case 1: {
                string3 = this.CCWISE;
            }
        }
        return string + string2 + string3;
    }
}

