/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class ScoreBoard
extends JPanel
implements Runnable {
    private int time;
    private Thread clock;
    private LCDPanel scoreDisplay;
    private LCDPanel clockDisplay;
    private GameButton button;

    ScoreBoard() {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLoweredBevelBorder()));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.scoreDisplay = new LCDPanel(3);
        this.scoreDisplay.setToolTipText("Remaining mines");
        JMines.setConstraints(gridBagConstraints, 0, 0, 1, 1, 30, 100, 5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.scoreDisplay, gridBagConstraints);
        this.add(this.scoreDisplay);
        this.button = new GameButton();
        JMines.setConstraints(gridBagConstraints, 1, 0, 1, 1, 40, 0, 5, 5, 5, 5);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.button, gridBagConstraints);
        this.add(this.button);
        this.clockDisplay = new LCDPanel(3);
        this.clockDisplay.setToolTipText("Play time");
        JMines.setConstraints(gridBagConstraints, 2, 0, 1, 1, 30, 0, 5, 0, 5, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.clockDisplay, gridBagConstraints);
        this.add(this.clockDisplay);
    }

    GameButton getButton() {
        return this.button;
    }

    Thread getClock() {
        return this.clock;
    }

    void initButton() {
        this.button.setImage(0);
    }

    void initScore() {
        this.scoreDisplay.setText(String.valueOf(JMines.getGamePanel().getMines()));
    }

    void initClock() {
        this.stopClock();
        this.time = 0;
        this.clockDisplay.setText(String.valueOf(0));
    }

    void setScore(int n) {
        this.scoreDisplay.setText(String.valueOf(n));
    }

    int getTime() {
        return this.time;
    }

    void startClock() {
        if (this.clock == null) {
            this.clock = new Thread(this);
            this.clock.start();
        }
    }

    void stopClock() {
        if (this.clock != null) {
            this.clock = null;
        }
    }

    public void run() {
        long l = 0L;
        long l2 = System.currentTimeMillis();
        while (this.clock != null) {
            if (JMines.isSoundOn()) {
                JMines.getSoundPlayer().play("sounds/clock.wav");
            }
            this.clockDisplay.setText(String.valueOf(this.time));
            if (this.time == 999) {
                if (JMines.isSoundOn()) {
                    JMines.getSoundPlayer().play("sounds/time.wav");
                }
                JMines.gameOver(false, "Time has elapsed! Game over...");
            }
            l2 += 1000L;
            while (l2 > (l = System.currentTimeMillis())) {
                try {
                    Thread.sleep(l2 - l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.time;
        }
    }

    final class LCDPanel
    extends JPanel {
        private JLabel[] digits;
        private ImageIcon blank = new ImageIcon(this.getClass().getClassLoader().getResource("images/blank.gif"));
        private ImageIcon minus = new ImageIcon(this.getClass().getClassLoader().getResource("images/minus.gif"));
        private ImageIcon number0 = new ImageIcon(this.getClass().getClassLoader().getResource("images/0.gif"));
        private ImageIcon number1 = new ImageIcon(this.getClass().getClassLoader().getResource("images/1.gif"));
        private ImageIcon number2 = new ImageIcon(this.getClass().getClassLoader().getResource("images/2.gif"));
        private ImageIcon number3 = new ImageIcon(this.getClass().getClassLoader().getResource("images/3.gif"));
        private ImageIcon number4 = new ImageIcon(this.getClass().getClassLoader().getResource("images/4.gif"));
        private ImageIcon number5 = new ImageIcon(this.getClass().getClassLoader().getResource("images/5.gif"));
        private ImageIcon number6 = new ImageIcon(this.getClass().getClassLoader().getResource("images/6.gif"));
        private ImageIcon number7 = new ImageIcon(this.getClass().getClassLoader().getResource("images/7.gif"));
        private ImageIcon number8 = new ImageIcon(this.getClass().getClassLoader().getResource("images/8.gif"));
        private ImageIcon number9 = new ImageIcon(this.getClass().getClassLoader().getResource("images/9.gif"));

        LCDPanel(int n) {
            this.setBackground(Color.black);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.darkGray), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.setLayout(new GridLayout(1, n));
            this.digits = new JLabel[n];
            int n2 = 0;
            while (n2 < n) {
                this.digits[n2] = new JLabel(this.blank);
                this.add(this.digits[n2]);
                n2 = (byte)(n2 + 1);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void setText(String var1_1) {
            block15: {
                if (var1_1.length() <= this.digits.length) ** GOTO lbl5
                var1_1 = var1_1.substring(0, this.digits.length);
                break block15;
lbl-1000:
                // 1 sources

                {
                    var1_1 = " ".concat(var1_1);
lbl5:
                    // 2 sources

                    ** while (var1_1.length() < this.digits.length)
                }
            }
            var2_2 = 0;
            while (var2_2 < this.digits.length) {
                switch (var1_1.charAt(var2_2)) {
                    case '0': {
                        this.digits[var2_2].setIcon(this.number0);
                        break;
                    }
                    case '1': {
                        this.digits[var2_2].setIcon(this.number1);
                        break;
                    }
                    case '2': {
                        this.digits[var2_2].setIcon(this.number2);
                        break;
                    }
                    case '3': {
                        this.digits[var2_2].setIcon(this.number3);
                        break;
                    }
                    case '4': {
                        this.digits[var2_2].setIcon(this.number4);
                        break;
                    }
                    case '5': {
                        this.digits[var2_2].setIcon(this.number5);
                        break;
                    }
                    case '6': {
                        this.digits[var2_2].setIcon(this.number6);
                        break;
                    }
                    case '7': {
                        this.digits[var2_2].setIcon(this.number7);
                        break;
                    }
                    case '8': {
                        this.digits[var2_2].setIcon(this.number8);
                        break;
                    }
                    case '9': {
                        this.digits[var2_2].setIcon(this.number9);
                        break;
                    }
                    case '-': {
                        this.digits[var2_2].setIcon(this.minus);
                        break;
                    }
                    default: {
                        this.digits[var2_2].setIcon(this.blank);
                    }
                }
                ++var2_2;
            }
        }
    }

    final class GameButton
    extends JButton {
        private ImageIcon thinking = new ImageIcon(this.getClass().getClassLoader().getResource("images/thinking.gif"));
        private ImageIcon thumbsup = new ImageIcon(this.getClass().getClassLoader().getResource("images/thumbsup.gif"));
        private ImageIcon nyanya = new ImageIcon(this.getClass().getClassLoader().getResource("images/nyanya.gif"));
        private ImageIcon gun = new ImageIcon(this.getClass().getClassLoader().getResource("images/gun.gif"));
        private ImageIcon eatme = new ImageIcon(this.getClass().getClassLoader().getResource("images/eatme.gif"));

        GameButton() {
            this.setIcon(this.thinking);
            this.setPressedIcon(this.gun);
            this.setToolTipText("\"Click me to start a new game\"");
            this.setFocusable(false);
            this.addActionListener(new AbstractAction(this){
                private final /* synthetic */ GameButton this$1;
                {
                    this.this$1 = gameButton;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JMines.getStatusBar().setText(null);
                    JMines.startNewGame();
                }
            });
        }

        void setImage(int n) {
            if (n == 1) {
                this.setIcon(this.nyanya);
            } else if (n == 2) {
                this.setIcon(this.thumbsup);
            } else if (n == 3) {
                this.setIcon(this.eatme);
            } else {
                this.setIcon(this.thinking);
            }
        }

        public Insets getInsets() {
            return new Insets(4, 5, 4, 4);
        }
    }
}

