/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

final class StatusBar
extends JPanel {
    private JLabel message;
    private Clock clock;
    private JPopupMenu popup;

    StatusBar() {
        this.setLayout(new BorderLayout());
        this.message = new JLabel("Welcome to JMines");
        this.message.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(1), new EmptyBorder(2, 5, 2, 5)));
        this.add(this.message);
        this.clock = new Clock();
        this.clock.setVisible(JMines.getConfig().read("clock.visible", false));
        this.add((Component)this.clock, "East");
        this.popup = new JPopupMenu();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show clock", this.clock.isVisible());
        jCheckBoxMenuItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusBar.this.clock.setVisible(!StatusBar.this.clock.isVisible());
                JMines.getConfig().write("clock.visible", StatusBar.this.clock.isVisible());
            }
        });
        this.popup.add(jCheckBoxMenuItem);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StatusBar.this.popup.show(JMines.getStatusBar(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StatusBar.this.popup.show(JMines.getStatusBar(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.setPreferredSize(new Dimension(this.getSize().width, fontMetrics.getHeight() + fontMetrics.getHeight() / 2));
    }

    public void setText(String string) {
        this.message.setText(string);
    }
}

