/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CachedRow;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowOutputBinary
extends RowOutputBase {
    private static final int INT_STORE_SIZE = 4;
    int storageSize;

    public RowOutputBinary() {
    }

    public RowOutputBinary(int n) {
        super(n);
    }

    public RowOutputBinary(byte[] byArray) {
        super(byArray);
    }

    @Override
    public void writeShortData(short s) {
        this.writeShort(s);
    }

    @Override
    public void writeIntData(int n) {
        this.writeInt(n);
    }

    @Override
    public void writeIntData(int n, int n2) {
        int n3 = this.count;
        this.count = n2;
        this.writeInt(n);
        if (this.count < n3) {
            this.count = n3;
        }
    }

    @Override
    public void writeLongData(long l) {
        this.writeLong(l);
    }

    @Override
    public void writeEnd() {
        while (this.count < this.storageSize) {
            this.write(0);
        }
    }

    @Override
    public void writeSize(int n) {
        this.storageSize = n;
        this.writeInt(n);
    }

    @Override
    public void writeType(int n) {
        this.writeShort(n);
    }

    @Override
    public void writeString(String string) {
        int n = this.count;
        this.writeInt(0);
        StringConverter.writeUTF(string, this);
        this.writeIntData(this.count - n - 4, n);
    }

    @Override
    public int getSize(CachedRow cachedRow) {
        Object[] objectArray = cachedRow.getData();
        int[] nArray = cachedRow.getTable().getColumnTypes();
        int n = cachedRow.getTable().getColumnCount();
        return 4 + RowOutputBinary.getSize(objectArray, n, nArray);
    }

    public static int getRowSize(CachedRow cachedRow) {
        Object[] objectArray = cachedRow.getData();
        int[] nArray = cachedRow.getTable().getColumnTypes();
        int n = cachedRow.getTable().getColumnCount();
        return RowOutputBinary.getSize(objectArray, n, nArray);
    }

    @Override
    protected void writeFieldType(int n) {
        this.write(1);
    }

    @Override
    protected void writeNull(int n) {
        this.write(0);
    }

    @Override
    protected void writeChar(String string, int n) {
        this.writeString(string);
    }

    @Override
    protected void writeSmallint(Number number) {
        this.writeShort(number.intValue());
    }

    @Override
    protected void writeInteger(Number number) {
        this.writeInt(number.intValue());
    }

    @Override
    protected void writeBigint(Number number) {
        this.writeLong(number.longValue());
    }

    @Override
    protected void writeReal(Double d, int n) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    protected void writeDecimal(BigDecimal bigDecimal) {
        int n = bigDecimal.scale();
        BigInteger bigInteger = JavaSystem.getUnscaledValue(bigDecimal);
        byte[] byArray = bigInteger.toByteArray();
        this.writeByteArray(byArray);
        this.writeInt(n);
    }

    @Override
    protected void writeBit(Boolean bl) {
        this.write(bl != false ? 1 : 0);
    }

    @Override
    protected void writeDate(Date date) {
        this.writeLong(date.getTime());
    }

    @Override
    protected void writeTime(Time time) {
        this.writeLong(time.getTime());
    }

    @Override
    protected void writeTimestamp(Timestamp timestamp) {
        this.writeLong(timestamp.getTime());
        this.writeInt(timestamp.getNanos());
    }

    @Override
    protected void writeOther(JavaObject javaObject) {
        this.writeByteArray(javaObject.getBytes());
    }

    @Override
    protected void writeBinary(Binary binary, int n) {
        this.writeByteArray(binary.getBytes());
    }

    protected void writeByteArray(byte[] byArray) {
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    private static int getSize(Object[] objectArray, int n, int[] nArray) {
        int n2 = 0;
        block12: for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            ++n2;
            if (object == null) continue;
            switch (nArray[i]) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 100: {
                    n2 += 4;
                    n2 += StringConverter.getUTFSize((String)object);
                    continue block12;
                }
                case -6: 
                case 5: {
                    n2 += 2;
                    continue block12;
                }
                case 4: {
                    n2 += 4;
                    continue block12;
                }
                case -5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 += 8;
                    continue block12;
                }
                case 2: 
                case 3: {
                    n2 += 8;
                    BigDecimal bigDecimal = (BigDecimal)object;
                    BigInteger bigInteger = JavaSystem.getUnscaledValue(bigDecimal);
                    n2 += bigInteger.toByteArray().length;
                    continue block12;
                }
                case 16: {
                    ++n2;
                    continue block12;
                }
                case 91: 
                case 92: {
                    n2 += 8;
                    continue block12;
                }
                case 93: {
                    n2 += 12;
                    continue block12;
                }
                case -4: 
                case -3: 
                case -2: {
                    n2 += 4;
                    n2 += ((Binary)object).getBytesLength();
                    continue block12;
                }
                case 1111: {
                    JavaObject javaObject = (JavaObject)object;
                    n2 += 4;
                    n2 += javaObject.getBytesLength();
                    continue block12;
                }
                default: {
                    Trace.printSystemOut("20 " + Types.getTypeString(nArray[i]));
                }
            }
        }
        return n2;
    }

    @Override
    public void ensureRoom(int n) {
        super.ensureRoom(n);
    }

    @Override
    public void reset() {
        super.reset();
        this.storageSize = 0;
    }

    @Override
    public void reset(int n) {
        super.reset(n);
        this.storageSize = 0;
    }

    @Override
    public void setBuffer(byte[] byArray) {
        this.buffer = byArray;
        this.reset();
    }
}

