/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

final class Clock
extends JLabel
implements Runnable,
MouseListener {
    private Thread timeThread;
    private boolean isTimeMode = Jetris.getConfig().readKey("clockistimemode", true);
    private DateFormat tf = DateFormat.getTimeInstance(2);
    private DateFormat df = DateFormat.getDateInstance(0);

    Clock() {
        this.setHorizontalAlignment(0);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new EtchedBorder(1), new EmptyBorder(2, 5, 2, 5));
        this.setBorder(compoundBorder);
        this.addMouseListener(this);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.setTime(System.currentTimeMillis());
            this.start();
        } else {
            this.stop();
        }
    }

    public void start() {
        if (this.timeThread == null) {
            this.timeThread = new Thread(this);
            this.timeThread.start();
        }
    }

    public void stop() {
        if (this.timeThread != null) {
            this.timeThread = null;
        }
    }

    private void setTime(long l) {
        Date date = new Date(l);
        this.setText(this.isTimeMode ? this.tf.format(date) : this.df.format(date));
        this.setToolTipText(this.isTimeMode ? this.df.format(date) : this.tf.format(date));
    }

    public void run() {
        long l = 0L;
        long l2 = System.currentTimeMillis();
        while (this.timeThread != null) {
            l2 += 1000L;
            while (l2 > (l = System.currentTimeMillis())) {
                try {
                    Thread.sleep(l2 - l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.setTime(l);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.isTimeMode = !this.isTimeMode;
            this.setTime(System.currentTimeMillis());
            Jetris.getConfig().writeKey("clockistimemode", this.isTimeMode);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

