/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JFrame;

final class JetrisFrame
extends JFrame
implements FocusListener,
LocationSizeListener {
    private int x;
    private int y;
    private int width = 280;
    private int height = 625;

    JetrisFrame() {
        super("Jetris");
        this.setDefaultCloseOperation(3);
        this.addComponentListener(new JetrisComponentListener());
        this.addWindowListener(new JetrisWindowListener());
        this.addFocusListener(this);
        this.x = Jetris.getConfig().readKey("gameframexpos", 0);
        this.y = Jetris.getConfig().readKey("gameframeypos", 0);
        this.width = Jetris.getConfig().readKey("gameframewidth", this.width);
        this.height = Jetris.getConfig().readKey("gameframeheight", this.height);
        this.setBounds(this.x, this.y, this.width, this.height);
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void focusGained(FocusEvent focusEvent) {
        Jetris.gamePanel.requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void writeConfig() {
        Jetris.getConfig().writeKey("gameframexpos", this.x);
        Jetris.getConfig().writeKey("gameframeypos", this.y);
        Jetris.getConfig().writeKey("gameframewidth", this.width);
        Jetris.getConfig().writeKey("gameframeheight", this.height);
        Jetris.getConfig().writeKey("multicolormode", Jetris.getMenuBar().getMultiColorCheckBox().isSelected());
        Jetris.getConfig().writeKey("gamebackgroundcolor", Jetris.getGamePanel().getBackgroundColor().getRGB());
        Jetris.getConfig().writeKey("drawgamepanelgrid", Jetris.getGamePanel().isGrid());
    }
}

