/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

final class JetrisGamePanel
extends JPanel
implements KeyListener {
    final int HIDDENROWS = 4;
    final int ROWS = 24;
    final int COLS = 10;
    private Color backgroundColor;
    private boolean grid;
    JetrisGameCell[][] cell = new JetrisGameCell[24][10];

    JetrisGamePanel() {
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.backgroundColor = new Color(Jetris.getConfig().readKey("gamebackgroundcolor", 0));
        this.grid = Jetris.getConfig().readKey("drawgamepanelgrid", true);
        this.addKeyListener(this);
        int n = 0;
        while (n < 24) {
            int n2 = 0;
            while (n2 < 10) {
                this.cell[n][n2] = new JetrisGameCell();
                ++n2;
            }
            ++n;
        }
    }

    public int getRows() {
        return 24;
    }

    public int getCols() {
        return 10;
    }

    public JetrisGameCell getCell(int n, int n2) {
        return this.cell[n][n2];
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaint();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean isGrid() {
        return this.grid;
    }

    public void setGrid(boolean bl) {
        this.grid = bl;
    }

    public void reset() {
        int n = 0;
        while (n < 24) {
            int n2 = 0;
            while (n2 < 10) {
                this.cell[n][n2].setBlocked(false);
                ++n2;
            }
            ++n;
        }
    }

    public byte deleteCompletedRows(int n, int n2) {
        byte by = 0;
        int n3 = n;
        while (n3 >= n2) {
            boolean bl = true;
            int n4 = 0;
            while (n4 < 10) {
                if (!this.cell[n3][n4].isBlocked()) {
                    bl = false;
                    break;
                }
                ++n4;
            }
            if (bl) {
                this.deleteRow(n3);
                by = (byte)(by + 1);
                continue;
            }
            --n3;
        }
        return by;
    }

    private void deleteRow(int n) {
        int n2;
        int n3 = 0;
        while (n3 < 10) {
            n2 = 9;
            while (n2 > n3) {
                this.cell[n][n2].setColor(this.cell[n][n2 - 1].getColor());
                --n2;
            }
            this.cell[n][n3].setBlocked(false);
            this.repaint();
            try {
                Thread.sleep(7L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n3;
        }
        n2 = n;
        while (n2 > 4) {
            int n4 = 0;
            while (n4 < 10) {
                this.cell[n2][n4].setBlocked(this.cell[n2 - 1][n4].isBlocked());
                this.cell[n2][n4].setColor(this.cell[n2 - 1][n4].getColor());
                ++n4;
            }
            --n2;
        }
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getWidth() / 10;
        int n6 = this.getHeight() / 20;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setBackground(this.backgroundColor);
        graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.grid) {
            n4 = 4;
            while (n4 < 24) {
                n3 = 0;
                while (n3 < 10) {
                    n2 = n3 * n5;
                    n = (n4 - 4) * n6;
                    graphics2D.setColor(this.backgroundColor);
                    graphics2D.fill3DRect(n2, n, n5, n6, false);
                    ++n3;
                }
                ++n4;
            }
        }
        n4 = 4;
        while (n4 < 24) {
            n3 = 0;
            while (n3 < 10) {
                if (this.cell[n4][n3].isBlocked()) {
                    n2 = n3 * n5;
                    n = (n4 - 4) * n6;
                    graphics2D.setColor(this.cell[n4][n3].getColor());
                    graphics2D.fill3DRect(n2, n, n5, n6, true);
                }
                ++n3;
            }
            ++n4;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 37: {
                if (Jetris.getGame() == null || Jetris.getGame().getBlock().isLeft()) break;
                Jetris.getGame().getBlock().goLeft();
                Jetris.getGamePanel().repaint();
                break;
            }
            case 39: {
                if (Jetris.getGame() == null || Jetris.getGame().getBlock().isRight()) break;
                Jetris.getGame().getBlock().goRight();
                Jetris.getGamePanel().repaint();
                break;
            }
            case 38: {
                if (Jetris.getGame() == null) break;
                Jetris.getGame().getBlock().turnLeft();
                Jetris.getGamePanel().repaint();
                break;
            }
            case 32: 
            case 40: {
                if (Jetris.getGame() == null) break;
                Jetris.getGame().dropBlock();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

