/*
 * Decompiled with CFR 0.152.
 */
package puzzle.edge;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import puzzle.GameCommander;
import puzzle.Offset;
import puzzle.Turnable;
import puzzle.pieces.SinglePiece;
import puzzle.storeage.JigsawPuzzleException;
import puzzle.storeage.LoadGameException;
import puzzle.storeage.SaveGameException;
import puzzle.storeage.StorageUtil;
import puzzle.storeage.Storeable;

public class Edge
implements Storeable,
Turnable {
    private static final Logger logger = Logger.getLogger(Edge.class);
    private Type type;
    private int edgePairNumber;
    private Shape edgeShape;
    private Offset offset;
    private SinglePiece ownerPiece;
    private boolean isOwnerPieceSet = false;
    private boolean open;

    public Edge(Type type, int n, GeneralPath generalPath) {
        this.type = type;
        this.edgePairNumber = n;
        this.open = true;
        this.edgeShape = generalPath;
    }

    public Edge() {
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getEdgePairNumber() {
        return this.edgePairNumber;
    }

    public Offset getOffset() {
        int n = this.offset.getX();
        int n2 = this.offset.getY();
        return new Offset(n, n2);
    }

    public void setOffset(Offset offset) {
        this.offset = new Offset(offset.getX(), offset.getY());
    }

    public SinglePiece getOwnerPiece() {
        return this.ownerPiece;
    }

    public void setOwnerPiece(SinglePiece singlePiece) throws JigsawPuzzleException {
        if (this.isOwnerPieceSet) {
            logger.error("tried to reset the owner");
            throw new JigsawPuzzleException("tried to reset the owner!");
        }
        this.ownerPiece = singlePiece;
        this.isOwnerPieceSet = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isResolvable() {
        return this.isOpen() && this.getType() != Type.NULL;
    }

    public void close() throws JigsawPuzzleException {
        if (this.type == Type.NULL) {
            throw new JigsawPuzzleException("never close a NULL type edge.");
        }
        this.open = false;
    }

    public Point calculatePoint() {
        Point point = this.ownerPiece.getPoint();
        int n = point.x + this.offset.getX();
        int n2 = point.y + this.offset.getY();
        return new Point(n, n2);
    }

    public void move(Offset offset) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(offset.getX(), offset.getY());
        this.edgeShape = affineTransform.createTransformedShape(this.edgeShape);
    }

    public Shape getShape() {
        return this.edgeShape;
    }

    @Override
    public void turnDegrees(Point point, int n) {
        logger.debug("rotating Edge");
        int n2 = GameCommander.getInstance().getPreferences().getSideLength() / 2;
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(n), point.x, point.y);
        this.edgeShape = affineTransform.createTransformedShape(this.edgeShape);
        switch (this.type) {
            case BOTTOM: {
                this.setType(Type.LEFT);
                this.setOffset(new Offset(-n2, 0));
                break;
            }
            case LEFT: {
                this.setType(Type.TOP);
                this.setOffset(new Offset(0, -n2));
                break;
            }
            case RIGHT: {
                this.setType(Type.BOTTOM);
                this.setOffset(new Offset(0, n2));
                break;
            }
            case TOP: {
                this.setType(Type.RIGHT);
                this.setOffset(new Offset(n2, 0));
                break;
            }
        }
    }

    public static Type contraryEdgeChar(Type type) throws JigsawPuzzleException {
        switch (type) {
            case TOP: {
                return Type.BOTTOM;
            }
            case BOTTOM: {
                return Type.TOP;
            }
            case RIGHT: {
                return Type.LEFT;
            }
            case LEFT: {
                return Type.RIGHT;
            }
            case NULL: {
                return Type.NULL;
            }
        }
        throw new JigsawPuzzleException("Invalid Type");
    }

    @Override
    public void restore(Node node) throws LoadGameException {
        Node node2 = StorageUtil.findDirectChildNode(node, "Edge");
        NamedNodeMap namedNodeMap = node2.getAttributes();
        Node node3 = namedNodeMap.getNamedItem("Type");
        int n = Integer.parseInt(node3.getNodeValue());
        switch (n) {
            case 1: {
                this.type = Type.TOP;
                break;
            }
            case 2: {
                this.type = Type.BOTTOM;
                break;
            }
            case 3: {
                this.type = Type.RIGHT;
                break;
            }
            case 4: {
                this.type = Type.LEFT;
                break;
            }
            case 5: {
                this.type = Type.NULL;
                break;
            }
            default: {
                throw new LoadGameException("Invalid Type");
            }
        }
        node3 = namedNodeMap.getNamedItem("EdgePairNumber");
        this.edgePairNumber = Integer.parseInt(node3.getNodeValue());
        node3 = namedNodeMap.getNamedItem("Open");
        this.open = Boolean.parseBoolean(node3.getNodeValue());
        this.edgeShape = (Shape)StorageUtil.restoreSerialisableObject(node2, "EdgePath");
        Node node4 = StorageUtil.findDirectChildNode(node2, "EdgeOffset");
        this.offset = new Offset();
        this.offset.restore(node4);
    }

    @Override
    public void store(Node node) throws SaveGameException {
        int n;
        Document document = node.getOwnerDocument();
        Element element = document.createElement("Edge");
        switch (this.type) {
            case TOP: {
                n = 1;
                break;
            }
            case BOTTOM: {
                n = 2;
                break;
            }
            case RIGHT: {
                n = 3;
                break;
            }
            case LEFT: {
                n = 4;
                break;
            }
            case NULL: {
                n = 5;
                break;
            }
            default: {
                throw new SaveGameException("Invalid Type");
            }
        }
        element.setAttribute("Type", "" + n);
        element.setAttribute("EdgePairNumber", "" + this.edgePairNumber);
        StorageUtil.storeSerialisableObject(element, "EdgePath", this.edgeShape);
        Element element2 = document.createElement("EdgeOffset");
        this.offset.store(element2);
        element.setAttribute("Open", "" + this.open);
        element.appendChild(element2);
        node.appendChild(element);
    }

    public String toString() {
        String string = this.getClass().getName() + ", EdgePairNumber:" + this.getEdgePairNumber() + ", Type:" + (Object)((Object)this.getType()) + ", Offset:" + this.offset.toString() + ", open?" + this.open;
        return string;
    }

    public static enum Type {
        TOP,
        BOTTOM,
        RIGHT,
        LEFT,
        NULL;

    }
}

