/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class TextPrinter {
    static Frame frame = new Frame();
    PrintJob pjob;
    Graphics pg;
    Font font;
    FontMetrics fm;
    Color color;
    int lineSpacing;
    int tabstop;
    Dimension size;
    int res;
    int leftMargin;
    int rightMargin;
    int topMargin;
    int bottomMargin;
    boolean wrap = true;
    int x;
    int y;
    int page;

    public static void print(String string) {
        TextPrinter.print(string, "", null);
    }

    public static void print(String string, String string2) {
        TextPrinter.print(string, string2, null);
    }

    public static void print(String string, String string2, Font font) {
        try {
            TextPrinter textPrinter = new TextPrinter(string2, font);
            textPrinter.write(string);
            textPrinter.dispose();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    public TextPrinter() {
        this("", null);
    }

    public TextPrinter(String string) {
        this(string, null);
    }

    public TextPrinter(String string, Font font) {
        this.pjob = Toolkit.getDefaultToolkit().getPrintJob(frame, string, null);
        if (this.pjob == null) {
            throw new IllegalStateException("Could not get PrintJob");
        }
        this.pg = this.pjob.getGraphics();
        if (this.pjob == null) {
            throw new IllegalStateException("Could not get PrintGraphics");
        }
        this.size = this.pjob.getPageDimension();
        this.res = this.pjob.getPageResolution();
        this.setFont(font);
        this.setColor(Color.black);
        this.setTab(0.5f);
        this.setMargins(1.0f, 1.0f, 1.0f, 1.0f);
        this.x = this.leftMargin;
        this.y = this.topMargin + this.fm.getHeight();
        this.page = 1;
    }

    public void dispose() {
        this.pg.dispose();
        this.pjob.end();
    }

    private String stripLF(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\u0000", true);
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\n")) {
                if (!bl) {
                    stringBuffer.append("\n");
                }
                bl = false;
                continue;
            }
            if (string2.equals("\r")) {
                stringBuffer.append("\n");
                bl = true;
                continue;
            }
            if (string2.equals("\u0000")) {
                bl = false;
                continue;
            }
            stringBuffer.append(string2);
            bl = false;
        }
        return stringBuffer.toString();
    }

    public void write(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.stripLF(string), "\n\f\t ", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\n")) {
                this.newLine();
                continue;
            }
            if (string2.equals("\f")) {
                this.formFeed();
                continue;
            }
            if (string2.equals("\t")) {
                this.x = ((this.x - this.leftMargin) / this.tabstop + 1) * this.tabstop + this.leftMargin;
                continue;
            }
            if (string2.equals(" ")) {
                this.x += this.fm.stringWidth(" ");
                continue;
            }
            this.flowText(string2);
        }
    }

    private void flowText(String string) {
        int n = this.fm.stringWidth(string);
        if (this.wrap) {
            if (this.x + n > this.rightMargin && this.x > this.leftMargin) {
                this.newLine();
            }
            this.pg.drawString(string, this.x, this.y);
        } else if (this.x + n < this.rightMargin) {
            this.pg.drawString(string, this.x, this.y);
        }
        this.x += n;
    }

    public void newLine() {
        this.x = this.leftMargin;
        this.y += this.lineSpacing;
        if (this.y + this.fm.getMaxDescent() > this.bottomMargin) {
            this.formFeed();
        }
    }

    public void formFeed() {
        if (this.pg != null) {
            this.pg.dispose();
        }
        this.pg = this.pjob.getGraphics();
        this.setFont(this.font);
        this.setColor(this.color);
        this.x = this.leftMargin;
        this.y = this.topMargin + this.fm.getHeight();
        ++this.page;
    }

    public void setFont(Font font) {
        if (font == null) {
            font = new Font("Dialog", 0, 10);
        }
        this.font = font;
        this.pg.setFont(font);
        this.fm = this.pg.getFontMetrics(font);
        this.lineSpacing = this.fm.getHeight();
    }

    public Font getFont() {
        return this.font;
    }

    public void setColor(Color color) {
        this.pg.setColor(color);
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setTab(float f) {
        this.tabstop = f < 0.01f ? this.res : (int)((float)this.res * f);
    }

    public int getTab() {
        return this.tabstop;
    }

    public void setWordWrap(boolean bl) {
        this.wrap = bl;
    }

    public boolean getWordWrap() {
        return this.wrap;
    }

    public void setMargins(float f, float f2, float f3, float f4) {
        this.topMargin = (int)((float)this.res * f);
        this.bottomMargin = this.size.height - (int)((float)this.res * f2);
        this.leftMargin = (int)((float)this.res * f3);
        this.rightMargin = this.size.width - (int)((float)this.res * f4);
    }

    public int[] getMargins() {
        return new int[]{this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin};
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Usage: java datarep.common.TextPrinter file1 file2 ...");
            System.exit(1);
        }
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            block10: {
                File file = new File(stringArray[n]);
                if (file == null) {
                    System.err.println("Null File reference");
                } else {
                    try {
                        if (!file.isFile() || !file.canRead()) {
                            System.err.println("Cannot open " + file.getName() + "for reading.");
                            break block10;
                        }
                        FileReader fileReader = new FileReader(file);
                        int n2 = (int)file.length();
                        char[] cArray = new char[n2];
                        int n3 = fileReader.read(cArray);
                        if (n3 != n2) {
                            System.err.println("Could only read " + n3 + " from " + n2 + " bytes from " + file.getName());
                            fileReader.close();
                            break block10;
                        }
                        fileReader.close();
                        string = new String(cArray);
                    }
                    catch (SecurityException securityException) {
                        System.err.println("SecurityException for " + file.getName());
                        break block10;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println("FileNotFoundException for " + file.getName());
                        break block10;
                    }
                    catch (IOException iOException) {
                        System.err.println("IOException reading from " + file.getName());
                        break block10;
                    }
                    TextPrinter.print(string);
                }
            }
            ++n;
        }
        System.exit(0);
    }
}

