/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MainMinesweeper {
    public static JHighscore highscoreEinfach;
    public static JHighscore highscoreFortgeschritten;
    public static JHighscore highscoreProfi;
    public static StatistikGUI statistikEinfach;
    public static StatistikGUI statistikFortgeschritten;
    public static StatistikGUI statistikProfi;
    public static MinesweeperGUI game1;
    public static AuswahlBildschirm start1;
    public static OutputTextFile printer1;
    public static OutputTextFile printer2;
    public static OutputTextFile printer3;
    public static OutputTextFile printer4;
    public static OutputTextFile printer5;
    public static OutputTextFile printer6;
    public static InputTextFile reader1;
    public static InputTextFile reader2;
    public static InputTextFile reader3;
    public static InputTextFile reader4;
    public static InputTextFile reader5;
    public static InputTextFile reader6;
    public static String FILENAME_EINFACH;
    public static String FILENAME_FORTGESCHRITTEN;
    public static String FILENAME_PROFI;
    public static String FILENAME_STATISTIK_EINFACH;
    public static String FILENAME_STATISTIK_FORTGESCHRITTEN;
    public static String FILENAME_STATISTIK_PROFI;
    public static String strDirectoy;
    public static boolean kleineBilder;
    public static URL urlMine;
    public static ImageIcon iconMine;
    public static URL urlUhr;
    public static ImageIcon iconUhr;
    public static URL urlWinner;
    public static ImageIcon iconWinner;
    public static URL urlStatistik;
    public static ImageIcon iconStatistik;
    public static URL urlFlagge;
    public static ImageIcon iconFlagge;
    public static URL urlMineGetroffen;
    public static ImageIcon iconMineGetroffen;
    public static URL urlKeineMine;
    public static ImageIcon iconKeineMine;
    public static int boundX;
    public static int boundY;

    static {
        FILENAME_EINFACH = String.valueOf(System.getProperty("user.home")) + "/minesweeper/HighscoreEasy.txt";
        FILENAME_FORTGESCHRITTEN = String.valueOf(System.getProperty("user.home")) + "/minesweeper/HighscoreIntermediate.txt";
        FILENAME_PROFI = String.valueOf(System.getProperty("user.home")) + "/minesweeper/HighscoreExpert.txt";
        FILENAME_STATISTIK_EINFACH = String.valueOf(System.getProperty("user.home")) + "/minesweeper/StatistikEasy.txt";
        FILENAME_STATISTIK_FORTGESCHRITTEN = String.valueOf(System.getProperty("user.home")) + "/minesweeper/StatistikIntermediate.txt";
        FILENAME_STATISTIK_PROFI = String.valueOf(System.getProperty("user.home")) + "/minesweeper/StatistikExpert.txt";
        strDirectoy = String.valueOf(System.getProperty("user.home")) + "/minesweeper";
        kleineBilder = false;
        urlMine = MinesweeperGUI.class.getResource("resources/images/mine.png");
        iconMine = new ImageIcon(urlMine);
        urlUhr = MinesweeperGUI.class.getResource("resources/images/uhr.png");
        iconUhr = new ImageIcon(urlUhr);
        urlWinner = MinesweeperGUI.class.getResource("resources/images/siegertreppe1.gif");
        iconWinner = new ImageIcon(urlWinner);
        urlStatistik = MinesweeperGUI.class.getResource("resources/images/statistik.png");
        iconStatistik = new ImageIcon(urlStatistik);
        urlFlagge = MinesweeperGUI.class.getResource("resources/images/flagge.png");
        iconFlagge = new ImageIcon(urlFlagge);
        urlMineGetroffen = MinesweeperGUI.class.getResource("resources/images/mineGetroffen.png");
        iconMineGetroffen = new ImageIcon(urlMineGetroffen);
        urlKeineMine = MinesweeperGUI.class.getResource("resources/images/keineMine.png");
        iconKeineMine = new ImageIcon(urlKeineMine);
        boundX = 335;
        boundY = 457;
    }

    public static void main(String[] args) {
        try {
            MainMinesweeper.newLookAndFeel();
        }
        catch (Exception e) {
            System.out.println("Windows Look & Feel wurde nicht geladen");
            kleineBilder = true;
        }
        highscoreEinfach = new JHighscore(FILENAME_EINFACH, "easy");
        highscoreFortgeschritten = new JHighscore(FILENAME_FORTGESCHRITTEN, "intermediate");
        highscoreProfi = new JHighscore(FILENAME_PROFI, "expert");
        statistikEinfach = new StatistikGUI(FILENAME_STATISTIK_EINFACH);
        statistikFortgeschritten = new StatistikGUI(FILENAME_STATISTIK_FORTGESCHRITTEN);
        statistikProfi = new StatistikGUI(FILENAME_STATISTIK_PROFI);
        MainMinesweeper.dateienEinlesen();
        MainMinesweeper.statistikAktualisieren();
        start1 = new AuswahlBildschirm(statistikEinfach);
        game1 = new MinesweeperGUI(10, 10, 10);
        MainMinesweeper.starteSpiel();
    }

    public static void starteSpiel() {
        game1.setBounds(200, 50, boundX, boundY);
        JButtonZustand.aufgedeckteFelderReset();
        game1.minenLegen();
        game1.setVisible(true);
    }

    public static void starteSpielNeu(StatistikGUI aktuelleStatistik) {
        game1.dispose();
        start1 = new AuswahlBildschirm(aktuelleStatistik);
        game1 = new MinesweeperGUI(AuswahlBildschirm.getSpalten(), AuswahlBildschirm.getZeilen(), AuswahlBildschirm.getMinen());
        MainMinesweeper.starteSpiel();
    }

    public static void statistikAktualisieren() {
        statistikEinfach.einlesen();
        statistikEinfach.abspeichern();
        statistikFortgeschritten.einlesen();
        statistikFortgeschritten.abspeichern();
        statistikProfi.einlesen();
        statistikProfi.einlesen();
    }

    public static void setNewBounds(int boundNewX, int boundNewY) {
        boundX = boundNewX;
        boundY = boundNewY;
    }

    private static void dateienEinlesen() {
        try {
            int x = 0;
            reader1 = new InputTextFile(FILENAME_EINFACH);
            while (!reader1.endOfFile()) {
                MainMinesweeper.highscoreEinfach.eintraegeArray[x][0] = reader1.readLine();
                MainMinesweeper.highscoreEinfach.eintraegeArray[x][1] = reader1.readLine();
                if (!MainMinesweeper.highscoreEinfach.eintraegeArray[x][0].equals("empty")) {
                    highscoreEinfach.anzahlEintraegeErhoehen();
                }
                ++x;
            }
            x = 0;
            reader1.close();
            reader2 = new InputTextFile(FILENAME_FORTGESCHRITTEN);
            while (!reader2.endOfFile()) {
                MainMinesweeper.highscoreFortgeschritten.eintraegeArray[x][0] = reader2.readLine();
                MainMinesweeper.highscoreFortgeschritten.eintraegeArray[x][1] = reader2.readLine();
                if (!MainMinesweeper.highscoreFortgeschritten.eintraegeArray[x][0].equals("empty")) {
                    highscoreFortgeschritten.anzahlEintraegeErhoehen();
                }
                ++x;
            }
            x = 0;
            reader2.close();
            reader3 = new InputTextFile(FILENAME_PROFI);
            while (!reader3.endOfFile()) {
                MainMinesweeper.highscoreProfi.eintraegeArray[x][0] = reader3.readLine();
                MainMinesweeper.highscoreProfi.eintraegeArray[x][1] = reader3.readLine();
                if (!MainMinesweeper.highscoreProfi.eintraegeArray[x][0].equals("empty")) {
                    highscoreProfi.anzahlEintraegeErhoehen();
                }
                ++x;
            }
            x = 0;
            reader3.close();
            reader4 = new InputTextFile(FILENAME_STATISTIK_EINFACH);
            while (x < MainMinesweeper.statistikEinfach.daten.length) {
                MainMinesweeper.statistikEinfach.daten[x] = reader4.readLine();
                ++x;
            }
            x = 0;
            reader4.close();
            reader5 = new InputTextFile(FILENAME_STATISTIK_FORTGESCHRITTEN);
            while (x < MainMinesweeper.statistikFortgeschritten.daten.length) {
                MainMinesweeper.statistikFortgeschritten.daten[x] = reader5.readLine();
                ++x;
            }
            x = 0;
            reader5.close();
            reader6 = new InputTextFile(FILENAME_STATISTIK_PROFI);
            while (x < MainMinesweeper.statistikProfi.daten.length) {
                MainMinesweeper.statistikProfi.daten[x] = reader6.readLine();
                ++x;
            }
            x = 0;
            reader6.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            try {
                boolean success = new File(strDirectoy).mkdir();
                if (success) {
                    System.out.println("Directory: " + strDirectoy + " created");
                }
            }
            catch (Exception e1) {
                System.err.println("Error: " + e1.getMessage());
            }
            JHighscore.highscoreAbspeichernNeu();
            StatistikGUI.abspeichernNeu();
            statistikEinfach = new StatistikGUI(FILENAME_STATISTIK_EINFACH);
            statistikEinfach.abspeichern();
            statistikFortgeschritten = new StatistikGUI(FILENAME_STATISTIK_FORTGESCHRITTEN);
            statistikFortgeschritten.abspeichern();
            statistikProfi = new StatistikGUI(FILENAME_STATISTIK_PROFI);
            statistikProfi.abspeichern();
        }
    }

    private static void newLookAndFeel() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        String javaLF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        UIManager.setLookAndFeel(javaLF);
    }
}

