/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StatistikGUI
extends JPanel {
    public String FILENAME;
    private JLabel bildMine;
    private static final long serialVersionUID = 1L;
    private int gespielteSpiele;
    private int gewonneneSpiele;
    private int gewinnserieAktuell;
    private int verlierserieAktuell;
    private int gewinnserie;
    private int verlierserie;
    public String[] daten = new String[6];
    private JTextField textfeldGespielteSpiele = new JTextField(4);
    private JTextField textfeldGewonneneSpiele = new JTextField(4);
    private JTextField textfeldGewinnserie = new JTextField(4);
    private JTextField textfeldVerlierserie = new JTextField(4);
    private JTextField textfeldProzent = new JTextField(4);
    private JLabel labelVerlierserie = new JLabel("Longest losing streak: ");
    private JLabel labelGewinnserie = new JLabel("Longest winning streak: ");
    private JLabel labelGewonneneSpiele = new JLabel("Won games: ");
    private JLabel labelGespielteSpiele = new JLabel("Played games: ");
    private JLabel labelProzent = new JLabel("% won: ");
    private JPanel panelProzent = new JPanel();
    private JPanel panelGewinn = new JPanel();
    private JPanel panelGespielt = new JPanel();
    private JPanel panelGewinnserie = new JPanel();
    private JPanel panelVerlierserie = new JPanel();

    public StatistikGUI(String filename) {
        this.FILENAME = filename;
        int i = 0;
        while (i < this.daten.length) {
            if (this.daten[i] == null) {
                this.daten[i] = "0";
            }
            ++i;
        }
        this.setLayout(new BoxLayout(this, 1));
        if (MainMinesweeper.kleineBilder) {
            MainMinesweeper.iconStatistik.setImage(MainMinesweeper.iconStatistik.getImage().getScaledInstance(120, 120, 4));
        } else {
            MainMinesweeper.iconStatistik.setImage(MainMinesweeper.iconStatistik.getImage().getScaledInstance(150, 150, 4));
        }
        this.bildMine = new JLabel(MainMinesweeper.iconStatistik);
        this.add(this.bildMine);
        this.panelProzent.setLayout(new BorderLayout());
        this.panelProzent.add((Component)this.labelProzent, "West");
        this.textfeldProzent.setEditable(false);
        this.panelProzent.add((Component)this.textfeldProzent, "East");
        this.add(this.panelProzent);
        this.panelGespielt.setLayout(new BorderLayout());
        this.panelGespielt.add((Component)this.labelGespielteSpiele, "West");
        this.textfeldGespielteSpiele.setEditable(false);
        this.panelGespielt.add((Component)this.textfeldGespielteSpiele, "East");
        this.add(this.panelGespielt);
        this.panelGewinn.setLayout(new BorderLayout());
        this.panelGewinn.add((Component)this.labelGewonneneSpiele, "West");
        this.textfeldGewonneneSpiele.setEditable(false);
        this.panelGewinn.add((Component)this.textfeldGewonneneSpiele, "East");
        this.add(this.panelGewinn);
        this.panelGewinnserie.setLayout(new BorderLayout());
        this.panelGewinnserie.add((Component)this.labelGewinnserie, "West");
        this.textfeldGewinnserie.setEditable(false);
        this.panelGewinnserie.add((Component)this.textfeldGewinnserie, "East");
        this.add(this.panelGewinnserie);
        this.panelVerlierserie.setLayout(new BorderLayout());
        this.panelVerlierserie.add((Component)this.labelVerlierserie, "West");
        this.panelVerlierserie.add((Component)this.textfeldVerlierserie, "East");
        this.textfeldVerlierserie.setEditable(false);
        this.add(this.panelVerlierserie);
    }

    public void gewonnen() {
        ++this.gespielteSpiele;
        ++this.gewinnserieAktuell;
        ++this.gewonneneSpiele;
        this.verlierserieAktuell = 0;
        this.serieAktuellPruefen();
        this.abspeichern();
        MainMinesweeper.statistikAktualisieren();
    }

    public void verloren() {
        ++this.gespielteSpiele;
        ++this.verlierserieAktuell;
        this.gewinnserieAktuell = 0;
        this.serieAktuellPruefen();
        this.abspeichern();
        MainMinesweeper.statistikAktualisieren();
    }

    private double gewonnenProzent() {
        if (this.gespielteSpiele == 0) {
            return 0.0;
        }
        return (double)this.gewonneneSpiele / (double)this.gespielteSpiele * 100.0;
    }

    private void serieAktuellPruefen() {
        if (this.gewinnserieAktuell > this.gewinnserie) {
            this.gewinnserie = this.gewinnserieAktuell;
        }
        if (this.verlierserieAktuell > this.verlierserie) {
            this.verlierserie = this.verlierserieAktuell;
        }
    }

    public void einlesen() {
        this.gespielteSpiele = Integer.parseInt(this.daten[0]);
        this.gewonneneSpiele = Integer.parseInt(this.daten[1]);
        this.gewinnserie = Integer.parseInt(this.daten[2]);
        this.gewinnserieAktuell = Integer.parseInt(this.daten[3]);
        this.verlierserie = Integer.parseInt(this.daten[4]);
        this.verlierserieAktuell = Integer.parseInt(this.daten[5]);
    }

    public void abspeichern() {
        this.daten[0] = Integer.toString(this.gespielteSpiele);
        this.daten[1] = Integer.toString(this.gewonneneSpiele);
        this.daten[2] = Integer.toString(this.gewinnserie);
        this.daten[3] = Integer.toString(this.gewinnserieAktuell);
        this.daten[4] = Integer.toString(this.verlierserie);
        this.daten[5] = Integer.toString(this.verlierserieAktuell);
        this.textfeldGespielteSpiele.setText(Integer.toString(this.gespielteSpiele));
        this.textfeldProzent.setText(String.valueOf((int)this.gewonnenProzent()) + "%");
        this.textfeldGewonneneSpiele.setText(Integer.toString(this.gewonneneSpiele));
        this.textfeldGewinnserie.setText(Integer.toString(this.gewinnserie));
        this.textfeldVerlierserie.setText(Integer.toString(this.verlierserie));
        if (this.FILENAME.equals(MainMinesweeper.FILENAME_STATISTIK_EINFACH)) {
            MainMinesweeper.printer4 = new OutputTextFile(this.FILENAME);
            int i = 0;
            while (i < this.daten.length) {
                MainMinesweeper.printer4.println(this.daten[i]);
                ++i;
            }
            MainMinesweeper.printer4.close();
        } else if (this.FILENAME.equals(MainMinesweeper.FILENAME_STATISTIK_FORTGESCHRITTEN)) {
            MainMinesweeper.printer5 = new OutputTextFile(this.FILENAME);
            int i = 0;
            while (i < this.daten.length) {
                MainMinesweeper.printer5.println(this.daten[i]);
                ++i;
            }
            MainMinesweeper.printer5.close();
        } else if (this.FILENAME.equals(MainMinesweeper.FILENAME_STATISTIK_PROFI)) {
            MainMinesweeper.printer6 = new OutputTextFile(this.FILENAME);
            int i = 0;
            while (i < this.daten.length) {
                MainMinesweeper.printer6.println(this.daten[i]);
                ++i;
            }
            MainMinesweeper.printer6.close();
        }
    }

    public void statistikReset() {
        int i = 0;
        while (i < this.daten.length) {
            this.daten[i] = "0";
            ++i;
        }
    }

    public static void abspeichernNeu() {
        MainMinesweeper.printer4 = new OutputTextFile(MainMinesweeper.FILENAME_STATISTIK_EINFACH);
        MainMinesweeper.printer4.close();
        MainMinesweeper.printer5 = new OutputTextFile(MainMinesweeper.FILENAME_STATISTIK_FORTGESCHRITTEN);
        MainMinesweeper.printer5.close();
        MainMinesweeper.printer6 = new OutputTextFile(MainMinesweeper.FILENAME_STATISTIK_PROFI);
        MainMinesweeper.printer6.close();
        MainMinesweeper.statistikEinfach = new StatistikGUI(MainMinesweeper.FILENAME_STATISTIK_EINFACH);
        MainMinesweeper.statistikFortgeschritten = new StatistikGUI(MainMinesweeper.FILENAME_STATISTIK_FORTGESCHRITTEN);
        MainMinesweeper.statistikProfi = new StatistikGUI(MainMinesweeper.FILENAME_STATISTIK_PROFI);
        MainMinesweeper.start1 = new AuswahlBildschirm(MinesweeperGUI.aktuelleStatistik);
    }
}

