/*
 * Decompiled with CFR 0.152.
 */
package org.demarchi.jpeces.formularis;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.demarchi.jpeces.comuns.Configuracio;
import org.demarchi.jpeces.comuns.Constants;
import org.demarchi.jpeces.comuns.FiltreArxiusConcurs;
import org.demarchi.jpeces.formularis.frmNombreFiguresConcurs;
import org.demarchi.jpeces.principal.ArbreFigures;
import org.demarchi.jpeces.principal.DadesFigura;
import org.demarchi.jpeces.principal.panellDeMostra;

public class frmConcurs
extends JDialog
implements Constants {
    public ArbreFigures arbreFigures = new ArbreFigures();
    public ArbreFigures arbreConcurs = new ArbreFigures();
    private Configuracio configuracio;
    private panellDeMostra panellMostra;
    private static ResourceBundle i18n = null;
    private JButton butAfageix;
    private JButton butConcursAtzar;
    private JButton butDesaConcurs;
    private JButton butElimina;
    private JButton butTanca;
    private JButton mnuCarregaConcurs;
    private JPanel panellBotons;
    private JPanel panellConcurs;
    private JPanel panellFigures;

    public frmConcurs(Frame parent, boolean modal, Configuracio config) {
        super(parent, modal);
        if (i18n == null) {
            i18n = ResourceBundle.getBundle("org.demarchi.jpeces.locales.figures");
        }
        this.configuracio = config;
        this.initComponents();
        this.pack();
        this.setTitle(i18n.getString("Crea.concurs"));
        this.butAfageix.setToolTipText(i18n.getString("Concurs.ToolTip.Afageix"));
        this.butElimina.setToolTipText(i18n.getString("Concurs.ToolTip.Elimina"));
        this.butConcursAtzar.setToolTipText(i18n.getString("Concurs.ToolTip.Atzar"));
        this.butDesaConcurs.setToolTipText(i18n.getString("Concurs.ToolTip.Desa"));
        this.butTanca.setText(i18n.getString("Tanca"));
        this.butTanca.setToolTipText(i18n.getString("Tanca"));
        this.mnuCarregaConcurs.setToolTipText(i18n.getString("Concurs.ToolTip.Carrega"));
        this.construeix();
    }

    private void initComponents() {
        this.panellBotons = new JPanel();
        this.butAfageix = new JButton();
        this.butDesaConcurs = new JButton();
        this.butElimina = new JButton();
        this.butTanca = new JButton();
        this.mnuCarregaConcurs = new JButton();
        this.butConcursAtzar = new JButton();
        this.panellFigures = new JPanel();
        this.panellConcurs = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.panellBotons.setBorder(BorderFactory.createEtchedBorder());
        this.butAfageix.setText(">>");
        this.butAfageix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frmConcurs.this.butAfageixActionPerformed(evt);
            }
        });
        this.butDesaConcurs.setIcon(new ImageIcon(this.getClass().getResource("/org/demarchi/jpeces/imatges/save.jpeg")));
        this.butDesaConcurs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frmConcurs.this.butDesaConcursActionPerformed(evt);
            }
        });
        this.butElimina.setIcon(new ImageIcon(this.getClass().getResource("/org/demarchi/jpeces/imatges/cross.png")));
        this.butElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frmConcurs.this.butEliminaActionPerformed(evt);
            }
        });
        this.butTanca.setText(i18n.getString("Tanca"));
        this.butTanca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frmConcurs.this.butTancaActionPerformed(evt);
            }
        });
        this.mnuCarregaConcurs.setIcon(new ImageIcon(this.getClass().getResource("/org/demarchi/jpeces/imatges/obre_concurs.png")));
        this.mnuCarregaConcurs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frmConcurs.this.mnuCarregaConcursActionPerformed(evt);
            }
        });
        this.butConcursAtzar.setIcon(new ImageIcon(this.getClass().getResource("/org/demarchi/jpeces/imatges/concursaatzar.png")));
        this.butConcursAtzar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frmConcurs.this.butConcursAtzarActionPerformed(evt);
            }
        });
        GroupLayout panellBotonsLayout = new GroupLayout(this.panellBotons);
        this.panellBotons.setLayout(panellBotonsLayout);
        panellBotonsLayout.setHorizontalGroup(panellBotonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panellBotonsLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(panellBotonsLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.butTanca).addComponent(this.butDesaConcurs).addComponent(this.mnuCarregaConcurs).addComponent(this.butAfageix).addComponent(this.butElimina).addComponent(this.butConcursAtzar)).addContainerGap(20, Short.MAX_VALUE)));
        panellBotonsLayout.setVerticalGroup(panellBotonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panellBotonsLayout.createSequentialGroup().addContainerGap(123, Short.MAX_VALUE).addComponent(this.butAfageix).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.butElimina).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.butConcursAtzar).addGap(25, 25, 25).addComponent(this.mnuCarregaConcurs).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.butDesaConcurs).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.butTanca).addContainerGap()));
        this.panellFigures.setPreferredSize(new Dimension(290, 350));
        GroupLayout panellFiguresLayout = new GroupLayout(this.panellFigures);
        this.panellFigures.setLayout(panellFiguresLayout);
        panellFiguresLayout.setHorizontalGroup(panellFiguresLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 290, Short.MAX_VALUE));
        panellFiguresLayout.setVerticalGroup(panellFiguresLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 350, Short.MAX_VALUE));
        this.panellConcurs.setPreferredSize(new Dimension(290, 350));
        GroupLayout panellConcursLayout = new GroupLayout(this.panellConcurs);
        this.panellConcurs.setLayout(panellConcursLayout);
        panellConcursLayout.setHorizontalGroup(panellConcursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 290, Short.MAX_VALUE));
        panellConcursLayout.setVerticalGroup(panellConcursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 350, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.panellFigures, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panellBotons, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panellConcurs, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panellFigures, -2, -1, -2).addComponent(this.panellConcurs, -2, -1, -2).addComponent(this.panellBotons, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void butAfageixActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode nus = this.arbreFigures.tornaNus();
        if (nus != null) {
            this.arbreConcurs.afegeixNus(nus, this.configuracio);
        }
    }

    private void butTancaActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void butEliminaActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode nus = this.arbreConcurs.tornaNus();
        if (nus != null && !nus.isRoot()) {
            this.arbreConcurs.eliminaNus(nus, this.configuracio);
        }
    }

    private void butDesaConcursActionPerformed(ActionEvent evt) {
        if (this.arbreConcurs.numeroDeFigures() > 0) {
            this.desaConcurs();
        }
    }

    private void mnuCarregaConcursActionPerformed(ActionEvent evt) {
        JFileChooser selectorArxius = new JFileChooser();
        FiltreArxiusConcurs filtre = new FiltreArxiusConcurs();
        filtre.nomArxiuConcurs = i18n.getString(this.configuracio.configuracioJoc.nomJocArbreFigures) + " " + i18n.getString(this.configuracio.configuracioJoc.nomNivellArbreFigures) + ".con";
        selectorArxius.addChoosableFileFilter(filtre);
        if (this.configuracio.directoriArxiusFiguresPersonals != null) {
            File arxiu = this.configuracio.directoriArxiusFiguresPersonals == null ? null : new File(this.configuracio.directoriArxiusFiguresPersonals);
            selectorArxius.setCurrentDirectory(arxiu);
        } else {
            selectorArxius.setCurrentDirectory(null);
        }
        selectorArxius.setDialogTitle(i18n.getString("carrega.arxiu.concurs"));
        selectorArxius.setAcceptAllFileFilterUsed(false);
        int resposta = selectorArxius.showDialog(this, i18n.getString("OK"));
        if (resposta == 0) {
            File arxiuSeleccionat = selectorArxius.getSelectedFile();
            this.configuracio.configuracioJoc.origenDades = 1;
            this.arbreConcurs.llegeixArxiu(3, arxiuSeleccionat.getAbsolutePath(), this.configuracio);
        }
    }

    private void butConcursAtzarActionPerformed(ActionEvent evt) {
        this.creaConcursAtzar();
    }

    private void construeix() {
        this.panellFigures.add(this.arbreFigures);
        this.arbreFigures.llegeixArxiu(this.configuracio.configuracioJoc.origenDades, this.configuracio.configuracioJoc.arxiuDadesFigures, this.configuracio);
        this.arbreFigures.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("canvi_figura".equals(evt.getPropertyName())) {
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        if (frmConcurs.this.arbreFigures.obj_dadesFigura.dadesPeces != null) {
                            ((frmConcurs)frmConcurs.this).panellMostra.jocMostra.colocaPeces(frmConcurs.this.arbreFigures.obj_dadesFigura.dadesPeces, frmConcurs.this.panellMostra);
                        }
                    } else {
                        ((frmConcurs)frmConcurs.this).panellMostra.jocMostra.estableixVisible(false);
                    }
                }
            }
        });
        this.panellConcurs.add(this.arbreConcurs);
        this.arbreConcurs.llegeixArxiu(this.configuracio.configuracioJoc.origenDades, null, this.configuracio);
        this.arbreConcurs.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("canvi_figura".equals(evt.getPropertyName())) {
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        if (frmConcurs.this.arbreConcurs.obj_dadesFigura.dadesPeces != null) {
                            ((frmConcurs)frmConcurs.this).panellMostra.jocMostra.colocaPeces(frmConcurs.this.arbreConcurs.obj_dadesFigura.dadesPeces, frmConcurs.this.panellMostra);
                        }
                    } else {
                        ((frmConcurs)frmConcurs.this).panellMostra.jocMostra.estableixVisible(false);
                    }
                }
            }
        });
        this.panellMostra = new panellDeMostra(10.0, this.configuracio);
        this.panellMostra.construeix(this);
        this.panellMostra.setLocation(0, 0);
        this.panellBotons.add(this.panellMostra);
        this.panellMostra.setLocation(5, 5);
    }

    private void desaConcurs() {
        try {
            FileWriter arxiu = new FileWriter(System.getProperty("user.home") + "/" + i18n.getString(this.configuracio.configuracioJoc.nomJocArbreFigures) + " " + i18n.getString(this.configuracio.configuracioJoc.nomNivellArbreFigures) + ".con", false);
            DefaultTreeModel treeModel = new DefaultTreeModel(this.arbreConcurs.nodeArrel);
            for (int i = 0; i <= treeModel.getChildCount(this.arbreConcurs.nodeArrel) - 1; ++i) {
                DefaultMutableTreeNode nus = (DefaultMutableTreeNode)treeModel.getChild(this.arbreConcurs.nodeArrel, i);
                DadesFigura objDadesFig = (DadesFigura)nus.getUserObject();
                arxiu.write(objDadesFig.nomFigura + "\n");
                arxiu.write(objDadesFig.dadesPeces + "\n");
                arxiu.write("" + this.configuracio.configuracioJoc.nivellJoc + " " + objDadesFig.dificultat + "\n");
            }
            arxiu.close();
            Object[] options = new Object[]{i18n.getString("OK")};
            int n = JOptionPane.showOptionDialog(this, i18n.getString("concurs.desat") + "\n" + System.getProperty("user.home") + "/" + i18n.getString(this.configuracio.configuracioJoc.nomJocArbreFigures) + " " + i18n.getString(this.configuracio.configuracioJoc.nomNivellArbreFigures) + ".con", i18n.getString("concurs.desat.titol"), -1, 1, null, options, options[0]);
        }
        catch (IOException ex) {
            Object[] options = new Object[]{i18n.getString("OK")};
            int n = JOptionPane.showOptionDialog(this, i18n.getString("concurs.error") + "\n" + System.getProperty("user.home") + "/" + i18n.getString(this.configuracio.configuracioJoc.nomJocArbreFigures) + " " + i18n.getString(this.configuracio.configuracioJoc.nomNivellArbreFigures) + ".con" + "\n" + i18n.getString("concurs.msg.error") + "\n" + ex.getMessage(), i18n.getString("concurs.desat.titol"), -1, 0, null, options, options[0]);
        }
    }

    private void creaConcursAtzar() {
        frmNombreFiguresConcurs frmNombreFigures = new frmNombreFiguresConcurs(this, true, 0, this.arbreFigures.numeroDeFigures() / 2);
        frmNombreFigures.setLocationRelativeTo(this);
        frmNombreFigures.setVisible(true);
        if (frmNombreFigures.getReturnStatus() == 1) {
            int nombreFigures = frmNombreFigures.nombreFigures;
            nombreFigures = Math.min(nombreFigures, this.arbreFigures.numeroDeFigures());
            while (this.arbreConcurs.numeroDeFigures() < nombreFigures) {
                this.arbreFigures.seleccionaFiguraAtzar();
                DefaultMutableTreeNode nus = this.arbreFigures.tornaNus();
                this.arbreConcurs.afegeixNus(nus, this.configuracio);
            }
        }
    }
}

