/*
 * Decompiled with CFR 0.152.
 */
package org.demarchi.jpeces.principal;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import org.demarchi.jpeces.comuns.Configuracio;
import org.demarchi.jpeces.comuns.Constants;
import org.demarchi.jpeces.peces.ConjuntDePeces;

public final class panellDeJoc
extends JPanel
implements Observer,
Constants {
    Graphics2D buffer;
    Image image;
    static final BasicStroke limits = new BasicStroke(0.1f);
    public static final int MODE_SENSE_DETERMINAR = 1;
    public static final int MODE_MOVIMENT_PECA = 2;
    public static final int MODE_ROTACIO_PECA = 3;
    private Configuracio configPanellDeJoc;
    public static final String SOLUCIO_TROBADA = "solucio_correcta";
    public static final String JOC_INICIAT = "joc_iniciat";
    public static final String DESCOMPTE_PUNTS_PECA = "descompte.punts";
    public ConjuntDePeces jocPeces;
    public ConjuntDePeces jocFigura;
    int modePecaMovimentRotacio = 1;
    int posicioInicialRatoli_X;
    int posicioInicialRatoli_Y;
    int indexPecaSeleccionada;
    double rotacioAngleInicial;
    double rotacioQuadrant;
    public boolean boolJocEnMarxa;
    public double escala = 55.0;

    public panellDeJoc(double pescala, Configuracio config) {
        this.configPanellDeJoc = config;
        this.escala = pescala;
        this.setSize(new Dimension(680, 640));
        this.setPreferredSize(new Dimension(680, 640));
        this.setMinimumSize(this.getPreferredSize());
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.creaConjuntsPeces();
        this.setVisible(true);
        this.firePropertyChange(SOLUCIO_TROBADA, false, false);
        this.firePropertyChange(JOC_INICIAT, false, false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int coordRatoli_x = e.getX();
                int coordRatoli_y = e.getY();
                panellDeJoc.this.indexPecaSeleccionada = panellDeJoc.this.jocPeces.seleccionaPeca(coordRatoli_x, coordRatoli_y);
                if (panellDeJoc.this.indexPecaSeleccionada >= 0) {
                    panellDeJoc.this.firePropertyChange(panellDeJoc.JOC_INICIAT, false, true);
                }
                if (((panellDeJoc)panellDeJoc.this).configPanellDeJoc.configuracioJoc.colocaPeca & ((panellDeJoc)panellDeJoc.this).configPanellDeJoc.configuracioJoc.jocIniciat) {
                    panellDeJoc.this.colocaPeca(panellDeJoc.this.indexPecaSeleccionada);
                    panellDeJoc.this.indexPecaSeleccionada = 0;
                    panellDeJoc.this.modePecaMovimentRotacio = 1;
                    panellDeJoc.this.firePropertyChange(panellDeJoc.DESCOMPTE_PUNTS_PECA, false, true);
                }
                if (panellDeJoc.this.indexPecaSeleccionada >= 0 & (e.getModifiersEx() & 0x400) != 0) {
                    panellDeJoc.this.modePecaMovimentRotacio = 2;
                    panellDeJoc.this.posicioInicialRatoli_X = coordRatoli_x;
                    panellDeJoc.this.posicioInicialRatoli_Y = coordRatoli_y;
                }
                if (panellDeJoc.this.indexPecaSeleccionada >= 0 & (e.getModifiersEx() & 0x1000) != 0) {
                    if ((e.getModifiersEx() & 0x80) != 0) {
                        panellDeJoc.this.jocPeces.arrayPeces[panellDeJoc.this.indexPecaSeleccionada].simetriaPeca();
                    } else {
                        panellDeJoc.this.modePecaMovimentRotacio = 3;
                        panellDeJoc.this.jocPeces.iniciRotacioPeca(coordRatoli_x, coordRatoli_y, panellDeJoc.this.indexPecaSeleccionada);
                        if (((panellDeJoc)panellDeJoc.this).configPanellDeJoc.configuracioJoc.nivellJoc < 3) {
                            Rectangle tamany = panellDeJoc.this.getBounds();
                            panellDeJoc.this.jocPeces.rotaPeca(panellDeJoc.this.indexPecaSeleccionada, e.getX(), e.getY(), tamany);
                            panellDeJoc.this.indexPecaSeleccionada = -1;
                            panellDeJoc.this.modePecaMovimentRotacio = 1;
                        }
                    }
                    panellDeJoc.this.posicioInicialRatoli_X = coordRatoli_x;
                    panellDeJoc.this.posicioInicialRatoli_Y = coordRatoli_y;
                }
                if (panellDeJoc.this.indexPecaSeleccionada >= 0 & (e.getModifiersEx() & 0x800) != 0) {
                    panellDeJoc.this.modePecaMovimentRotacio = 1;
                    panellDeJoc.this.jocPeces.arrayPeces[panellDeJoc.this.indexPecaSeleccionada].simetriaPeca();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                panellDeJoc.this.modePecaMovimentRotacio = 1;
                if (((panellDeJoc)panellDeJoc.this).configPanellDeJoc.configuracioJoc.nivellJoc == 1 & panellDeJoc.this.indexPecaSeleccionada >= 0 & ((panellDeJoc)panellDeJoc.this).configPanellDeJoc.configuracioJoc.jocIniciat) {
                    panellDeJoc.this.colocaPecaNivellInfantil(panellDeJoc.this.indexPecaSeleccionada);
                }
                if ((e.getModifiersEx() & 0x200) == 0) {
                    Point aferra = new Point(0, 0);
                    Rectangle tamany = panellDeJoc.this.getBounds();
                    aferra = panellDeJoc.this.jocPeces.aferraPeca();
                    if (panellDeJoc.this.indexPecaSeleccionada >= 0) {
                        panellDeJoc.this.jocPeces.arrayPeces[panellDeJoc.this.indexPecaSeleccionada].mouPeca(aferra.x, aferra.y, tamany);
                    }
                }
                panellDeJoc.this.indexPecaSeleccionada = -1;
                if (panellDeJoc.this.comprovaSolucio(0.7)) {
                    panellDeJoc.this.firePropertyChange(panellDeJoc.SOLUCIO_TROBADA, false, true);
                    panellDeJoc.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Rectangle tamany = panellDeJoc.this.getBounds();
                switch (panellDeJoc.this.modePecaMovimentRotacio) {
                    case 2: {
                        if (panellDeJoc.this.jocPeces.mouPeca(panellDeJoc.this.indexPecaSeleccionada, e.getX() - panellDeJoc.this.posicioInicialRatoli_X, e.getY() - panellDeJoc.this.posicioInicialRatoli_Y, tamany)) {
                            panellDeJoc.this.posicioInicialRatoli_X = e.getX();
                            panellDeJoc.this.posicioInicialRatoli_Y = e.getY();
                            break;
                        }
                        panellDeJoc.this.modePecaMovimentRotacio = 3;
                        break;
                    }
                    case 3: {
                        if (!panellDeJoc.this.jocPeces.rotaPeca(panellDeJoc.this.indexPecaSeleccionada, e.getX(), e.getY(), tamany)) {
                            panellDeJoc.this.modePecaMovimentRotacio = 2;
                        }
                        panellDeJoc.this.posicioInicialRatoli_X = e.getX();
                        panellDeJoc.this.posicioInicialRatoli_Y = e.getY();
                    }
                }
            }
        });
    }

    public void construeix(RootPaneContainer contenidorArrel) {
        Container contenidor = contenidorArrel.getContentPane();
        contenidor.add(this);
    }

    public void creaConjuntsPeces() {
        this.jocPeces = new ConjuntDePeces(this.configPanellDeJoc, this, this, this.escala, Color.BLACK);
        this.jocFigura = new ConjuntDePeces(this.configPanellDeJoc, this, this, this.escala, Color.WHITE);
        this.jocFigura.estableixVisible(false);
    }

    @Override
    public final void paint(Graphics g) {
        Arc2D.Double arc;
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g2.setStroke(limits);
        if (this.jocFigura.emetVisible()) {
            int i;
            for (i = 0; i <= this.jocFigura.arrayPeces.length - 1; ++i) {
                Polygon poligonPeca = this.jocFigura.arrayPeces[i].emetPoligon(1.0);
                g2.setPaint(this.jocFigura.arrayPeces[i].emetColorPeca());
                g2.fill(poligonPeca);
                g2.setPaint(this.jocFigura.arrayPeces[i].emetColorPeca());
                g2.draw(poligonPeca);
                if (!this.jocFigura.arrayPeces[i].ambArc) continue;
                arc = this.jocFigura.arrayPeces[i].emetArcPeca(1.0);
                g2.setPaint(this.jocFigura.arrayPeces[i].emetColorPeca());
                g2.draw(arc);
                g2.fill(arc);
            }
            for (i = 0; i <= this.jocFigura.arrayPeces.length - 1; ++i) {
                g2.setPaint(this.jocFigura.arrayPeces[i].emetColorPeca());
                g2.draw(this.jocFigura.arrayPeces[i].emetPoligon(0.7));
            }
            if (this.configPanellDeJoc.configuracioJoc.mostraSilueta) {
                Area areaFigura = new Area();
                this.calculaSilueta(areaFigura);
                g2.setPaint(Color.BLACK);
                g2.fill(areaFigura);
            }
        }
        if (this.jocPeces.emetVisible()) {
            for (int i = 0; i <= this.jocPeces.arrayPeces.length - 1; ++i) {
                if (i == this.indexPecaSeleccionada) {
                    AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                    g2.setComposite(ac);
                }
                Polygon poligonPecaJoc = this.jocPeces.arrayPeces[i].emetPoligon(1.0);
                g2.setPaint(this.jocPeces.arrayPeces[i].emetColorPeca());
                g2.fill(poligonPecaJoc);
                g2.setPaint(this.jocPeces.arrayPeces[i].emetColorCostats());
                g2.draw(poligonPecaJoc);
                if (!this.jocPeces.arrayPeces[i].ambArc) continue;
                arc = this.jocPeces.arrayPeces[i].emetArcPeca(1.0);
                g2.draw(arc);
                g2.fill(arc);
            }
        }
    }

    private void calculaSilueta(Area areaInicial) {
        for (int i = 0; i <= this.jocFigura.arrayPeces.length - 1; ++i) {
            Polygon poli = this.jocFigura.arrayPeces[i].emetPoligon(1.02);
            Area areaFigura1 = new Area(poli);
            areaInicial.add(areaFigura1);
            if (!this.jocFigura.arrayPeces[i].ambArc) continue;
            Arc2D.Double arc = this.jocFigura.arrayPeces[i].emetArcPeca(0.999);
            Area areaArc = new Area(arc);
            areaInicial.add(areaArc);
        }
    }

    public boolean comprovaSolucio(double precissio) {
        int i;
        if (!this.configPanellDeJoc.configuracioJoc.figuraPerResoldre) {
            return true;
        }
        Polygon[] poligonsFigura = new Polygon[this.jocFigura.arrayPeces.length];
        boolean solucio = true;
        Point puntVertex = new Point();
        if (this.configPanellDeJoc.configuracioJoc.nivellJoc == 4 & !this.configPanellDeJoc.configuracioJoc.mostraSilueta) {
            this.jocPeces.recolocaConjuntPeces(this.jocFigura);
        }
        for (i = 0; i <= this.jocFigura.arrayPeces.length - 1; ++i) {
            poligonsFigura[i] = this.jocFigura.arrayPeces[i].emetPoligon(precissio);
        }
        for (i = 0; i <= poligonsFigura.length - 1; ++i) {
            for (int j = 0; j <= poligonsFigura[i].npoints - 1; ++j) {
                boolean solucioPeca = false;
                puntVertex.x = poligonsFigura[i].xpoints[j];
                puntVertex.y = poligonsFigura[i].ypoints[j];
                for (int k = 0; k <= this.jocPeces.arrayPeces.length - 1; ++k) {
                    if (!this.jocPeces.arrayPeces[k].puntInteriorPeca(puntVertex.x, puntVertex.y)) continue;
                    solucioPeca = true;
                }
                if (solucioPeca) continue;
                solucio = false;
            }
        }
        return solucio;
    }

    public int comprovaFigura(double precissio) {
        if (!this.configPanellDeJoc.configuracioJoc.figuraPerResoldre) {
            return 100;
        }
        Polygon[] poligonsFigura = new Polygon[this.jocFigura.arrayPeces.length];
        int solucio = 100;
        Point puntVertex = new Point();
        if (this.configPanellDeJoc.configuracioJoc.nivellJoc == 4 & !this.configPanellDeJoc.configuracioJoc.mostraSilueta) {
            this.jocPeces.recolocaConjuntPeces(this.jocFigura);
        }
        for (int i = 0; i <= this.jocFigura.arrayPeces.length - 1; ++i) {
            poligonsFigura[i] = this.jocFigura.arrayPeces[i].emetPoligon(precissio);
        }
        int vertexCorrecte = 0;
        int vertexTotals = 0;
        for (int i = 0; i <= poligonsFigura.length - 1; ++i) {
            for (int j = 0; j <= poligonsFigura[i].npoints - 1; ++j) {
                int solucioPeca = 0;
                ++vertexTotals;
                puntVertex.x = poligonsFigura[i].xpoints[j];
                puntVertex.y = poligonsFigura[i].ypoints[j];
                for (int k = 0; k <= this.jocPeces.arrayPeces.length - 1; ++k) {
                    if (!this.jocPeces.arrayPeces[k].puntInteriorPeca(puntVertex.x, puntVertex.y)) continue;
                    ++vertexCorrecte;
                    solucioPeca = 100;
                }
                if (solucioPeca != 0) continue;
                solucio = 0;
            }
        }
        return Math.max(solucio, Math.round(vertexCorrecte * 100 / vertexTotals));
    }

    private void colocaPeca(int indexPeca) {
        if (indexPeca >= 0 & indexPeca <= this.jocPeces.arrayPeces.length) {
            for (int k = 0; k <= this.jocFigura.arrayPeces.length - 1; ++k) {
                if (this.jocFigura.arrayPeces[k].tipusPeca != this.jocPeces.arrayPeces[indexPeca].tipusPeca || this.pecaJaColocada(k)) continue;
                this.colocaPeca(indexPeca, k);
            }
        }
    }

    private void colocaPecaNivellInfantil(int indexPeca) {
        Area areaFigura = new Area();
        this.calculaSilueta(areaFigura);
        if (areaFigura.contains(this.jocPeces.arrayPeces[indexPeca].centrePeca())) {
            this.colocaPeca(indexPeca);
        }
    }

    private boolean pecaJaColocada(int indexPeca) {
        boolean resultat = false;
        for (int k = 0; k <= this.jocPeces.arrayPeces.length - 1; ++k) {
            if (!this.jocPeces.arrayPeces[k].cadenaPropietatsPeca(this.jocFigura.vertexSuperiorEsquerra(this.jocFigura.arrayPeces)).equals(this.jocFigura.arrayPeces[indexPeca].cadenaPropietatsPeca(this.jocFigura.vertexSuperiorEsquerra(this.jocFigura.arrayPeces)))) continue;
            resultat = true;
        }
        return resultat;
    }

    private void colocaPeca(int pecaAColocar, int pecaFigura) {
        this.jocPeces.arrayPeces[pecaAColocar].reiniciaAnglesVertex();
        if (this.jocPeces.arrayPeces[pecaAColocar].simetriaBool != this.jocFigura.arrayPeces[pecaFigura].simetriaBool) {
            this.jocPeces.arrayPeces[pecaAColocar].simetriaPeca();
        }
        this.jocPeces.arrayPeces[pecaAColocar].posicio_X = this.jocFigura.arrayPeces[pecaFigura].posicio_X;
        this.jocPeces.arrayPeces[pecaAColocar].posicio_Y = this.jocFigura.arrayPeces[pecaFigura].posicio_Y;
        this.jocPeces.arrayPeces[pecaAColocar].estableixAngleRotacio(this.jocFigura.arrayPeces[pecaFigura].anglesVertex[0] - this.jocFigura.arrayPeces[pecaFigura].angleInicial);
        this.jocFigura.recolocaArrayPeces(pecaFigura);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.repaint();
    }
}

