/*  Saper Game.
    Copyright (C) 2007 - Pawel Bednarek
    <bednarek.pawel@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> 
 */
package saper;

import java.awt.Point;
import java.io.PrintStream;
import java.util.List;
import java.util.Random;

import javax.swing.JOptionPane;

/**
 * Automat grajcy
 * @author wrobel.cwirek@wp.pl
 */
public class SaperAutoPlayer extends Thread implements SaperGameListener {

    public static PrintStream out = null;
    
    public static final String SETTINGS_SLEEP = "sleep";
    public static final String SETTINGS_AUTO = "auto";
    
    private static final int STATUS_HIDDEN = 1;
    private static final int STATUS_UNCOVERED = 2;
    private static final int MINES_UNKNOWN = SaperGame.MINE  - 1;
    
    boolean started = false;
    boolean paused = true;
    
    static class SaperField {
        int x = 0;
        int y = 0;
        int status = STATUS_HIDDEN;
        int minesSurrownd = MINES_UNKNOWN;
        int neighboursUncoveredAll = 0;
        int neighboursUncoveredMines = 0;
        int neighbours = 0;
        public SaperField(final int x, final int y, final int width, final int height) {
            this.x = x;
            this.y = y;
            int new_width = width - 1;
            int new_height = height - 1;
            if(   x == 0 && y == 0
               || x == new_width && y == new_height
               || x == 0 && y == new_height
               || x == new_width && y == 0){
                this.neighbours = 3;
            } else if(x == 0 || x == new_width || y == 0 || y == new_height) {
                this.neighbours = 5; 
            } else {
                this.neighbours = 8;
            }
        }
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("x=").append(this.x).append(", ");
            buffer.append("y=").append(this.y).append(", ");
            buffer.append("status=").append((this.status == STATUS_HIDDEN) ? "H" : "U").append(", ");
            buffer.append("mines=").append(this.minesSurrownd).append(", ");
            buffer.append("allUncower=").append(this.neighboursUncoveredAll).append(", ");
            buffer.append("minesUncower=").append(this.neighboursUncoveredMines).append(", ");
            buffer.append("neighbours=").append(this.neighbours);
            return buffer.toString();
        }
    }
    
    private int width;
    private int height;
    private SaperFrame saperFrame = null;
    private SaperField[][] mineField = null;
    private SaperGame saperGame = null;
    boolean random = false;
    int sleepTime = 100;
    
    public SaperAutoPlayer(SaperFrame saperFrame){
        this.saperFrame = saperFrame;
    }
    
    private final Object TRUE = new Object();
    private final Object FALSE = new Object();
    
    private Object think = this.FALSE;
    
    /**
     * @see java.lang.Thread#run()
     */
    public void run() {
        if(this.saperGame != null && this.saperGame.allowPlay()){
            this.started = true;
            this.think = this.TRUE;
            while(this.started && !interrupted()){
                try {
                    if(!this.paused){
                        if(this.think == this.TRUE){
                            if(out != null) out.println("SaperPlayer.run() - myl");
                            this.think = this.FALSE;
                            think();
                            doSleep();
                        }
                    }
                    Thread.sleep(10);
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                
            }
        }
    }
    
    protected void think(){
        // znalezienie pierwszego pewniaka
        SaperField choosen = null;
        SaperField tmp = null;
        MAIN_LOOP:
        for(int x = 0; x < this.width; x++){
            for(int y = 0; y < this.height; y++){
                tmp = this.mineField[x][y];
                if(tmp.status == STATUS_HIDDEN) continue;
                if(tmp.neighbours == tmp.neighboursUncoveredAll) continue;
                if(tmp.minesSurrownd == tmp.neighboursUncoveredMines) {
                    choosen = tmp;
                    break MAIN_LOOP;
                }
                if(tmp.minesSurrownd - tmp.neighboursUncoveredMines == tmp.neighbours - tmp.neighboursUncoveredAll){
                    choosen = tmp;
                    break MAIN_LOOP;
                }
            }
        }
        // jesli pewnika znaleziony
        if(choosen != null){
            if(out != null) out.println("Selecting - deterministic "+choosen.toString());
            if(!this.saperGame.isError()) pressRightButtonTwice(choosen.x,choosen.y,this.saperGame);
            return;
        }
        // jesli nie ma pewniaka i ma byc random
        if(this.random){
            Random rand = new Random();
            do {
                if(out != null) out.println("Selecting - random");
                choosen = this.mineField[rand.nextInt(this.width)][rand.nextInt(this.height)];
            } while (choosen.status == STATUS_UNCOVERED);
            if(out != null) out.println("Selecting - random            "+choosen.toString());
            if(!this.saperGame.isError()) pressLeftButtonOnes(choosen.x,choosen.y,this.saperGame);
            return;
        }
        // jesli nie wymysli nic to koniec myslenia, uzytkownik ma zaczac
        // sam wybierac pola
        this.paused = true;
        if(out != null) out.println("SaperPlayer.think() - no idea");
        JOptionPane.showMessageDialog(this.saperFrame,"Automatic selecting - disabled!","Saper",JOptionPane.INFORMATION_MESSAGE);
    }
    
    public static final void pressLeftButtonOnes(int x, int y, SaperGame game){
        game.uncoverField(x,y,true);
    }
    
    public static final void pressRightButtonOnes(int x, int y, SaperGame game){
        game.uncoverField(x,y,false);
    }
    
    public static final void pressRightButtonTwice(int x, int y, SaperGame game){
        game.uncoverNeighbours(x,y);
    }
    
    private void changeNeighboursOf(int x, int y, int uncoveredAll, int uncoveredMines){
        for(int i = (x - 1); i <= (x + 1); i++){
            if(i >= 0 && i < this.width){
                for(int j = y - 1; j <= y + 1; j++){
                    if(j >= 0 && j < this.height){
                        if(i == x && j == y) continue;
                        this.mineField[i][j].neighboursUncoveredAll += uncoveredAll;
                        this.mineField[i][j].neighboursUncoveredMines += uncoveredMines;
                    }
                }
            }
        }
    }
    
    /* (non-Javadoc)
     * @see saper.SaperGameListener#gameStarted(saper.SaperGameEvent)
     */
    public void gameStarted(SaperGameEvent event) {
        if(!this.paused){
            this.paused = true;
        }
        this.saperGame = event.getGame();
        this.width = this.saperGame.getWidth();
        this.height = this.saperGame.getHeight();
        this.mineField = new SaperField[this.width][this.height];
        for (int i = 0; i < this.width; i++) {
            for (int j = 0; j < this.height; j++) {
                this.mineField[i][j] = new SaperField(i,j,this.width,this.height);
            }
        }
    }

    /* (non-Javadoc)
     * @see saper.SaperGameListener#gameFieldsUncovered(saper.SaperGameEvent)
     */
    public void gameFieldsUncovered(SaperGameEvent event) {
        if(this.saperGame != event.getGame()) throw new IllegalStateException("Wrong game");
        if(this.saperGame.isError()) this.paused = true;
        List list = event.getFields();
        if(out != null) out.println("SaperPlayer.gameFieldsUncovered() " + list.size() +" punktow odkrytych");
        for (int i = 0, n = list.size(); i < n; i++) {
            Point element = (Point) list.get(i);
            SaperField field = this.mineField[element.x][element.y];
            field.status = STATUS_UNCOVERED;
            field.minesSurrownd = event.getMinesCount(element);
            if(field.minesSurrownd == SaperGame.MINE){
                changeNeighboursOf(element.x,element.y,1,1);
            } else {
                changeNeighboursOf(element.x,element.y,1,0);
            }
            
        }
        if(this.started && this.saperGame.allowPlay() && !this.saperGame.isError()){
            if(out != null) out.println("SaperPlayer.gameFieldsUncovered() - moge myslec");
            this.think = this.TRUE;
        }
    }

    /* (non-Javadoc)
     * @see saper.SaperGameListener#gameVictory(saper.SaperGameEvent)
     */
    public void gameVictory(SaperGameEvent event) {
        if(this.saperGame != event.getGame()) throw new IllegalStateException("Wrong game");
        this.paused = true;
    }

    /* (non-Javadoc)
     * @see saper.SaperGameListener#gameLost(saper.SaperGameEvent)
     */
    public void gameLost(SaperGameEvent event) {
        if(this.saperGame != event.getGame()) throw new IllegalStateException("Wrong game");
        this.paused = true;
    }

    /* (non-Javadoc)
     * @see saper.SaperGameListener#gameFieldMineStatusChanged(saper.SaperGameEvent)
     */
    public void gameFieldMineStatusChanged(SaperGameEvent event) {
        if(this.saperGame != event.getGame()) throw new IllegalStateException("Wrong game");
        List list = event.getFields();
        if(out != null) out.println("SaperPlayer.gameFieldMineStatusChanged() " + list.size() +" punktow odkrytych");
        for (int i = 0, n = list.size(); i < n; i++) {
            Point element = (Point) list.get(i);
            SaperField field = this.mineField[element.x][element.y];
            if(event.isPointCleared(element)){
                int old = field.minesSurrownd;
                field.minesSurrownd = MINES_UNKNOWN;
                field.status = STATUS_HIDDEN;
                if(old == SaperGame.MINE){
                    changeNeighboursOf(field.x,field.y,-1,-1);
                } else {
                    changeNeighboursOf(field.x,field.y,-1,0);
                }
            } else {
                field.minesSurrownd = event.getMinesCount(element);
                field.status = STATUS_UNCOVERED;
                if(field.minesSurrownd == SaperGame.MINE){
                    changeNeighboursOf(field.x,field.y,1,1);
                } else {
                    changeNeighboursOf(field.x,field.y,1,0);
                }
            }
        }
        if(this.started && this.saperGame.allowPlay()){
            if(out != null) out.println("SaperPlayer.gameFieldMineStatusChanged() - moge myslec");
            this.think = this.TRUE;
        }
    }

    /**
     * 
     */
    public void stopPlaing() {
        this.paused = true;
    } 
    
    public void startPlaing(){
        this.paused = false;
        this.think = this.TRUE;
    }
    
    public boolean isRandom() {
        return this.random;
    }
    
    public void setRandom(boolean random) {
        this.random = random;
    }
         
    public int getSleepTime() {
        return this.sleepTime;
    }
    
    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }
    
    private void doSleep(){
        if(this.sleepTime > 0){
            try {
                Thread.sleep(this.sleepTime);
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}
