/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class XMLElement
implements Serializable {
    static final long serialVersionUID = -2383376380548624920L;
    public static final int NO_LINE = -1;
    private Properties attributes = new Properties();
    private Vector children = new Vector(8);
    private String name;
    private String content;
    private String systemID;
    private int lineNr;

    public XMLElement() {
        this(null, null, -1);
    }

    public XMLElement(String name) {
        this(name, null, -1);
    }

    public XMLElement(String name, String systemID, int lineNr) {
        this.name = name;
        this.content = null;
        this.lineNr = lineNr;
        this.systemID = systemID;
    }

    protected void finalize() throws Throwable {
        this.attributes = null;
        this.children = null;
        this.name = null;
        this.content = null;
        this.systemID = null;
        super.finalize();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = name;
    }

    public void addChild(XMLElement child) {
        XMLElement lastChild;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child.getName() == null && !this.children.isEmpty() && (lastChild = (XMLElement)this.children.lastElement()).getName() == null) {
            lastChild.setContent(lastChild.getContent() + child.getContent());
            return;
        }
        this.children.addElement(child);
    }

    public void removeChild(XMLElement child) {
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        this.children.removeElement(child);
    }

    public void removeChildAtIndex(int index) {
        this.children.removeElementAt(index);
    }

    public Enumeration enumerateChildren() {
        return this.children.elements();
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public Vector getChildren() {
        return this.children;
    }

    public XMLElement getChildAtIndex(int index) throws ArrayIndexOutOfBoundsException {
        return (XMLElement)this.children.elementAt(index);
    }

    public XMLElement getFirstChildNamed(String name) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            XMLElement child = (XMLElement)enumeration.nextElement();
            String cName = child.getName();
            if (cName == null || !cName.equals(name)) continue;
            return child;
        }
        return null;
    }

    public Vector getChildrenNamed(String name) {
        Vector<XMLElement> result = new Vector<XMLElement>(this.children.size());
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            XMLElement child = (XMLElement)enumeration.nextElement();
            String cName = child.getName();
            if (cName == null || !cName.equals(name)) continue;
            result.addElement(child);
        }
        return result;
    }

    public String getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public String getAttribute(String name, String defaultValue) {
        return this.attributes.getProperty(name, defaultValue);
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Enumeration enumerateAttributeNames() {
        return this.attributes.keys();
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}

