/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config;

import java.io.InputStreamReader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.mars_sim.msp.config.SimulationConfig;
import org.mars_sim.msp.config.model.building.BuildingList;
import org.mars_sim.msp.config.model.construction.Construction;
import org.mars_sim.msp.config.model.crop.CropList;
import org.mars_sim.msp.config.model.landmark.LandmarkList;
import org.mars_sim.msp.config.model.malfunction.MalfunctionList;
import org.mars_sim.msp.config.model.medical.Medical;
import org.mars_sim.msp.config.model.mineral.MineralConcentrations;
import org.mars_sim.msp.config.model.part.PartList;
import org.mars_sim.msp.config.model.partpackage.PartPackageList;
import org.mars_sim.msp.config.model.people.PeopleConfiguration;
import org.mars_sim.msp.config.model.resource.ResourceList;
import org.mars_sim.msp.config.model.resupply.ResupplyList;
import org.mars_sim.msp.config.model.settlement.SettlementConfiguration;
import org.mars_sim.msp.config.model.simulation.SimulationConfiguration;
import org.mars_sim.msp.config.model.vehicle.VehicleConfiguration;

public class SimulationConfigImpl
implements SimulationConfig {
    private BuildingList buildings;
    private Construction constructions;
    private CropList crops;
    private LandmarkList landmarks;
    private MalfunctionList malfunctions;
    private Medical medicals;
    private MineralConcentrations minerals;
    private PartPackageList partPackages;
    private PartList parts;
    private PeopleConfiguration people;
    private ResourceList resources;
    private ResupplyList resupplies;
    private SettlementConfiguration settlements;
    private SimulationConfiguration simulationConfiguration;
    private VehicleConfiguration vehicles;

    public SimulationConfigImpl() throws MarshalException, ValidationException {
        this.load();
    }

    @Override
    public BuildingList getBuildings() {
        return this.buildings;
    }

    @Override
    public Construction getConstructions() {
        return this.constructions;
    }

    @Override
    public CropList getCrops() {
        return this.crops;
    }

    @Override
    public LandmarkList getLandmarks() {
        return this.landmarks;
    }

    @Override
    public MalfunctionList getMalfunctions() {
        return this.malfunctions;
    }

    @Override
    public Medical getMedicals() {
        return this.medicals;
    }

    @Override
    public MineralConcentrations getMinerals() {
        return this.minerals;
    }

    @Override
    public PartPackageList getPartPackages() {
        return this.partPackages;
    }

    @Override
    public PartList getParts() {
        return this.parts;
    }

    @Override
    public PeopleConfiguration getPeople() {
        return this.people;
    }

    @Override
    public ResourceList getResources() {
        return this.resources;
    }

    @Override
    public ResupplyList getResupplies() {
        return this.resupplies;
    }

    @Override
    public SettlementConfiguration getSettlements() {
        return this.settlements;
    }

    @Override
    public SimulationConfiguration getSimulationConfiguration() {
        return this.simulationConfiguration;
    }

    @Override
    public VehicleConfiguration getVehicles() {
        return this.vehicles;
    }

    private void load() throws MarshalException, ValidationException {
        this.buildings = BuildingList.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/building.xml")));
        this.constructions = Construction.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/construction.xml")));
        this.crops = CropList.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/crops.xml")));
        this.landmarks = LandmarkList.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/landmarks.xml")));
        this.malfunctions = MalfunctionList.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/malfunctions.xml")));
        this.medicals = Medical.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/medical.xml")));
        this.minerals = MineralConcentrations.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/minerals.xml")));
        this.partPackages = PartPackageList.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/part_packages.xml")));
        this.parts = PartList.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/parts.xml")));
        this.people = PeopleConfiguration.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/people.xml")));
        this.resources = ResourceList.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/resources.xml")));
        this.resupplies = ResupplyList.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/resupplies.xml")));
        this.settlements = SettlementConfiguration.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/settlements.xml")));
        this.simulationConfiguration = SimulationConfiguration.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/simulation.xml")));
        this.vehicles = VehicleConfiguration.unmarshal(new InputStreamReader(this.getClass().getResourceAsStream("/config/vehicles.xml")));
    }
}

