/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config.model.building;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.mars_sim.msp.config.model.building.Input;
import org.mars_sim.msp.config.model.building.Output;
import org.mars_sim.msp.config.model.types.ProcessDefaultType;
import org.xml.sax.ContentHandler;

public class Process
implements Serializable {
    private String _name;
    private double _powerRequired;
    private boolean _has_powerRequired;
    private ProcessDefaultType _default;
    private List<Input> _inputList = new ArrayList<Input>();
    private List<Output> _outputList = new ArrayList<Output>();

    public void addInput(Input vInput) throws IndexOutOfBoundsException {
        this._inputList.add(vInput);
    }

    public void addInput(int index, Input vInput) throws IndexOutOfBoundsException {
        this._inputList.add(index, vInput);
    }

    public void addOutput(Output vOutput) throws IndexOutOfBoundsException {
        this._outputList.add(vOutput);
    }

    public void addOutput(int index, Output vOutput) throws IndexOutOfBoundsException {
        this._outputList.add(index, vOutput);
    }

    public void deletePowerRequired() {
        this._has_powerRequired = false;
    }

    public Enumeration<? extends Input> enumerateInput() {
        return Collections.enumeration(this._inputList);
    }

    public Enumeration<? extends Output> enumerateOutput() {
        return Collections.enumeration(this._outputList);
    }

    public ProcessDefaultType getDefault() {
        return this._default;
    }

    public Input getInput(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._inputList.size()) {
            throw new IndexOutOfBoundsException("getInput: Index value '" + index + "' not in range [0.." + (this._inputList.size() - 1) + "]");
        }
        return this._inputList.get(index);
    }

    public Input[] getInput() {
        Input[] array = new Input[]{};
        return this._inputList.toArray(array);
    }

    public int getInputCount() {
        return this._inputList.size();
    }

    public String getName() {
        return this._name;
    }

    public Output getOutput(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._outputList.size()) {
            throw new IndexOutOfBoundsException("getOutput: Index value '" + index + "' not in range [0.." + (this._outputList.size() - 1) + "]");
        }
        return this._outputList.get(index);
    }

    public Output[] getOutput() {
        Output[] array = new Output[]{};
        return this._outputList.toArray(array);
    }

    public int getOutputCount() {
        return this._outputList.size();
    }

    public double getPowerRequired() {
        return this._powerRequired;
    }

    public boolean hasPowerRequired() {
        return this._has_powerRequired;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Input> iterateInput() {
        return this._inputList.iterator();
    }

    public Iterator<? extends Output> iterateOutput() {
        return this._outputList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllInput() {
        this._inputList.clear();
    }

    public void removeAllOutput() {
        this._outputList.clear();
    }

    public boolean removeInput(Input vInput) {
        boolean removed = this._inputList.remove(vInput);
        return removed;
    }

    public Input removeInputAt(int index) {
        Input obj = this._inputList.remove(index);
        return obj;
    }

    public boolean removeOutput(Output vOutput) {
        boolean removed = this._outputList.remove(vOutput);
        return removed;
    }

    public Output removeOutputAt(int index) {
        Output obj = this._outputList.remove(index);
        return obj;
    }

    public void setDefault(ProcessDefaultType _default) {
        this._default = _default;
    }

    public void setInput(int index, Input vInput) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._inputList.size()) {
            throw new IndexOutOfBoundsException("setInput: Index value '" + index + "' not in range [0.." + (this._inputList.size() - 1) + "]");
        }
        this._inputList.set(index, vInput);
    }

    public void setInput(Input[] vInputArray) {
        this._inputList.clear();
        for (int i = 0; i < vInputArray.length; ++i) {
            this._inputList.add(vInputArray[i]);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setOutput(int index, Output vOutput) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._outputList.size()) {
            throw new IndexOutOfBoundsException("setOutput: Index value '" + index + "' not in range [0.." + (this._outputList.size() - 1) + "]");
        }
        this._outputList.set(index, vOutput);
    }

    public void setOutput(Output[] vOutputArray) {
        this._outputList.clear();
        for (int i = 0; i < vOutputArray.length; ++i) {
            this._outputList.add(vOutputArray[i]);
        }
    }

    public void setPowerRequired(double powerRequired) {
        this._powerRequired = powerRequired;
        this._has_powerRequired = true;
    }

    public static Process unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Process)Unmarshaller.unmarshal(Process.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

