/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config.model.building;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.mars_sim.msp.config.model.building.Process;
import org.xml.sax.ContentHandler;

public class ResourceProcessing
implements Serializable {
    private double _powerDownLevel;
    private boolean _has_powerDownLevel;
    private List<Process> _processList = new ArrayList<Process>();

    public void addProcess(Process vProcess) throws IndexOutOfBoundsException {
        this._processList.add(vProcess);
    }

    public void addProcess(int index, Process vProcess) throws IndexOutOfBoundsException {
        this._processList.add(index, vProcess);
    }

    public void deletePowerDownLevel() {
        this._has_powerDownLevel = false;
    }

    public Enumeration<? extends Process> enumerateProcess() {
        return Collections.enumeration(this._processList);
    }

    public double getPowerDownLevel() {
        return this._powerDownLevel;
    }

    public Process getProcess(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._processList.size()) {
            throw new IndexOutOfBoundsException("getProcess: Index value '" + index + "' not in range [0.." + (this._processList.size() - 1) + "]");
        }
        return this._processList.get(index);
    }

    public Process[] getProcess() {
        Process[] array = new Process[]{};
        return this._processList.toArray(array);
    }

    public int getProcessCount() {
        return this._processList.size();
    }

    public boolean hasPowerDownLevel() {
        return this._has_powerDownLevel;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Process> iterateProcess() {
        return this._processList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllProcess() {
        this._processList.clear();
    }

    public boolean removeProcess(Process vProcess) {
        boolean removed = this._processList.remove(vProcess);
        return removed;
    }

    public Process removeProcessAt(int index) {
        Process obj = this._processList.remove(index);
        return obj;
    }

    public void setPowerDownLevel(double powerDownLevel) {
        this._powerDownLevel = powerDownLevel;
        this._has_powerDownLevel = true;
    }

    public void setProcess(int index, Process vProcess) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._processList.size()) {
            throw new IndexOutOfBoundsException("setProcess: Index value '" + index + "' not in range [0.." + (this._processList.size() - 1) + "]");
        }
        this._processList.set(index, vProcess);
    }

    public void setProcess(Process[] vProcessArray) {
        this._processList.clear();
        for (int i = 0; i < vProcessArray.length; ++i) {
            this._processList.add(vProcessArray[i]);
        }
    }

    public static ResourceProcessing unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (ResourceProcessing)Unmarshaller.unmarshal(ResourceProcessing.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

