/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config.model.manufacturing;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.mars_sim.msp.config.model.manufacturing.Part;
import org.mars_sim.msp.config.model.manufacturing.Resource;
import org.xml.sax.ContentHandler;

public class Inputs
implements Serializable {
    private List<Resource> _resourceList = new ArrayList<Resource>();
    private List<Part> _partList = new ArrayList<Part>();

    public void addPart(Part vPart) throws IndexOutOfBoundsException {
        this._partList.add(vPart);
    }

    public void addPart(int index, Part vPart) throws IndexOutOfBoundsException {
        this._partList.add(index, vPart);
    }

    public void addResource(Resource vResource) throws IndexOutOfBoundsException {
        this._resourceList.add(vResource);
    }

    public void addResource(int index, Resource vResource) throws IndexOutOfBoundsException {
        this._resourceList.add(index, vResource);
    }

    public Enumeration<? extends Part> enumeratePart() {
        return Collections.enumeration(this._partList);
    }

    public Enumeration<? extends Resource> enumerateResource() {
        return Collections.enumeration(this._resourceList);
    }

    public Part getPart(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._partList.size()) {
            throw new IndexOutOfBoundsException("getPart: Index value '" + index + "' not in range [0.." + (this._partList.size() - 1) + "]");
        }
        return this._partList.get(index);
    }

    public Part[] getPart() {
        Part[] array = new Part[]{};
        return this._partList.toArray(array);
    }

    public int getPartCount() {
        return this._partList.size();
    }

    public Resource getResource(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._resourceList.size()) {
            throw new IndexOutOfBoundsException("getResource: Index value '" + index + "' not in range [0.." + (this._resourceList.size() - 1) + "]");
        }
        return this._resourceList.get(index);
    }

    public Resource[] getResource() {
        Resource[] array = new Resource[]{};
        return this._resourceList.toArray(array);
    }

    public int getResourceCount() {
        return this._resourceList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Part> iteratePart() {
        return this._partList.iterator();
    }

    public Iterator<? extends Resource> iterateResource() {
        return this._resourceList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllPart() {
        this._partList.clear();
    }

    public void removeAllResource() {
        this._resourceList.clear();
    }

    public boolean removePart(Part vPart) {
        boolean removed = this._partList.remove(vPart);
        return removed;
    }

    public Part removePartAt(int index) {
        Part obj = this._partList.remove(index);
        return obj;
    }

    public boolean removeResource(Resource vResource) {
        boolean removed = this._resourceList.remove(vResource);
        return removed;
    }

    public Resource removeResourceAt(int index) {
        Resource obj = this._resourceList.remove(index);
        return obj;
    }

    public void setPart(int index, Part vPart) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._partList.size()) {
            throw new IndexOutOfBoundsException("setPart: Index value '" + index + "' not in range [0.." + (this._partList.size() - 1) + "]");
        }
        this._partList.set(index, vPart);
    }

    public void setPart(Part[] vPartArray) {
        this._partList.clear();
        for (int i = 0; i < vPartArray.length; ++i) {
            this._partList.add(vPartArray[i]);
        }
    }

    public void setResource(int index, Resource vResource) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._resourceList.size()) {
            throw new IndexOutOfBoundsException("setResource: Index value '" + index + "' not in range [0.." + (this._resourceList.size() - 1) + "]");
        }
        this._resourceList.set(index, vResource);
    }

    public void setResource(Resource[] vResourceArray) {
        this._resourceList.clear();
        for (int i = 0; i < vResourceArray.length; ++i) {
            this._resourceList.add(vResourceArray[i]);
        }
    }

    public static Inputs unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Inputs)Unmarshaller.unmarshal(Inputs.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

