/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config.model.manufacturing;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.mars_sim.msp.config.model.manufacturing.Process;
import org.mars_sim.msp.config.model.manufacturing.Salvage;
import org.xml.sax.ContentHandler;

public class ManufacturingProcesses
implements Serializable {
    private List<Process> _processList = new ArrayList<Process>();
    private List<Salvage> _salvageList = new ArrayList<Salvage>();

    public void addProcess(Process vProcess) throws IndexOutOfBoundsException {
        this._processList.add(vProcess);
    }

    public void addProcess(int index, Process vProcess) throws IndexOutOfBoundsException {
        this._processList.add(index, vProcess);
    }

    public void addSalvage(Salvage vSalvage) throws IndexOutOfBoundsException {
        this._salvageList.add(vSalvage);
    }

    public void addSalvage(int index, Salvage vSalvage) throws IndexOutOfBoundsException {
        this._salvageList.add(index, vSalvage);
    }

    public Enumeration<? extends Process> enumerateProcess() {
        return Collections.enumeration(this._processList);
    }

    public Enumeration<? extends Salvage> enumerateSalvage() {
        return Collections.enumeration(this._salvageList);
    }

    public Process getProcess(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._processList.size()) {
            throw new IndexOutOfBoundsException("getProcess: Index value '" + index + "' not in range [0.." + (this._processList.size() - 1) + "]");
        }
        return this._processList.get(index);
    }

    public Process[] getProcess() {
        Process[] array = new Process[]{};
        return this._processList.toArray(array);
    }

    public int getProcessCount() {
        return this._processList.size();
    }

    public Salvage getSalvage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._salvageList.size()) {
            throw new IndexOutOfBoundsException("getSalvage: Index value '" + index + "' not in range [0.." + (this._salvageList.size() - 1) + "]");
        }
        return this._salvageList.get(index);
    }

    public Salvage[] getSalvage() {
        Salvage[] array = new Salvage[]{};
        return this._salvageList.toArray(array);
    }

    public int getSalvageCount() {
        return this._salvageList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Process> iterateProcess() {
        return this._processList.iterator();
    }

    public Iterator<? extends Salvage> iterateSalvage() {
        return this._salvageList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllProcess() {
        this._processList.clear();
    }

    public void removeAllSalvage() {
        this._salvageList.clear();
    }

    public boolean removeProcess(Process vProcess) {
        boolean removed = this._processList.remove(vProcess);
        return removed;
    }

    public Process removeProcessAt(int index) {
        Process obj = this._processList.remove(index);
        return obj;
    }

    public boolean removeSalvage(Salvage vSalvage) {
        boolean removed = this._salvageList.remove(vSalvage);
        return removed;
    }

    public Salvage removeSalvageAt(int index) {
        Salvage obj = this._salvageList.remove(index);
        return obj;
    }

    public void setProcess(int index, Process vProcess) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._processList.size()) {
            throw new IndexOutOfBoundsException("setProcess: Index value '" + index + "' not in range [0.." + (this._processList.size() - 1) + "]");
        }
        this._processList.set(index, vProcess);
    }

    public void setProcess(Process[] vProcessArray) {
        this._processList.clear();
        for (int i = 0; i < vProcessArray.length; ++i) {
            this._processList.add(vProcessArray[i]);
        }
    }

    public void setSalvage(int index, Salvage vSalvage) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._salvageList.size()) {
            throw new IndexOutOfBoundsException("setSalvage: Index value '" + index + "' not in range [0.." + (this._salvageList.size() - 1) + "]");
        }
        this._salvageList.set(index, vSalvage);
    }

    public void setSalvage(Salvage[] vSalvageArray) {
        this._salvageList.clear();
        for (int i = 0; i < vSalvageArray.length; ++i) {
            this._salvageList.add(vSalvageArray[i]);
        }
    }

    public static ManufacturingProcesses unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (ManufacturingProcesses)Unmarshaller.unmarshal(ManufacturingProcesses.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

