/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config.model.part;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.mars_sim.msp.config.model.part.Entity;
import org.xml.sax.ContentHandler;

public class MaintenanceEntityList
implements Serializable {
    private String _name;
    private double _mass;
    private boolean _has_mass;
    private List<Entity> _entityList = new ArrayList<Entity>();

    public void addEntity(Entity vEntity) throws IndexOutOfBoundsException {
        this._entityList.add(vEntity);
    }

    public void addEntity(int index, Entity vEntity) throws IndexOutOfBoundsException {
        this._entityList.add(index, vEntity);
    }

    public void deleteMass() {
        this._has_mass = false;
    }

    public Enumeration<? extends Entity> enumerateEntity() {
        return Collections.enumeration(this._entityList);
    }

    public Entity getEntity(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._entityList.size()) {
            throw new IndexOutOfBoundsException("getEntity: Index value '" + index + "' not in range [0.." + (this._entityList.size() - 1) + "]");
        }
        return this._entityList.get(index);
    }

    public Entity[] getEntity() {
        Entity[] array = new Entity[]{};
        return this._entityList.toArray(array);
    }

    public int getEntityCount() {
        return this._entityList.size();
    }

    public double getMass() {
        return this._mass;
    }

    public String getName() {
        return this._name;
    }

    public boolean hasMass() {
        return this._has_mass;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Entity> iterateEntity() {
        return this._entityList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllEntity() {
        this._entityList.clear();
    }

    public boolean removeEntity(Entity vEntity) {
        boolean removed = this._entityList.remove(vEntity);
        return removed;
    }

    public Entity removeEntityAt(int index) {
        Entity obj = this._entityList.remove(index);
        return obj;
    }

    public void setEntity(int index, Entity vEntity) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._entityList.size()) {
            throw new IndexOutOfBoundsException("setEntity: Index value '" + index + "' not in range [0.." + (this._entityList.size() - 1) + "]");
        }
        this._entityList.set(index, vEntity);
    }

    public void setEntity(Entity[] vEntityArray) {
        this._entityList.clear();
        for (int i = 0; i < vEntityArray.length; ++i) {
            this._entityList.add(vEntityArray[i]);
        }
    }

    public void setMass(double mass) {
        this._mass = mass;
        this._has_mass = true;
    }

    public void setName(String name) {
        this._name = name;
    }

    public static MaintenanceEntityList unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (MaintenanceEntityList)Unmarshaller.unmarshal(MaintenanceEntityList.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

