/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config.model.people;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.mars_sim.msp.config.model.people.Person;
import org.xml.sax.ContentHandler;

public class PersonList
implements Serializable {
    private List<Person> _personList = new ArrayList<Person>();

    public void addPerson(Person vPerson) throws IndexOutOfBoundsException {
        this._personList.add(vPerson);
    }

    public void addPerson(int index, Person vPerson) throws IndexOutOfBoundsException {
        this._personList.add(index, vPerson);
    }

    public Enumeration<? extends Person> enumeratePerson() {
        return Collections.enumeration(this._personList);
    }

    public Person getPerson(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._personList.size()) {
            throw new IndexOutOfBoundsException("getPerson: Index value '" + index + "' not in range [0.." + (this._personList.size() - 1) + "]");
        }
        return this._personList.get(index);
    }

    public Person[] getPerson() {
        Person[] array = new Person[]{};
        return this._personList.toArray(array);
    }

    public int getPersonCount() {
        return this._personList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Person> iteratePerson() {
        return this._personList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllPerson() {
        this._personList.clear();
    }

    public boolean removePerson(Person vPerson) {
        boolean removed = this._personList.remove(vPerson);
        return removed;
    }

    public Person removePersonAt(int index) {
        Person obj = this._personList.remove(index);
        return obj;
    }

    public void setPerson(int index, Person vPerson) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._personList.size()) {
            throw new IndexOutOfBoundsException("setPerson: Index value '" + index + "' not in range [0.." + (this._personList.size() - 1) + "]");
        }
        this._personList.set(index, vPerson);
    }

    public void setPerson(Person[] vPersonArray) {
        this._personList.clear();
        for (int i = 0; i < vPersonArray.length; ++i) {
            this._personList.add(vPersonArray[i]);
        }
    }

    public static PersonList unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (PersonList)Unmarshaller.unmarshal(PersonList.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

