/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config.model.vehicle;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.mars_sim.msp.config.model.vehicle.Capacity;
import org.xml.sax.ContentHandler;

public class Cargo
implements Serializable {
    private double _totalCapacity;
    private boolean _has_totalCapacity;
    private List<Capacity> _capacityList = new ArrayList<Capacity>();

    public void addCapacity(Capacity vCapacity) throws IndexOutOfBoundsException {
        this._capacityList.add(vCapacity);
    }

    public void addCapacity(int index, Capacity vCapacity) throws IndexOutOfBoundsException {
        this._capacityList.add(index, vCapacity);
    }

    public void deleteTotalCapacity() {
        this._has_totalCapacity = false;
    }

    public Enumeration<? extends Capacity> enumerateCapacity() {
        return Collections.enumeration(this._capacityList);
    }

    public Capacity getCapacity(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._capacityList.size()) {
            throw new IndexOutOfBoundsException("getCapacity: Index value '" + index + "' not in range [0.." + (this._capacityList.size() - 1) + "]");
        }
        return this._capacityList.get(index);
    }

    public Capacity[] getCapacity() {
        Capacity[] array = new Capacity[]{};
        return this._capacityList.toArray(array);
    }

    public int getCapacityCount() {
        return this._capacityList.size();
    }

    public double getTotalCapacity() {
        return this._totalCapacity;
    }

    public boolean hasTotalCapacity() {
        return this._has_totalCapacity;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Capacity> iterateCapacity() {
        return this._capacityList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllCapacity() {
        this._capacityList.clear();
    }

    public boolean removeCapacity(Capacity vCapacity) {
        boolean removed = this._capacityList.remove(vCapacity);
        return removed;
    }

    public Capacity removeCapacityAt(int index) {
        Capacity obj = this._capacityList.remove(index);
        return obj;
    }

    public void setCapacity(int index, Capacity vCapacity) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._capacityList.size()) {
            throw new IndexOutOfBoundsException("setCapacity: Index value '" + index + "' not in range [0.." + (this._capacityList.size() - 1) + "]");
        }
        this._capacityList.set(index, vCapacity);
    }

    public void setCapacity(Capacity[] vCapacityArray) {
        this._capacityList.clear();
        for (int i = 0; i < vCapacityArray.length; ++i) {
            this._capacityList.add(vCapacityArray[i]);
        }
    }

    public void setTotalCapacity(double totalCapacity) {
        this._totalCapacity = totalCapacity;
        this._has_totalCapacity = true;
    }

    public static Cargo unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Cargo)Unmarshaller.unmarshal(Cargo.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

