/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config.model.vehicle;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.mars_sim.msp.config.model.vehicle.RoverNameList;
import org.mars_sim.msp.config.model.vehicle.Vehicle;
import org.xml.sax.ContentHandler;

public class VehicleConfiguration
implements Serializable {
    private List<Vehicle> _vehicleList = new ArrayList<Vehicle>();
    private RoverNameList _roverNameList;

    public void addVehicle(Vehicle vVehicle) throws IndexOutOfBoundsException {
        this._vehicleList.add(vVehicle);
    }

    public void addVehicle(int index, Vehicle vVehicle) throws IndexOutOfBoundsException {
        this._vehicleList.add(index, vVehicle);
    }

    public Enumeration<? extends Vehicle> enumerateVehicle() {
        return Collections.enumeration(this._vehicleList);
    }

    public RoverNameList getRoverNameList() {
        return this._roverNameList;
    }

    public Vehicle getVehicle(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._vehicleList.size()) {
            throw new IndexOutOfBoundsException("getVehicle: Index value '" + index + "' not in range [0.." + (this._vehicleList.size() - 1) + "]");
        }
        return this._vehicleList.get(index);
    }

    public Vehicle[] getVehicle() {
        Vehicle[] array = new Vehicle[]{};
        return this._vehicleList.toArray(array);
    }

    public int getVehicleCount() {
        return this._vehicleList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Vehicle> iterateVehicle() {
        return this._vehicleList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllVehicle() {
        this._vehicleList.clear();
    }

    public boolean removeVehicle(Vehicle vVehicle) {
        boolean removed = this._vehicleList.remove(vVehicle);
        return removed;
    }

    public Vehicle removeVehicleAt(int index) {
        Vehicle obj = this._vehicleList.remove(index);
        return obj;
    }

    public void setRoverNameList(RoverNameList roverNameList) {
        this._roverNameList = roverNameList;
    }

    public void setVehicle(int index, Vehicle vVehicle) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._vehicleList.size()) {
            throw new IndexOutOfBoundsException("setVehicle: Index value '" + index + "' not in range [0.." + (this._vehicleList.size() - 1) + "]");
        }
        this._vehicleList.set(index, vVehicle);
    }

    public void setVehicle(Vehicle[] vVehicleArray) {
        this._vehicleList.clear();
        for (int i = 0; i < vVehicleArray.length; ++i) {
            this._vehicleList.add(vVehicleArray[i]);
        }
    }

    public static VehicleConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (VehicleConfiguration)Unmarshaller.unmarshal(VehicleConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

