/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp;

import java.io.File;
import java.io.IOException;
import org.mars_sim.msp.StreamConsumer;

public class MarsProjectStarter {
    public static void main(String[] args) {
        StringBuilder command = new StringBuilder();
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome != null) {
            if (javaHome.contains(" ")) {
                javaHome = "\"" + javaHome;
            }
            command.append(javaHome).append(File.separator).append("bin").append(File.separator).append("java");
            if (javaHome.contains(" ")) {
                command.append("\"");
            }
        } else {
            command.append("java");
        }
        command.append(" -Xms256m");
        command.append(" -Xmx512m");
        command.append(" -Djava.util.logging.config.file=logging.properties");
        command.append(" -cp .").append(File.pathSeparator);
        command.append("*").append(File.pathSeparator);
        command.append("jars").append(File.separator).append("*");
        command.append(" org.mars_sim.msp.MarsProject");
        String commandStr = command.toString();
        System.out.println("Command: " + commandStr);
        try {
            Process process = Runtime.getRuntime().exec(commandStr);
            StreamConsumer errorConsumer = new StreamConsumer(process.getErrorStream(), "OUTPUT");
            StreamConsumer outputConsumer = new StreamConsumer(process.getInputStream(), "OUTPUT");
            errorConsumer.start();
            outputConsumer.start();
            process.waitFor();
            errorConsumer.join();
            outputConsumer.join();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }
}

