/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.MultiIntervalCategoryDataset;
import org.jfree.data.SeriesChangeEvent;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;

public class TaskSeriesCollection
extends AbstractSeriesDataset
implements GanttCategoryDataset,
MultiIntervalCategoryDataset {
    private List keys = new ArrayList();
    private List data = new ArrayList();

    public String getSeriesName(int n) {
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        return taskSeries.getName();
    }

    public int getSeriesCount() {
        return this.getRowCount();
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.keys.size();
    }

    public List getRowKeys() {
        return this.data;
    }

    public List getColumnKeys() {
        return this.keys;
    }

    public Comparable getColumnKey(int n) {
        return (Comparable)this.keys.get(n);
    }

    public int getColumnIndex(Comparable comparable) {
        return this.keys.indexOf(comparable);
    }

    public int getRowIndex(Comparable comparable) {
        return this.data.indexOf(comparable);
    }

    public Comparable getRowKey(int n) {
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        return taskSeries.getName();
    }

    public void add(TaskSeries taskSeries) {
        if (taskSeries == null) {
            throw new IllegalArgumentException("XYSeriesCollection.addSeries(...): cannot add null series.");
        }
        this.data.add(taskSeries);
        taskSeries.addChangeListener(this);
        Iterator iterator = taskSeries.getTasks().iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            String string = task.getDescription();
            int n = this.keys.indexOf(string);
            if (n >= 0) continue;
            this.keys.add(string);
        }
        this.fireDatasetChanged();
    }

    public void remove(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("TaskSeriesCollection.remove(...): index outside valid range.");
        }
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        taskSeries.removeChangeListener(this);
        this.data.remove(n);
        this.fireDatasetChanged();
    }

    public void remove(TaskSeries taskSeries) {
        if (taskSeries == null) {
            throw new IllegalArgumentException("TaskSeriesCollection.remove(...): cannot remove null series.");
        }
        if (this.data.contains(taskSeries)) {
            taskSeries.removeChangeListener(this);
            this.data.remove(taskSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeAll() {
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            TaskSeries taskSeries = (TaskSeries)iterator.next();
            taskSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        int n = this.getRowIndex(comparable);
        int n2 = this.getColumnIndex(comparable2);
        return this.getValue(n, n2);
    }

    public Number getValue(int n, int n2) {
        return this.getStartValue(n, n2);
    }

    public Number getStartValue(Comparable comparable, Comparable comparable2) {
        int n = this.getRowIndex(comparable);
        int n2 = this.getColumnIndex(comparable2);
        return this.getStartValue(n, n2);
    }

    public Number getStartValue(int n, int n2) {
        Long l = null;
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        int n3 = taskSeries.getItemCount();
        if (n2 < n3) {
            Task task = taskSeries.get(n2);
            l = new Long(task.getDuration().getStart().getTime());
        }
        return l;
    }

    public Number getEndValue(Comparable comparable, Comparable comparable2) {
        int n = this.getRowIndex(comparable);
        int n2 = this.getColumnIndex(comparable2);
        return this.getEndValue(n, n2);
    }

    public Number getEndValue(int n, int n2) {
        Long l = null;
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        int n3 = taskSeries.getItemCount();
        if (n2 < n3) {
            Task task = taskSeries.get(n2);
            l = new Long(task.getDuration().getEnd().getTime());
        }
        return l;
    }

    public Number getPercentComplete(int n, int n2) {
        Double d = null;
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        int n3 = taskSeries.getItemCount();
        if (n2 < n3) {
            Task task = taskSeries.get(n2);
            d = task.getPercentComplete();
        }
        return d;
    }

    public Number getPercentComplete(Comparable comparable, Comparable comparable2) {
        int n = this.getRowIndex(comparable);
        int n2 = this.getColumnIndex(comparable2);
        return this.getPercentComplete(n, n2);
    }

    public int getSubIntervalCount(int n, int n2) {
        int n3 = 0;
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        int n4 = taskSeries.getItemCount();
        if (n2 < n4) {
            Task task = taskSeries.get(n2);
            n3 = task.getSubtaskCount();
        }
        return n3;
    }

    public int getSubIntervalCount(Comparable comparable, Comparable comparable2) {
        int n = this.getRowIndex(comparable);
        int n2 = this.getColumnIndex(comparable2);
        return this.getSubIntervalCount(n, n2);
    }

    public Number getStartValue(int n, int n2, int n3) {
        Long l = null;
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        int n4 = taskSeries.getItemCount();
        if (n2 < n4) {
            Task task = taskSeries.get(n2);
            Task task2 = task.getSubtask(n3);
            l = new Long(task2.getDuration().getStart().getTime());
        }
        return l;
    }

    public Number getStartValue(Comparable comparable, Comparable comparable2, int n) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        return this.getStartValue(n2, n3, n);
    }

    public Number getEndValue(int n, int n2, int n3) {
        Long l = null;
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        int n4 = taskSeries.getItemCount();
        if (n2 < n4) {
            Task task = taskSeries.get(n2);
            Task task2 = task.getSubtask(n3);
            l = new Long(task2.getDuration().getEnd().getTime());
        }
        return l;
    }

    public Number getEndValue(Comparable comparable, Comparable comparable2, int n) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        return this.getStartValue(n2, n3, n);
    }

    public Number getPercentComplete(int n, int n2, int n3) {
        Double d = null;
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        int n4 = taskSeries.getItemCount();
        if (n2 < n4) {
            Task task = taskSeries.get(n2);
            Task task2 = task.getSubtask(n3);
            d = task2.getPercentComplete();
        }
        return d;
    }

    public Number getPercentComplete(Comparable comparable, Comparable comparable2, int n) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        return this.getPercentComplete(n2, n3, n);
    }

    public void seriesChanged(SeriesChangeEvent seriesChangeEvent) {
        this.refreshKeys();
        this.fireDatasetChanged();
    }

    private void refreshKeys() {
        this.keys.clear();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            TaskSeries taskSeries = (TaskSeries)this.data.get(i);
            Iterator iterator = taskSeries.getTasks().iterator();
            while (iterator.hasNext()) {
                Task task = (Task)iterator.next();
                String string = task.getDescription();
                int n = this.keys.indexOf(string);
                if (n >= 0) continue;
                this.keys.add(string);
            }
        }
    }
}

