/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.person.Person;

public abstract class Airlock
implements Serializable {
    private static Logger logger = Logger.getLogger(Airlock.class.getName());
    public static final double CYCLE_TIME = 5.0;
    public static final String PRESSURIZED = "pressurized";
    public static final String DEPRESSURIZED = "depressurized";
    public static final String PRESSURIZING = "pressurizing";
    public static final String DEPRESSURIZING = "depressurizing";
    private String state;
    private boolean activated;
    private boolean innerDoorLocked;
    private boolean outerDoorLocked;
    private int capacity;
    private double remainingCycleTime;
    private Collection<Person> occupants;
    private Person operator;
    private List<Person> awaitingInnerDoor;
    private List<Person> awaitingOuterDoor;

    public Airlock(int capacity) throws IllegalArgumentException {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity less than one.");
        }
        this.capacity = capacity;
        this.activated = false;
        this.state = PRESSURIZED;
        this.innerDoorLocked = false;
        this.outerDoorLocked = true;
        this.remainingCycleTime = 0.0;
        this.occupants = new ConcurrentLinkedQueue<Person>();
        this.operator = null;
        this.awaitingInnerDoor = new ArrayList<Person>();
        this.awaitingOuterDoor = new ArrayList<Person>();
    }

    public boolean enterAirlock(Person person, boolean inside) {
        boolean result = false;
        if (!this.occupants.contains(person) && this.occupants.size() < this.capacity) {
            if (inside && !this.innerDoorLocked) {
                if (this.awaitingInnerDoor.contains(person)) {
                    this.awaitingInnerDoor.remove(person);
                }
                logger.fine(person.getName() + " enters inner door of " + this.getEntityName() + " airlock.");
                result = true;
            } else if (!inside && !this.outerDoorLocked) {
                if (this.awaitingOuterDoor.contains(person)) {
                    this.awaitingOuterDoor.remove(person);
                }
                logger.fine(person.getName() + " enters outer door of " + this.getEntityName() + " airlock.");
                result = true;
            }
            if (result) {
                this.occupants.add(person);
            }
        }
        return result;
    }

    public boolean activateAirlock(Person operator) {
        boolean result = false;
        if (!this.activated) {
            if (!this.innerDoorLocked) {
                while (this.occupants.size() < this.capacity && this.awaitingInnerDoor.size() > 0) {
                    Person person = this.awaitingInnerDoor.get(0);
                    this.awaitingInnerDoor.remove(person);
                    if (this.occupants.contains(person)) continue;
                    logger.fine(person.getName() + " enters inner door of " + this.getEntityName() + " airlock.");
                    this.occupants.add(person);
                }
                this.innerDoorLocked = true;
            } else if (!this.outerDoorLocked) {
                while (this.occupants.size() < this.capacity && this.awaitingOuterDoor.size() > 0) {
                    Person person = this.awaitingOuterDoor.get(0);
                    this.awaitingOuterDoor.remove(person);
                    if (this.occupants.contains(person)) continue;
                    logger.fine(person.getName() + " enters outer door of " + this.getEntityName() + " airlock.");
                    this.occupants.add(person);
                }
                this.outerDoorLocked = true;
            } else {
                return false;
            }
            this.activated = true;
            this.remainingCycleTime = 5.0;
            if (PRESSURIZED.equals(this.state)) {
                this.setState(DEPRESSURIZING);
            } else if (DEPRESSURIZED.equals(this.state)) {
                this.setState(PRESSURIZING);
            } else {
                logger.severe("Airlock in incorrect state for activation: " + this.state);
                return false;
            }
            this.operator = operator;
            result = true;
        }
        return result;
    }

    public boolean addCycleTime(double time) {
        boolean result = false;
        if (this.activated) {
            this.remainingCycleTime -= time;
            if (this.remainingCycleTime <= 0.0) {
                this.remainingCycleTime = 0.0;
                result = this.deactivateAirlock();
            } else {
                result = true;
            }
        }
        return result;
    }

    private boolean deactivateAirlock() {
        boolean result = false;
        if (this.activated) {
            this.activated = false;
            if (DEPRESSURIZING.equals(this.state)) {
                this.setState(DEPRESSURIZED);
                this.outerDoorLocked = false;
            } else if (PRESSURIZING.equals(this.state)) {
                this.setState(PRESSURIZED);
                this.innerDoorLocked = false;
            } else {
                return false;
            }
            Iterator<Person> i = this.occupants.iterator();
            while (i.hasNext()) {
                try {
                    this.exitAirlock(i.next());
                }
                catch (Exception e) {
                    logger.severe(e.getMessage());
                }
            }
            this.occupants.clear();
            this.operator = null;
            result = true;
        }
        return result;
    }

    protected abstract void exitAirlock(Person var1) throws Exception;

    public boolean isOuterDoorLocked() {
        return this.outerDoorLocked;
    }

    public boolean isInnerDoorLocked() {
        return this.innerDoorLocked;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public String getState() {
        return this.state;
    }

    private void setState(String state) {
        this.state = state;
        logger.fine(this.getEntityName() + " airlock is " + state);
    }

    public Person getOperator() {
        return this.operator;
    }

    public void clearOperator() {
        this.operator = null;
    }

    public double getRemainingCycleTime() {
        return this.remainingCycleTime;
    }

    public void addAwaitingAirlockInnerDoor(Person person) {
        if (!this.awaitingInnerDoor.contains(person)) {
            logger.fine(person.getName() + " awaiting inner door of " + this.getEntityName() + " airlock.");
            this.awaitingInnerDoor.add(person);
        }
    }

    public void addAwaitingAirlockOuterDoor(Person person) {
        if (!this.awaitingOuterDoor.contains(person)) {
            logger.fine(person.getName() + " awaiting outer door of " + this.getEntityName() + " airlock.");
            this.awaitingOuterDoor.add(person);
        }
    }

    public void timePassing(double time) {
        if (this.activated) {
            if (this.operator != null) {
                if (this.operator.getPhysicalCondition().isDead()) {
                    String operatorName = this.operator.getName();
                    this.deactivateAirlock();
                    logger.severe("Airlock operator " + operatorName + " is dead.  Deactivating airlock of " + this.getEntityName());
                }
            } else {
                this.deactivateAirlock();
                logger.severe("Airlock has no operator.  Deactivating airlock of " + this.getEntityName());
            }
        }
    }

    public boolean inAirlock(Person person) {
        return this.occupants.contains(person);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public abstract String getEntityName();

    public abstract Inventory getEntityInventory();

    public abstract Object getEntity();

    public void destroy() {
        this.occupants.clear();
        this.occupants = null;
        this.awaitingInnerDoor.clear();
        this.awaitingInnerDoor = null;
        this.awaitingOuterDoor.clear();
        this.awaitingOuterDoor = null;
        this.operator = null;
    }
}

