/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.LocalBoundedObject;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class LocalAreaUtil {
    private static final double INNER_BOUNDARY_DISTANCE = 1.5;

    private LocalAreaUtil() {
    }

    public static Point2D.Double getLocalRelativeLocation(double xLoc, double yLoc, LocalBoundedObject boundedObject) {
        Point2D.Double result = new Point2D.Double();
        double radianRotation = boundedObject.getFacing() * (Math.PI / 180);
        double rotateX = xLoc * Math.cos(radianRotation) - yLoc * Math.sin(radianRotation);
        double rotateY = xLoc * Math.sin(radianRotation) + yLoc * Math.cos(radianRotation);
        double translateX = rotateX + boundedObject.getXLocation();
        double translateY = rotateY + boundedObject.getYLocation();
        result.setLocation(translateX, translateY);
        return result;
    }

    public static Point2D.Double getRandomInteriorLocation(LocalBoundedObject boundedObject) {
        Point2D.Double result = new Point2D.Double(0.0, 0.0);
        double xRange = boundedObject.getWidth() - 3.0;
        result.x = xRange > 0.0 ? RandomUtil.getRandomDouble(xRange) - xRange / 2.0 : 0.0;
        double yRange = boundedObject.getLength() - 3.0;
        result.y = yRange > 0.0 ? RandomUtil.getRandomDouble(yRange) - yRange / 2.0 : 0.0;
        return result;
    }

    public static Point2D.Double getRandomExteriorLocation(LocalBoundedObject boundedObject, double distance) {
        Point2D.Double result = new Point2D.Double(0.0, 0.0);
        int side = RandomUtil.getRandomInt(3);
        switch (side) {
            case 0: {
                result.x = RandomUtil.getRandomDouble(boundedObject.getWidth() + distance * 2.0) - (boundedObject.getWidth() / 2.0 + distance);
                result.y = boundedObject.getLength() / 2.0 + distance;
                break;
            }
            case 1: {
                result.x = RandomUtil.getRandomDouble(boundedObject.getWidth() + distance * 2.0) - (boundedObject.getWidth() + distance);
                result.y = boundedObject.getLength() / -2.0 - distance;
                break;
            }
            case 2: {
                result.x = boundedObject.getWidth() / 2.0 + distance;
                result.y = RandomUtil.getRandomDouble(boundedObject.getLength() + distance * 2.0) - (boundedObject.getLength() / 2.0 + distance);
                break;
            }
            case 3: {
                result.x = boundedObject.getWidth() / -2.0 - distance;
                result.y = RandomUtil.getRandomDouble(boundedObject.getLength() + distance * 2.0) - (boundedObject.getLength() / 2.0 + distance);
            }
        }
        return result;
    }

    public static boolean checkLocationCollision(double xLoc, double yLoc, Coordinates coordinates) {
        boolean result = true;
        Iterator<Vehicle> i = Simulation.instance().getUnitManager().getVehicles().iterator();
        while (i.hasNext() && result) {
            Rectangle2D.Double vehicleRect;
            Path2D vehiclePath;
            Area area;
            Vehicle vehicle = i.next();
            if (!vehicle.getCoordinates().equals(coordinates) || !(area = new Area(vehiclePath = LocalAreaUtil.getPathFromRectangleRotation(vehicleRect = new Rectangle2D.Double(vehicle.getXLocation() - vehicle.getWidth() / 2.0, vehicle.getYLocation() - vehicle.getLength() / 2.0, vehicle.getWidth(), vehicle.getLength()), vehicle.getFacing()))).contains(xLoc, yLoc)) continue;
            result = false;
        }
        Iterator<Settlement> l = Simulation.instance().getUnitManager().getSettlements().iterator();
        while (l.hasNext() && result) {
            Settlement settlement = l.next();
            if (!settlement.getCoordinates().equals(coordinates)) continue;
            Iterator<Building> j = settlement.getBuildingManager().getBuildings().iterator();
            while (j.hasNext() && result) {
                Building building = j.next();
                Rectangle2D.Double buildingRect = new Rectangle2D.Double(building.getXLocation() - building.getWidth() / 2.0, building.getYLocation() - building.getLength() / 2.0, building.getWidth(), building.getLength());
                Path2D buildingPath = LocalAreaUtil.getPathFromRectangleRotation(buildingRect, building.getFacing());
                Area area = new Area(buildingPath);
                if (!area.contains(xLoc, yLoc)) continue;
                result = false;
            }
            Iterator<ConstructionSite> k = settlement.getConstructionManager().getConstructionSites().iterator();
            while (k.hasNext() && result) {
                ConstructionSite site = k.next();
                Rectangle2D.Double siteRect = new Rectangle2D.Double(site.getXLocation() - site.getWidth() / 2.0, site.getYLocation() - site.getLength() / 2.0, site.getWidth(), site.getLength());
                Path2D sitePath = LocalAreaUtil.getPathFromRectangleRotation(siteRect, site.getFacing());
                Area area = new Area(sitePath);
                if (!area.contains(xLoc, yLoc)) continue;
                result = false;
            }
        }
        return result;
    }

    public static boolean checkBoundedObjectNewLocationCollision(LocalBoundedObject boundedObject, double newXLoc, double newYLoc, double newFacing, Settlement settlement) {
        boolean result = true;
        Rectangle2D.Double newObjectRect = new Rectangle2D.Double(newXLoc - boundedObject.getWidth() / 2.0, newYLoc - boundedObject.getLength() / 2.0, boundedObject.getWidth(), boundedObject.getLength());
        Path2D newObjectPath = LocalAreaUtil.getPathFromRectangleRotation(newObjectRect, newFacing);
        Iterator<Vehicle> i = settlement.getParkedVehicles().iterator();
        while (i.hasNext() && result) {
            Vehicle vehicle = i.next();
            if (vehicle == boundedObject) continue;
            Rectangle2D.Double tempVehicleRect = new Rectangle2D.Double(vehicle.getXLocation() - vehicle.getWidth() / 2.0, vehicle.getYLocation() - vehicle.getLength() / 2.0, vehicle.getWidth(), vehicle.getLength());
            Path2D tempVehiclePath = LocalAreaUtil.getPathFromRectangleRotation(tempVehicleRect, vehicle.getFacing());
            Area area = new Area(newObjectPath);
            area.intersect(new Area(tempVehiclePath));
            if (area.isEmpty()) continue;
            result = false;
        }
        Iterator<Building> j = settlement.getBuildingManager().getBuildings().iterator();
        while (j.hasNext() && result) {
            Building building = j.next();
            if (building == boundedObject) continue;
            Rectangle2D.Double buildingRect = new Rectangle2D.Double(building.getXLocation() - building.getWidth() / 2.0, building.getYLocation() - building.getLength() / 2.0, building.getWidth(), building.getLength());
            Path2D buildingPath = LocalAreaUtil.getPathFromRectangleRotation(buildingRect, building.getFacing());
            Area area = new Area(newObjectPath);
            area.intersect(new Area(buildingPath));
            if (area.isEmpty()) continue;
            result = false;
        }
        Iterator<ConstructionSite> k = settlement.getConstructionManager().getConstructionSites().iterator();
        while (k.hasNext() && result) {
            ConstructionSite site = k.next();
            if (site == boundedObject) continue;
            Rectangle2D.Double siteRect = new Rectangle2D.Double(site.getXLocation() - site.getWidth() / 2.0, site.getYLocation() - site.getLength() / 2.0, site.getWidth(), site.getLength());
            Path2D sitePath = LocalAreaUtil.getPathFromRectangleRotation(siteRect, site.getFacing());
            Area area = new Area(newObjectPath);
            area.intersect(new Area(sitePath));
            if (area.isEmpty()) continue;
            result = false;
        }
        return result;
    }

    private static Path2D getPathFromRectangleRotation(Rectangle2D rectangle, double rotation) {
        double radianRotation = rotation * (Math.PI / 180);
        AffineTransform at = AffineTransform.getRotateInstance(radianRotation, rectangle.getCenterX(), rectangle.getCenterY());
        return new Path2D.Double(rectangle, at);
    }
}

