/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.equipment;

import java.io.Serializable;
import java.util.Collection;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.LifeSupport;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.resource.AmountResource;

public class EVASuit
extends Equipment
implements LifeSupport,
Serializable,
Malfunctionable {
    private static Logger logger = Logger.getLogger(EVASuit.class.getName());
    public static final String TYPE = "EVA Suit";
    public static final double EMPTY_MASS = 45.0;
    private static final double OXYGEN_CAPACITY = 1.0;
    private static final double WATER_CAPACITY = 4.0;
    private static final double NORMAL_AIR_PRESSURE = 1.0;
    private static final double NORMAL_TEMP = 25.0;
    private static final double WEAR_LIFETIME = 334000.0;
    private static final double MAINTENANCE_TIME = 100.0;
    protected MalfunctionManager malfunctionManager = new MalfunctionManager(this, 334000.0, 100.0);

    public EVASuit(Coordinates location) {
        super(TYPE, location);
        this.malfunctionManager.addScopeString(TYPE);
        this.malfunctionManager.addScopeString("Life Support");
        this.malfunctionManager.setMaintenanceWorkTime(500.0);
        this.setBaseMass(45.0);
        this.getInventory().addAmountResourceTypeCapacity(AmountResource.findAmountResource("oxygen"), 1.0);
        this.getInventory().addAmountResourceTypeCapacity(AmountResource.findAmountResource("water"), 4.0);
    }

    @Override
    public MalfunctionManager getMalfunctionManager() {
        return this.malfunctionManager;
    }

    @Override
    public boolean lifeSupportCheck() {
        boolean result = true;
        if (this.getInventory().getAmountResourceStored(AmountResource.findAmountResource("oxygen"), false) <= 0.0) {
            logger.info("bad oxygen");
            result = false;
        }
        if (this.getInventory().getAmountResourceStored(AmountResource.findAmountResource("water"), false) <= 0.0) {
            logger.info("bad water");
            result = false;
        }
        if (this.malfunctionManager.getOxygenFlowModifier() < 100.0) {
            logger.info("bad oxygen flow");
            result = false;
        }
        if (this.malfunctionManager.getWaterFlowModifier() < 100.0) {
            logger.info("bad water flow");
            result = false;
        }
        if (this.getAirPressure() != 1.0) {
            logger.info("bad air pressure - " + this.getAirPressure());
            result = false;
        }
        if (this.getTemperature() != 25.0) {
            logger.info("bad temperature - " + this.getTemperature());
            result = false;
        }
        return result;
    }

    @Override
    public int getLifeSupportCapacity() {
        return 1;
    }

    @Override
    public double provideOxygen(double amountRequested) {
        double oxygenTaken = amountRequested;
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenLeft = this.getInventory().getAmountResourceStored(oxygen, false);
        if (oxygenTaken > oxygenLeft) {
            oxygenTaken = oxygenLeft;
        }
        this.getInventory().retrieveAmountResource(oxygen, oxygenTaken);
        return oxygenTaken * (this.malfunctionManager.getOxygenFlowModifier() / 100.0);
    }

    @Override
    public double provideWater(double amountRequested) {
        double waterTaken = amountRequested;
        AmountResource water = AmountResource.findAmountResource("water");
        double waterLeft = this.getInventory().getAmountResourceStored(water, false);
        if (waterTaken > waterLeft) {
            waterTaken = waterLeft;
        }
        this.getInventory().retrieveAmountResource(water, waterTaken);
        return waterTaken * (this.malfunctionManager.getWaterFlowModifier() / 100.0);
    }

    @Override
    public double getAirPressure() {
        double ambient;
        double result = 1.0 * (this.malfunctionManager.getAirPressureModifier() / 100.0);
        if (result < (ambient = Simulation.instance().getMars().getWeather().getAirPressure(this.getCoordinates()))) {
            return ambient;
        }
        return result;
    }

    @Override
    public double getTemperature() {
        double ambient;
        double result = 25.0 * (this.malfunctionManager.getTemperatureModifier() / 100.0);
        if (result < (ambient = Simulation.instance().getMars().getWeather().getTemperature(this.getCoordinates()))) {
            return ambient;
        }
        return result;
    }

    public boolean isFullyLoaded() {
        boolean result = true;
        AmountResource oxygenResource = AmountResource.findAmountResource("oxygen");
        double oxygen = this.getInventory().getAmountResourceStored(oxygenResource, false);
        if (oxygen != 1.0) {
            result = false;
        }
        AmountResource waterResource = AmountResource.findAmountResource("water");
        double water = this.getInventory().getAmountResourceStored(waterResource, false);
        if (water != 4.0) {
            result = false;
        }
        return result;
    }

    @Override
    public void timePassing(double time) {
        Person person;
        Unit container = this.getContainerUnit();
        if (container instanceof Person && !(person = (Person)container).getPhysicalCondition().isDead()) {
            this.malfunctionManager.activeTimePassing(time);
        }
        this.malfunctionManager.timePassing(time);
    }

    @Override
    public Collection<Person> getAffectedPeople() {
        Collection<Person> people = super.getAffectedPeople();
        if (this.getContainerUnit() instanceof Person && !people.contains(this.getContainerUnit())) {
            people.add((Person)this.getContainerUnit());
        }
        return people;
    }
}

