/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.equipment;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.equipment.Bag;
import org.mars_sim.msp.core.equipment.Barrel;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.equipment.GasCanister;
import org.mars_sim.msp.core.equipment.LargeBag;
import org.mars_sim.msp.core.equipment.SpecimenContainer;

public final class EquipmentFactory {
    private static final Map<String, Equipment> equipmentTypeCache = new HashMap<String, Equipment>(6);
    private static final Map<Class<? extends Equipment>, Equipment> equipmentClassCache = new HashMap<Class<? extends Equipment>, Equipment>(6);
    private static Set<String> equipmentNamesCache;

    private EquipmentFactory() {
    }

    public static Set<String> getEquipmentNames() {
        if (equipmentNamesCache == null) {
            equipmentNamesCache = new HashSet<String>(6);
            equipmentNamesCache.add("Bag");
            equipmentNamesCache.add("Barrel");
            equipmentNamesCache.add("EVA Suit");
            equipmentNamesCache.add("Gas Canister");
            equipmentNamesCache.add("Large Bag");
            equipmentNamesCache.add("Specimen Box");
        }
        return new HashSet<String>(equipmentNamesCache);
    }

    public static Equipment getEquipment(String type, Coordinates location, boolean temp) {
        if (temp) {
            if (equipmentTypeCache.containsKey(type)) {
                return equipmentTypeCache.get(type);
            }
            Equipment equipment = EquipmentFactory.getEquipment(type, location, false);
            equipmentTypeCache.put(type, equipment);
            return equipment;
        }
        if ("Bag".equalsIgnoreCase(type)) {
            return new Bag(location);
        }
        if ("Barrel".equalsIgnoreCase(type)) {
            return new Barrel(location);
        }
        if ("EVA Suit".equalsIgnoreCase(type)) {
            return new EVASuit(location);
        }
        if ("Gas Canister".equalsIgnoreCase(type)) {
            return new GasCanister(location);
        }
        if ("Large Bag".equalsIgnoreCase(type)) {
            return new LargeBag(location);
        }
        if ("Specimen Box".equalsIgnoreCase(type)) {
            return new SpecimenContainer(location);
        }
        throw new IllegalStateException("Equipment: " + type + " could not be constructed.");
    }

    public static Equipment getEquipment(Class<? extends Equipment> equipmentClass, Coordinates location, boolean temp) {
        if (temp) {
            if (equipmentClassCache.containsKey(equipmentClass)) {
                return equipmentClassCache.get(equipmentClass);
            }
            Equipment equipment = EquipmentFactory.getEquipment(equipmentClass, location, false);
            equipmentClassCache.put(equipmentClass, equipment);
            return equipment;
        }
        if (Bag.class.equals(equipmentClass)) {
            return new Bag(location);
        }
        if (Barrel.class.equals(equipmentClass)) {
            return new Barrel(location);
        }
        if (EVASuit.class.equals(equipmentClass)) {
            return new EVASuit(location);
        }
        if (GasCanister.class.equals(equipmentClass)) {
            return new GasCanister(location);
        }
        if (LargeBag.class.equals(equipmentClass)) {
            return new LargeBag(location);
        }
        if (SpecimenContainer.class.equals(equipmentClass)) {
            return new SpecimenContainer(location);
        }
        throw new IllegalStateException("Equipment: " + equipmentClass + " could not be constructed.");
    }

    public static Class<? extends Equipment> getEquipmentClass(String type) {
        if ("Bag".equalsIgnoreCase(type)) {
            return Bag.class;
        }
        if ("Barrel".equalsIgnoreCase(type)) {
            return Barrel.class;
        }
        if ("EVA Suit".equalsIgnoreCase(type)) {
            return EVASuit.class;
        }
        if ("Gas Canister".equalsIgnoreCase(type)) {
            return GasCanister.class;
        }
        if ("Large Bag".equalsIgnoreCase(type)) {
            return LargeBag.class;
        }
        if ("Specimen Box".equalsIgnoreCase(type)) {
            return SpecimenContainer.class;
        }
        throw new IllegalStateException("Class for equipment: " + type + " could not be found.");
    }

    public static double getEquipmentMass(String type) {
        if ("Bag".equalsIgnoreCase(type)) {
            return 0.1;
        }
        if ("Barrel".equalsIgnoreCase(type)) {
            return 10.0;
        }
        if ("EVA Suit".equalsIgnoreCase(type)) {
            return 45.0;
        }
        if ("Gas Canister".equalsIgnoreCase(type)) {
            return 20.0;
        }
        if ("Large Bag".equalsIgnoreCase(type)) {
            return 0.4;
        }
        if ("Specimen Box".equalsIgnoreCase(type)) {
            return 0.5;
        }
        throw new IllegalStateException("Class for equipment: " + type + " could not be found.");
    }
}

