/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.events;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.events.HistoricalEvent;
import org.mars_sim.msp.core.events.HistoricalEventListener;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.time.MasterClock;

public class HistoricalEventManager {
    private static final int TRANSIENT_EVENTS = 1000;
    public static final String MEDICAL = "Medical";
    public static final String MALFUNCTION = "Malfunction";
    public static final String MISSION = "Mission";
    public static final String TASK = "Task";
    public static final String TRANSPORT = "Transport";
    private List<HistoricalEventListener> listeners = new ArrayList<HistoricalEventListener>();
    private List<HistoricalEvent> events = new LinkedList<HistoricalEvent>();
    private MarsClock mainClock = null;

    public void addListener(HistoricalEventListener newListener) {
        if (!this.listeners.contains(newListener)) {
            this.listeners.add(newListener);
        }
    }

    public void removeListener(HistoricalEventListener oldListener) {
        if (this.listeners.contains(oldListener)) {
            this.listeners.remove(oldListener);
        }
    }

    public HistoricalEvent getEvent(int index) {
        return this.events.get(index);
    }

    public void registerNewEvent(HistoricalEvent newEvent) {
        MasterClock masterClock;
        if (this.events.size() >= 1000) {
            int excess = this.events.size() - 999;
            this.removeEvents(this.events.size() - excess, excess);
        }
        if ((masterClock = Simulation.instance().getMasterClock()) != null) {
            if (this.mainClock == null) {
                this.mainClock = masterClock.getMarsClock();
            }
            newEvent.setTimestamp((MarsClock)this.mainClock.clone());
        }
        this.events.add(0, newEvent);
        Iterator<HistoricalEventListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().eventAdded(0, newEvent);
        }
    }

    private void removeEvents(int index, int number) {
        for (int i = index; i < index + number; ++i) {
            this.events.remove(i);
        }
        Iterator<HistoricalEventListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().eventsRemoved(index, index + number);
        }
    }

    public int size() {
        return this.events.size();
    }

    public void destroy() {
        this.listeners.clear();
        this.listeners = null;
        this.events.clear();
        this.events = null;
        this.mainClock = null;
    }
}

