/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.interplanetary.transport.resupply;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.interplanetary.transport.TransportEvent;
import org.mars_sim.msp.core.interplanetary.transport.Transportable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.BuildingTemplate;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;

public class Resupply
implements Serializable,
Transportable {
    private static Logger logger = Logger.getLogger(Resupply.class.getName());
    private Settlement settlement;
    private String state;
    private MarsClock launchDate;
    private MarsClock arrivalDate;
    private List<String> newBuildings;
    private List<String> newVehicles;
    private Map<String, Integer> newEquipment;
    private int newImmigrantNum;
    private Map<AmountResource, Double> newResources;
    private Map<Part, Integer> newParts;

    public Resupply(MarsClock arrivalDate, Settlement settlement) {
        this.arrivalDate = arrivalDate;
        this.settlement = settlement;
    }

    @Override
    public MarsClock getLaunchDate() {
        return (MarsClock)this.launchDate.clone();
    }

    public void setLaunchDate(MarsClock launchDate) {
        this.launchDate = (MarsClock)launchDate.clone();
    }

    public List<String> getNewBuildings() {
        return this.newBuildings;
    }

    public void setNewBuildings(List<String> newBuildings) {
        this.newBuildings = newBuildings;
    }

    public List<String> getNewVehicles() {
        return this.newVehicles;
    }

    public void setNewVehicles(List<String> newVehicles) {
        this.newVehicles = newVehicles;
    }

    public Map<String, Integer> getNewEquipment() {
        return this.newEquipment;
    }

    public void setNewEquipment(Map<String, Integer> newEquipment) {
        this.newEquipment = newEquipment;
    }

    public int getNewImmigrantNum() {
        return this.newImmigrantNum;
    }

    public void setNewImmigrantNum(int newImmigrantNum) {
        this.newImmigrantNum = newImmigrantNum;
    }

    public Map<AmountResource, Double> getNewResources() {
        return this.newResources;
    }

    public void setNewResources(Map<AmountResource, Double> newResources) {
        this.newResources = newResources;
    }

    public Map<Part, Integer> getNewParts() {
        return this.newParts;
    }

    public void setNewParts(Map<Part, Integer> newParts) {
        this.newParts = newParts;
    }

    @Override
    public MarsClock getArrivalDate() {
        return (MarsClock)this.arrivalDate.clone();
    }

    public void setArrivalDate(MarsClock arrivalDate) {
        this.arrivalDate = (MarsClock)arrivalDate.clone();
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    public void setSettlement(Settlement settlement) {
        this.settlement = settlement;
    }

    public void commitModification() {
        TransportEvent newEvent = new TransportEvent(this, "Transport Item Modified", "Resupply mission modified");
        Simulation.instance().getEventManager().registerNewEvent(newEvent);
    }

    @Override
    public void destroy() {
        this.settlement = null;
        this.launchDate = null;
        this.arrivalDate = null;
        this.newBuildings.clear();
        this.newBuildings = null;
        this.newVehicles.clear();
        this.newVehicles = null;
        this.newEquipment.clear();
        this.newEquipment = null;
        this.newResources.clear();
        this.newResources = null;
        this.newParts.clear();
        this.newParts = null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getSettlement().getName());
        buff.append(": ");
        buff.append(this.getArrivalDate().getDateString());
        return buff.toString();
    }

    @Override
    public int compareTo(Transportable o) {
        int result = 0;
        double arrivalTimeDiff = MarsClock.getTimeDiff(this.arrivalDate, o.getArrivalDate());
        result = arrivalTimeDiff < 0.0 ? -1 : (arrivalTimeDiff > 0.0 ? 1 : this.getName().compareTo(o.getName()));
        return result;
    }

    @Override
    public String getName() {
        return this.getSettlement().getName();
    }

    @Override
    public String getTransitState() {
        return this.state;
    }

    @Override
    public void setTransitState(String transitState) {
        this.state = transitState;
    }

    @Override
    public void performArrival() {
        this.deliverSupplies();
    }

    private void deliverSupplies() {
        BuildingManager buildingManager = this.settlement.getBuildingManager();
        for (String type : this.getNewBuildings()) {
            BuildingTemplate positionedTemplate = this.positionNewResupplyBuilding(type);
            buildingManager.addBuilding(positionedTemplate);
        }
        UnitManager unitManager = Simulation.instance().getUnitManager();
        for (String vehicleType : this.getNewVehicles()) {
            String name;
            GroundVehicle vehicle = null;
            if ("Light Utility Vehicle".equals(vehicleType)) {
                name = unitManager.getNewName("vehicle", "LUV", null);
                vehicle = new LightUtilityVehicle(name, vehicleType, this.settlement);
            } else {
                name = unitManager.getNewName("vehicle", null, null);
                vehicle = new Rover(name, vehicleType, this.settlement);
            }
            unitManager.addUnit(vehicle);
        }
        Inventory inv = this.settlement.getInventory();
        for (String equipmentType : this.getNewEquipment().keySet()) {
            int number = this.getNewEquipment().get(equipmentType);
            for (int x = 0; x < number; ++x) {
                Equipment equipment = EquipmentFactory.getEquipment(equipmentType, this.settlement.getCoordinates(), false);
                equipment.setName(unitManager.getNewName("equipment", equipmentType, null));
                inv.storeUnit(equipment);
            }
        }
        for (AmountResource resource : this.getNewResources().keySet()) {
            double capacity;
            double amount = this.getNewResources().get(resource);
            if (amount > (capacity = inv.getAmountResourceRemainingCapacity(resource, true, false))) {
                amount = capacity;
            }
            inv.storeAmountResource(resource, amount, true);
        }
        for (Part part : this.getNewParts().keySet()) {
            int number = this.getNewParts().get(part);
            inv.storeItemResources(part, number);
        }
        ConcurrentLinkedQueue<Person> immigrants = new ConcurrentLinkedQueue<Person>();
        RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
        for (int x = 0; x < this.getNewImmigrantNum(); ++x) {
            PersonConfig personConfig = SimulationConfig.instance().getPersonConfiguration();
            String gender = "female";
            if (RandomUtil.getRandomDouble(1.0) <= personConfig.getGenderRatio()) {
                gender = "male";
            }
            String immigrantName = unitManager.getNewName("person", null, gender);
            Person immigrant = new Person(immigrantName, gender, this.settlement);
            unitManager.addUnit(immigrant);
            relationshipManager.addNewImmigrant(immigrant, immigrants);
            immigrants.add(immigrant);
            logger.info(immigrantName + " arrives on Mars at " + this.settlement.getName());
        }
    }

    private BuildingTemplate positionNewResupplyBuilding(String buildingType) {
        Building building;
        BuildingTemplate newPosition = null;
        boolean hasLifeSupport = SimulationConfig.instance().getBuildingConfiguration().hasLifeSupport(buildingType);
        if (hasLifeSupport) {
            List<Building> inhabitableBuildings = this.settlement.getBuildingManager().getBuildings("Life Support");
            Collections.shuffle(inhabitableBuildings);
            Iterator<Building> i = inhabitableBuildings.iterator();
            while (i.hasNext() && (newPosition = this.positionNextToBuilding(buildingType, building = i.next(), 0.0)) == null) {
            }
        } else {
            List<Building> sameBuildings = this.settlement.getBuildingManager().getBuildingsOfName(buildingType);
            Collections.shuffle(sameBuildings);
            Iterator<Building> j = sameBuildings.iterator();
            while (j.hasNext() && (newPosition = this.positionNextToBuilding(buildingType, building = j.next(), 0.0)) == null) {
            }
        }
        if (newPosition == null) {
            BuildingManager buildingManager = this.settlement.getBuildingManager();
            if (buildingManager.getBuildingNum() > 0) {
                int x = 10;
                while (newPosition == null) {
                    Building building2;
                    List<Building> allBuildings = buildingManager.getBuildings();
                    Collections.shuffle(allBuildings);
                    Iterator<Building> i = allBuildings.iterator();
                    while (i.hasNext() && (newPosition = this.positionNextToBuilding(buildingType, building2 = i.next(), x)) == null) {
                    }
                    x += 10;
                }
            } else {
                newPosition = new BuildingTemplate(buildingType, 0.0, 0.0, RandomUtil.getRandomDouble(360.0));
            }
        }
        return newPosition;
    }

    private BuildingTemplate positionNextToBuilding(String newBuildingType, Building building, double separationDistance) {
        BuildingTemplate newPosition = null;
        double width = SimulationConfig.instance().getBuildingConfiguration().getWidth(newBuildingType);
        double length = SimulationConfig.instance().getBuildingConfiguration().getLength(newBuildingType);
        boolean front = false;
        boolean back = true;
        int right = 2;
        int left = 3;
        ArrayList<Integer> directions = new ArrayList<Integer>(4);
        directions.add(0);
        directions.add(1);
        directions.add(2);
        directions.add(3);
        Collections.shuffle(directions);
        double direction = 0.0;
        double structureDistance = 0.0;
        for (int x = 0; x < directions.size(); ++x) {
            switch ((Integer)directions.get(x)) {
                case 0: {
                    direction = building.getFacing();
                    structureDistance = building.getLength() / 2.0 + length / 2.0;
                    break;
                }
                case 1: {
                    direction = building.getFacing() + 180.0;
                    structureDistance = building.getLength() / 2.0 + length / 2.0;
                    break;
                }
                case 2: {
                    direction = building.getFacing() + 90.0;
                    structureDistance = building.getWidth() / 2.0 + width / 2.0;
                    break;
                }
                case 3: {
                    direction = building.getFacing() + 270.0;
                    structureDistance = building.getWidth() / 2.0 + width / 2.0;
                }
            }
            double distance = structureDistance + separationDistance;
            double radianDirection = Math.PI * direction / 180.0;
            double rectCenterX = building.getXLocation() - distance * Math.sin(radianDirection);
            double rectCenterY = building.getYLocation() + distance * Math.cos(radianDirection);
            double rectRotation = building.getFacing();
            if (!this.settlement.getBuildingManager().checkIfNewBuildingLocationOpen(rectCenterX, rectCenterY, width, length, rectRotation)) continue;
            newPosition = new BuildingTemplate(newBuildingType, rectCenterX, rectCenterY, building.getFacing());
            break;
        }
        return newPosition;
    }
}

