/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.interplanetary.transport.settlement;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.interplanetary.transport.TransportEvent;
import org.mars_sim.msp.core.interplanetary.transport.Transportable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.SettlementTemplate;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;

public class ArrivingSettlement
implements Transportable,
Serializable {
    private static Logger logger = Logger.getLogger(ArrivingSettlement.class.getName());
    private String name;
    private String template;
    private String transitState;
    private MarsClock launchDate;
    private MarsClock arrivalDate;
    private Coordinates landingLocation;
    private int populationNum;

    public ArrivingSettlement(String name, String template, MarsClock arrivalDate, Coordinates landingLocation, int populationNum) {
        this.name = name;
        this.template = template;
        this.arrivalDate = arrivalDate;
        this.landingLocation = landingLocation;
        this.populationNum = populationNum;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    public String getTransitState() {
        return this.transitState;
    }

    @Override
    public void setTransitState(String transitState) {
        this.transitState = transitState;
    }

    @Override
    public MarsClock getLaunchDate() {
        return this.launchDate;
    }

    public void setLaunchDate(MarsClock launchDate) {
        this.launchDate = launchDate;
    }

    @Override
    public MarsClock getArrivalDate() {
        return this.arrivalDate;
    }

    public void setArrivalDate(MarsClock arrivalDate) {
        this.arrivalDate = arrivalDate;
    }

    public Coordinates getLandingLocation() {
        return this.landingLocation;
    }

    public void setLandingLocation(Coordinates landingLocation) {
        this.landingLocation = landingLocation;
    }

    public int getPopulationNum() {
        return this.populationNum;
    }

    public void setPopulationNum(int populationNum) {
        this.populationNum = populationNum;
    }

    public void commitModification() {
        TransportEvent newEvent = new TransportEvent(this, "Transport Item Modified", "Arriving settlement modified");
        Simulation.instance().getEventManager().registerNewEvent(newEvent);
    }

    @Override
    public void destroy() {
        this.name = null;
        this.template = null;
        this.transitState = null;
        this.launchDate = null;
        this.arrivalDate = null;
        this.landingLocation = null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getName());
        buff.append(": ");
        buff.append(this.getArrivalDate().getDateString());
        return buff.toString();
    }

    @Override
    public int compareTo(Transportable o) {
        int result = 0;
        double arrivalTimeDiff = MarsClock.getTimeDiff(this.arrivalDate, o.getArrivalDate());
        result = arrivalTimeDiff < 0.0 ? -1 : (arrivalTimeDiff > 0.0 ? 1 : this.name.compareTo(o.getName()));
        return result;
    }

    @Override
    public void performArrival() {
        Settlement newSettlement = this.createNewSettlement();
        this.createNewImmigrants(newSettlement);
        this.createNewEquipment(newSettlement);
        this.createNewParts(newSettlement);
        this.createNewResources(newSettlement);
        this.createNewVehicles(newSettlement);
    }

    private Settlement createNewSettlement() {
        UnitManager unitManager = Simulation.instance().getUnitManager();
        Settlement newSettlement = new Settlement(this.name, this.template, this.landingLocation, this.populationNum);
        unitManager.addUnit(newSettlement);
        Simulation.instance().getCreditManager().addSettlement(newSettlement);
        return newSettlement;
    }

    private void createNewImmigrants(Settlement newSettlement) {
        ConcurrentLinkedQueue<Person> immigrants = new ConcurrentLinkedQueue<Person>();
        UnitManager unitManager = Simulation.instance().getUnitManager();
        RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
        for (int x = 0; x < this.populationNum; ++x) {
            PersonConfig personConfig = SimulationConfig.instance().getPersonConfiguration();
            String gender = "female";
            if (RandomUtil.getRandomDouble(1.0) <= personConfig.getGenderRatio()) {
                gender = "male";
            }
            String immigrantName = unitManager.getNewName("person", null, gender);
            Person immigrant = new Person(immigrantName, gender, newSettlement);
            unitManager.addUnit(immigrant);
            relationshipManager.addNewImmigrant(immigrant, immigrants);
            immigrants.add(immigrant);
            logger.info(immigrantName + " arrives on Mars at " + newSettlement.getName());
        }
    }

    private void createNewEquipment(Settlement newSettlement) {
        SettlementTemplate template = SimulationConfig.instance().getSettlementConfiguration().getSettlementTemplate(this.getTemplate());
        UnitManager unitManager = Simulation.instance().getUnitManager();
        for (String equipmentType : template.getEquipment().keySet()) {
            int number = template.getEquipment().get(equipmentType);
            for (int x = 0; x < number; ++x) {
                Equipment equipment = EquipmentFactory.getEquipment(equipmentType, newSettlement.getCoordinates(), false);
                equipment.setName(unitManager.getNewName("equipment", equipmentType, null));
                newSettlement.getInventory().storeUnit(equipment);
            }
        }
    }

    private void createNewParts(Settlement newSettlement) {
        SettlementTemplate template = SimulationConfig.instance().getSettlementConfiguration().getSettlementTemplate(this.getTemplate());
        for (Part part : template.getParts().keySet()) {
            int number = template.getParts().get(part);
            newSettlement.getInventory().storeItemResources(part, number);
        }
    }

    private void createNewResources(Settlement newSettlement) {
        SettlementTemplate template = SimulationConfig.instance().getSettlementConfiguration().getSettlementTemplate(this.getTemplate());
        for (AmountResource resource : template.getResources().keySet()) {
            double capacity;
            double amount = template.getResources().get(resource);
            if (amount > (capacity = newSettlement.getInventory().getAmountResourceRemainingCapacity(resource, true, false))) {
                amount = capacity;
            }
            newSettlement.getInventory().storeAmountResource(resource, amount, true);
        }
    }

    private void createNewVehicles(Settlement newSettlement) {
        SettlementTemplate template = SimulationConfig.instance().getSettlementConfiguration().getSettlementTemplate(this.getTemplate());
        UnitManager unitManager = Simulation.instance().getUnitManager();
        for (String vehicleType : template.getVehicles().keySet()) {
            int number = template.getVehicles().get(vehicleType);
            for (int x = 0; x < number; ++x) {
                String name;
                GroundVehicle vehicle = null;
                if ("Light Utility Vehicle".equals(vehicleType)) {
                    name = unitManager.getNewName("vehicle", "LUV", null);
                    vehicle = new LightUtilityVehicle(name, vehicleType, newSettlement);
                } else {
                    name = unitManager.getNewName("vehicle", null, null);
                    vehicle = new Rover(name, vehicleType, newSettlement);
                }
                unitManager.addUnit(vehicle);
            }
        }
    }
}

