/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.malfunction;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.malfunction.MalfunctionConfig;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.vehicle.Vehicle;

public final class MalfunctionFactory
implements Serializable {
    private Collection<Malfunction> malfunctions;

    public MalfunctionFactory(MalfunctionConfig config) {
        this.malfunctions = config.getMalfunctionList();
    }

    public Malfunction getMalfunction(Collection<String> scope) {
        Malfunction result = null;
        double totalProbability = 0.0;
        if (this.malfunctions.size() > 0) {
            for (Malfunction temp : this.malfunctions) {
                if (!temp.unitScopeMatch(scope)) continue;
                totalProbability += temp.getProbability();
            }
        }
        double r = RandomUtil.getRandomDouble(totalProbability);
        for (Malfunction temp : this.malfunctions) {
            double probability = temp.getProbability();
            if (!temp.unitScopeMatch(scope) || result != null) continue;
            if (r < probability) {
                try {
                    result = temp.getClone();
                    result.determineRepairParts();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                continue;
            }
            r -= probability;
        }
        return result;
    }

    public static Collection<Malfunctionable> getMalfunctionables(Person person) {
        Collection<Unit> inventoryUnits;
        ArrayList<Malfunctionable> entities = new ArrayList<Malfunctionable>();
        String location = person.getLocationSituation();
        if (location.equals("In Settlement")) {
            Settlement settlement = person.getSettlement();
            Iterator<Comparable<Building>> i = settlement.getBuildingManager().getBuildings().iterator();
            while (i.hasNext()) {
                entities.add(i.next());
            }
        }
        if (location.equals("In Vehicle")) {
            entities.add(person.getVehicle());
        }
        if (!location.equals("Outside")) {
            for (Unit unit : person.getContainerUnit().getInventory().getContainedUnits()) {
                if (!(unit instanceof Malfunctionable)) continue;
                entities.add((Malfunctionable)((Object)unit));
            }
        }
        if ((inventoryUnits = person.getInventory().getContainedUnits()).size() > 0) {
            for (Unit unit : inventoryUnits) {
                if (!(unit instanceof Malfunctionable)) continue;
                entities.add((Malfunctionable)((Object)unit));
            }
        }
        return entities;
    }

    public static Collection<Malfunctionable> getMalfunctionables(Settlement settlement) {
        ArrayList<Malfunctionable> entities = new ArrayList<Malfunctionable>();
        Iterator<Building> i = settlement.getBuildingManager().getBuildings().iterator();
        while (i.hasNext()) {
            entities.add(i.next());
        }
        Collection<Unit> inventoryUnits = settlement.getInventory().getContainedUnits();
        if (inventoryUnits.size() > 0) {
            for (Unit unit : inventoryUnits) {
                if (!(unit instanceof Malfunctionable)) continue;
                entities.add((Malfunctionable)((Object)unit));
            }
        }
        return entities;
    }

    public static Collection<Malfunctionable> getMalfunctionables(Malfunctionable entity) {
        ArrayList<Malfunctionable> entities = new ArrayList<Malfunctionable>();
        entities.add(entity);
        Collection<Unit> inventoryUnits = entity.getInventory().getContainedUnits();
        if (inventoryUnits.size() > 0) {
            for (Unit unit : inventoryUnits) {
                if (!(unit instanceof Malfunctionable)) continue;
                entities.add((Malfunctionable)((Object)unit));
            }
        }
        return entities;
    }

    public static Collection<Malfunctionable> getAssociatedMalfunctionables(Settlement settlement) {
        Collection<Malfunctionable> entities = MalfunctionFactory.getMalfunctionables(settlement);
        for (Mission mission : Simulation.instance().getMissionManager().getMissionsForSettlement(settlement)) {
            Vehicle vehicle;
            if (!(mission instanceof VehicleMission) || (vehicle = ((VehicleMission)mission).getVehicle()) == null || settlement.equals(vehicle.getSettlement())) continue;
            entities.addAll(MalfunctionFactory.getMalfunctionables(vehicle));
        }
        for (Person person : settlement.getAllAssociatedPeople()) {
            if (!person.getLocationSituation().equals("Outside")) continue;
            entities.addAll(MalfunctionFactory.getMalfunctionables(person));
        }
        return entities;
    }

    Map<Part, Double> getRepairPartProbabilities(Collection<String> scope) {
        HashMap<Part, Double> result = new HashMap<Part, Double>();
        for (Malfunction malfunction : this.malfunctions) {
            String[] partNames;
            if (!malfunction.unitScopeMatch(scope)) continue;
            double malfunctionProbability = malfunction.getProbability() / 100.0;
            MalfunctionConfig config = SimulationConfig.instance().getMalfunctionConfiguration();
            for (String partName : partNames = config.getRepairPartNamesForMalfunction(malfunction.getName())) {
                double partProbability = (double)config.getRepairPartProbability(malfunction.getName(), partName) / 100.0;
                int partNumber = config.getRepairPartNumber(malfunction.getName(), partName);
                double averageNumber = RandomUtil.getRandomRegressionIntegerAverageValue(partNumber);
                double totalNumber = averageNumber * partProbability * malfunctionProbability;
                Part part = (Part)ItemResource.findItemResource(partName);
                if (result.containsKey(part)) {
                    totalNumber += ((Double)result.get(part)).doubleValue();
                }
                result.put(part, totalNumber);
            }
        }
        return result;
    }

    Map<Part, Double> getMaintenancePartProbabilities(Collection<String> scope) {
        HashMap<Part, Double> result = new HashMap<Part, Double>();
        for (String entity : scope) {
            for (Part part : Part.getParts()) {
                if (!part.hasMaintenanceEntity(entity)) continue;
                double prob = (double)part.getMaintenanceProbability(entity) / 100.0;
                int partNumber = part.getMaintenanceMaximumNumber(entity);
                double averageNumber = RandomUtil.getRandomRegressionIntegerAverageValue(partNumber);
                double totalNumber = averageNumber * prob;
                if (result.containsKey(part)) {
                    totalNumber += ((Double)result.get(part)).doubleValue();
                }
                result.put(part, totalNumber);
            }
        }
        return result;
    }

    public void destroy() {
        this.malfunctions = null;
    }
}

