/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.manufacture;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.manufacture.ManufactureConfig;
import org.mars_sim.msp.core.manufacture.ManufactureProcessInfo;
import org.mars_sim.msp.core.manufacture.ManufactureProcessItem;
import org.mars_sim.msp.core.manufacture.PartSalvage;
import org.mars_sim.msp.core.manufacture.SalvageProcessInfo;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.Manufacture;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsManager;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.core.vehicle.VehicleConfig;

public final class ManufactureUtil {
    private ManufactureUtil() {
    }

    public static List<ManufactureProcessInfo> getAllManufactureProcesses() {
        ManufactureConfig config = SimulationConfig.instance().getManufactureConfiguration();
        return new ArrayList<ManufactureProcessInfo>(config.getManufactureProcessList());
    }

    public static List<ManufactureProcessInfo> getManufactureProcessesForTechLevel(int techLevel) {
        ArrayList<ManufactureProcessInfo> result = new ArrayList<ManufactureProcessInfo>();
        ManufactureConfig config = SimulationConfig.instance().getManufactureConfiguration();
        for (ManufactureProcessInfo process : config.getManufactureProcessList()) {
            if (process.getTechLevelRequired() > techLevel) continue;
            result.add(process);
        }
        return result;
    }

    public static List<ManufactureProcessInfo> getManufactureProcessesForTechSkillLevel(int techLevel, int skillLevel) {
        ArrayList<ManufactureProcessInfo> result = new ArrayList<ManufactureProcessInfo>();
        ManufactureConfig config = SimulationConfig.instance().getManufactureConfiguration();
        for (ManufactureProcessInfo process : config.getManufactureProcessList()) {
            if (process.getTechLevelRequired() > techLevel || process.getSkillLevelRequired() > skillLevel) continue;
            result.add(process);
        }
        return result;
    }

    public static List<SalvageProcessInfo> getSalvageProcessesForTechSkillLevel(int techLevel, int skillLevel) {
        ArrayList<SalvageProcessInfo> result = new ArrayList<SalvageProcessInfo>();
        ManufactureConfig config = SimulationConfig.instance().getManufactureConfiguration();
        for (SalvageProcessInfo process : config.getSalvageList()) {
            if (process.getTechLevelRequired() > techLevel || process.getSkillLevelRequired() > skillLevel) continue;
            result.add(process);
        }
        return result;
    }

    public static List<SalvageProcessInfo> getSalvageProcessesForTechLevel(int techLevel) {
        ArrayList<SalvageProcessInfo> result = new ArrayList<SalvageProcessInfo>();
        ManufactureConfig config = SimulationConfig.instance().getManufactureConfiguration();
        for (SalvageProcessInfo process : config.getSalvageList()) {
            if (process.getTechLevelRequired() > techLevel) continue;
            result.add(process);
        }
        return result;
    }

    public static double getManufactureProcessValue(ManufactureProcessInfo process, Settlement settlement) {
        double inputsValue = 0.0;
        Iterator<ManufactureProcessItem> i = process.getInputList().iterator();
        while (i.hasNext()) {
            inputsValue += ManufactureUtil.getManufactureProcessItemValue(i.next(), settlement);
        }
        double outputsValue = 0.0;
        Iterator<ManufactureProcessItem> j = process.getOutputList().iterator();
        while (j.hasNext()) {
            outputsValue += ManufactureUtil.getManufactureProcessItemValue(j.next(), settlement);
        }
        double hoursInMillisol = MarsClock.convertMillisolsToSeconds(1.0) / 60.0 / 60.0;
        double powerHrsRequiredPerMillisol = process.getPowerRequired() * hoursInMillisol;
        double powerValue = powerHrsRequiredPerMillisol * settlement.getPowerGrid().getPowerValue();
        return outputsValue - inputsValue - powerValue;
    }

    public static double getSalvageProcessValue(SalvageProcessInfo process, Settlement settlement, Person salvager) {
        double result = 0.0;
        Unit salvagedUnit = ManufactureUtil.findUnitForSalvage(process, settlement);
        if (salvagedUnit != null) {
            GoodsManager goodsManager = settlement.getGoodsManager();
            double wearConditionModifier = 1.0;
            if (salvagedUnit instanceof Malfunctionable) {
                Malfunctionable salvagedMalfunctionable = (Malfunctionable)((Object)salvagedUnit);
                double wearCondition = salvagedMalfunctionable.getMalfunctionManager().getWearCondition();
                wearConditionModifier = wearCondition / 100.0;
            }
            double salvagedGoodValue = 0.0;
            Good salvagedGood = null;
            if (salvagedUnit instanceof Equipment) {
                salvagedGood = GoodsUtil.getEquipmentGood(salvagedUnit.getClass());
            } else if (salvagedUnit instanceof Vehicle) {
                salvagedGood = GoodsUtil.getVehicleGood(salvagedUnit.getDescription());
            }
            if (salvagedGood == null) {
                throw new IllegalStateException("Salvaged good is null");
            }
            salvagedGoodValue = goodsManager.getGoodValuePerItem(salvagedGood);
            salvagedGoodValue *= wearConditionModifier * 0.75 + 0.25;
            double totalPartsGoodValue = 0.0;
            for (PartSalvage partSalvage : process.getPartSalvageList()) {
                Part part = (Part)ItemResource.findItemResource(partSalvage.getName());
                Good partGood = GoodsUtil.getResourceGood(part);
                double partValue = goodsManager.getGoodValuePerItem(partGood) * (double)partSalvage.getNumber();
                totalPartsGoodValue += partValue;
            }
            int skill = salvager.getMind().getSkillManager().getEffectiveSkillLevel("Materials Science");
            double valueModifier = 0.25 + wearConditionModifier * 0.25 + (double)skill * 0.05;
            result = (totalPartsGoodValue *= valueModifier) - salvagedGoodValue;
        }
        return result;
    }

    public static double getManufactureProcessItemValue(ManufactureProcessItem item, Settlement settlement) {
        double result = 0.0;
        GoodsManager manager = settlement.getGoodsManager();
        if (item.getType().equals("resource")) {
            AmountResource resource = AmountResource.findAmountResource(item.getName());
            Good good = GoodsUtil.getResourceGood(resource);
            result = manager.getGoodValuePerItem(good) * item.getAmount();
        } else if (item.getType().equals("part")) {
            ItemResource resource = ItemResource.findItemResource(item.getName());
            Good good = GoodsUtil.getResourceGood(resource);
            result = manager.getGoodValuePerItem(good) * item.getAmount();
        } else if (item.getType().equals("equipment")) {
            Class<? extends Equipment> equipmentClass = EquipmentFactory.getEquipmentClass(item.getName());
            Good good = GoodsUtil.getEquipmentGood(equipmentClass);
            result = manager.getGoodValuePerItem(good) * item.getAmount();
        } else if (item.getType().equals("vehicle")) {
            Good good = GoodsUtil.getVehicleGood(item.getName());
            result = manager.getGoodValuePerItem(good) * item.getAmount();
        } else {
            throw new IllegalStateException("Item type: " + item.getType() + " not valid.");
        }
        return result;
    }

    public static boolean canProcessBeStarted(ManufactureProcessInfo process, Manufacture workshop) {
        Inventory inv;
        boolean result = true;
        if (workshop.getTotalProcessNumber() >= workshop.getConcurrentProcesses()) {
            result = false;
        }
        if (workshop.getTechLevel() < process.getTechLevelRequired()) {
            result = false;
        }
        if (!ManufactureUtil.areProcessInputsAvailable(process, inv = workshop.getBuilding().getInventory())) {
            result = false;
        }
        return result;
    }

    public static boolean canSalvageProcessBeStarted(SalvageProcessInfo process, Manufacture workshop) {
        Settlement settlement;
        boolean result = true;
        if (workshop.getTotalProcessNumber() >= workshop.getConcurrentProcesses()) {
            result = false;
        }
        if (workshop.getTechLevel() < process.getTechLevelRequired()) {
            result = false;
        }
        if (ManufactureUtil.findUnitForSalvage(process, settlement = workshop.getBuilding().getBuildingManager().getSettlement()) == null) {
            result = false;
        }
        return result;
    }

    private static boolean areProcessInputsAvailable(ManufactureProcessInfo process, Inventory inv) {
        boolean result = true;
        for (ManufactureProcessItem item : process.getInputList()) {
            if ("resource".equalsIgnoreCase(item.getType())) {
                AmountResource resource = AmountResource.findAmountResource(item.getName());
                if (!(inv.getAmountResourceStored(resource, false) < item.getAmount())) continue;
                result = false;
                continue;
            }
            if ("part".equalsIgnoreCase(item.getType())) {
                Part part = (Part)ItemResource.findItemResource(item.getName());
                if (inv.getItemResourceNum(part) >= (int)item.getAmount()) continue;
                result = false;
                continue;
            }
            throw new IllegalStateException("Manufacture process input: " + item.getType() + " not a valid type.");
        }
        return result;
    }

    public static boolean doesSettlementHaveManufacturing(Settlement settlement) {
        BuildingManager manager = settlement.getBuildingManager();
        return manager.getBuildings("Manufacture").size() > 0;
    }

    public static int getHighestManufacturingTechLevel(Settlement settlement) {
        int highestTechLevel = 0;
        BuildingManager manager = settlement.getBuildingManager();
        for (Building building : manager.getBuildings("Manufacture")) {
            Manufacture manufacturingFunction = (Manufacture)building.getFunction("Manufacture");
            if (manufacturingFunction.getTechLevel() <= highestTechLevel) continue;
            highestTechLevel = manufacturingFunction.getTechLevel();
        }
        return highestTechLevel;
    }

    public static Good getGood(ManufactureProcessItem item) {
        Good result = null;
        if ("resource".equalsIgnoreCase(item.getType())) {
            AmountResource resource = AmountResource.findAmountResource(item.getName());
            result = GoodsUtil.getResourceGood(resource);
        } else if ("part".equalsIgnoreCase(item.getType())) {
            Part part = (Part)ItemResource.findItemResource(item.getName());
            result = GoodsUtil.getResourceGood(part);
        } else if ("equipment".equalsIgnoreCase(item.getType())) {
            Class<? extends Equipment> equipmentClass = EquipmentFactory.getEquipmentClass(item.getName());
            result = GoodsUtil.getEquipmentGood(equipmentClass);
        } else if ("vehicle".equalsIgnoreCase(item.getType())) {
            result = GoodsUtil.getVehicleGood(item.getName());
        }
        return result;
    }

    public static double getMass(ManufactureProcessItem item) {
        double mass = 0.0;
        if ("resource".equalsIgnoreCase(item.getType())) {
            mass = item.getAmount();
        } else if ("part".equalsIgnoreCase(item.getType())) {
            Part part = (Part)ItemResource.findItemResource(item.getName());
            mass = item.getAmount() * part.getMassPerItem();
        } else if ("equipment".equalsIgnoreCase(item.getType())) {
            double equipmentMass = EquipmentFactory.getEquipmentMass(item.getName());
            mass = item.getAmount() * equipmentMass;
        } else if ("vehicle".equalsIgnoreCase(item.getType())) {
            VehicleConfig config = SimulationConfig.instance().getVehicleConfiguration();
            mass = item.getAmount() * config.getEmptyMass(item.getName());
        }
        return mass;
    }

    public static Unit findUnitForSalvage(SalvageProcessInfo info, Settlement settlement) {
        Iterator<Object> i;
        Unit result = null;
        Inventory inv = settlement.getInventory();
        Collection<Object> salvagableUnits = new ArrayList(0);
        if (info.getType().equalsIgnoreCase("vehicle")) {
            if ("Light Utility Vehicle".equalsIgnoreCase(info.getItemName())) {
                salvagableUnits = inv.findAllUnitsOfClass(LightUtilityVehicle.class);
            } else {
                salvagableUnits = inv.findAllUnitsOfClass(Rover.class);
                i = salvagableUnits.iterator();
                while (i.hasNext()) {
                    Rover rover = (Rover)i.next();
                    if (rover.getDescription().equalsIgnoreCase(info.getItemName())) continue;
                    i.remove();
                }
            }
            i = salvagableUnits.iterator();
            while (i.hasNext()) {
                Vehicle vehicle = (Vehicle)i.next();
                if (!vehicle.isReserved()) continue;
                i.remove();
            }
        } else if (info.getType().equalsIgnoreCase("equipment")) {
            Class<? extends Equipment> equipmentClass = EquipmentFactory.getEquipmentClass(info.getItemName());
            salvagableUnits = inv.findAllUnitsOfClass(equipmentClass);
        }
        i = salvagableUnits.iterator();
        while (i.hasNext()) {
            if (((Unit)i.next()).getContainerUnit() == settlement) continue;
            i.remove();
        }
        Iterator<Object> j = salvagableUnits.iterator();
        while (j.hasNext()) {
            if (((Unit)j.next()).getInventory().isEmpty(false)) continue;
            j.remove();
        }
        if (salvagableUnits.size() > 0) {
            Unit firstUnit = (Unit)salvagableUnits.toArray()[0];
            if (firstUnit instanceof Malfunctionable) {
                Unit mostWorn = null;
                double lowestWearCondition = Double.MAX_VALUE;
                for (Unit unit : salvagableUnits) {
                    Malfunctionable malfunctionable = (Malfunctionable)((Object)unit);
                    double wearCondition = malfunctionable.getMalfunctionManager().getWearCondition();
                    if (!(wearCondition < lowestWearCondition)) continue;
                    mostWorn = unit;
                    lowestWearCondition = wearCondition;
                }
                result = mostWorn;
            } else {
                result = firstUnit;
            }
        }
        return result;
    }
}

