/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.manufacture;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.manufacture.Salvagable;
import org.mars_sim.msp.core.manufacture.SalvageProcessInfo;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.time.MarsClock;

public class SalvageInfo
implements Serializable {
    private Salvagable item;
    private SalvageProcessInfo processInfo;
    private MarsClock startTime;
    private MarsClock finishTime;
    private Map<Part, Integer> partsSalvaged;
    private Settlement settlement;

    public SalvageInfo(Salvagable item, SalvageProcessInfo processInfo, Settlement settlement) {
        this.item = item;
        this.processInfo = processInfo;
        this.settlement = settlement;
        this.startTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
        this.finishTime = null;
        this.partsSalvaged = new HashMap<Part, Integer>(processInfo.getPartSalvageList().size());
    }

    public void finishSalvage(Map<Part, Integer> partsSalvaged) {
        this.partsSalvaged = partsSalvaged;
        this.finishTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
    }

    public Salvagable getItem() {
        return this.item;
    }

    public SalvageProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    public MarsClock getStartTime() {
        return this.startTime;
    }

    public MarsClock getFinishTime() {
        return this.finishTime;
    }

    public Map<Part, Integer> getPartsSalvaged() {
        return new HashMap<Part, Integer>(this.partsSalvaged);
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    public void destroy() {
        this.item = null;
        this.processInfo.destroy();
        this.processInfo = null;
        this.startTime = null;
        this.finishTime = null;
        this.partsSalvaged.clear();
        this.partsSalvaged = null;
        this.settlement = null;
    }
}

