/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.manufacture;

import java.io.Serializable;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.manufacture.SalvageProcessInfo;
import org.mars_sim.msp.core.structure.building.function.Manufacture;

public class SalvageProcess
implements Serializable {
    private Manufacture workshop;
    private SalvageProcessInfo info;
    private double workTimeRemaining;
    private Unit salvagedUnit;
    private double averageSkillLevel;

    public SalvageProcess(SalvageProcessInfo info, Manufacture workshop, Unit salvagedUnit) {
        this.info = info;
        this.workshop = workshop;
        this.salvagedUnit = salvagedUnit;
        this.workTimeRemaining = info.getWorkTimeRequired();
        this.averageSkillLevel = 0.0;
    }

    public SalvageProcessInfo getInfo() {
        return this.info;
    }

    public double getWorkTimeRemaining() {
        return this.workTimeRemaining;
    }

    public void addWorkTime(double workTime, int skill) {
        if (workTime > this.workTimeRemaining) {
            workTime = this.workTimeRemaining;
        }
        this.workTimeRemaining -= workTime;
        this.averageSkillLevel += workTime / this.info.getWorkTimeRequired() * (double)skill;
    }

    public String toString() {
        return this.info.toString();
    }

    public Manufacture getWorkshop() {
        return this.workshop;
    }

    public Unit getSalvagedUnit() {
        return this.salvagedUnit;
    }

    public double getAverageSkillLevel() {
        return this.averageSkillLevel;
    }

    public void destroy() {
        this.workshop = null;
        this.info.destroy();
        this.info = null;
        this.salvagedUnit = null;
    }
}

