/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.mars;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.mars.AreothermalMap;
import org.mars_sim.msp.core.mars.ExploredLocation;
import org.mars_sim.msp.core.mars.Landmark;
import org.mars_sim.msp.core.mars.Mars;
import org.mars_sim.msp.core.mars.MineralMap;
import org.mars_sim.msp.core.mars.RandomMineralMap;
import org.mars_sim.msp.core.mars.TerrainElevation;
import org.mars_sim.msp.core.person.ai.mission.Mining;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.structure.Settlement;

public class SurfaceFeatures
implements Serializable {
    private transient TerrainElevation surfaceTerrain = new TerrainElevation();
    private List<Landmark> landmarks;
    private MineralMap mineralMap = new RandomMineralMap();
    private List<ExploredLocation> exploredLocations = new ArrayList<ExploredLocation>();
    private AreothermalMap areothermalMap = new AreothermalMap();

    public SurfaceFeatures() {
        try {
            this.landmarks = SimulationConfig.instance().getLandmarkConfiguration().getLandmarkList();
        }
        catch (Exception e) {
            throw new IllegalStateException("Landmarks could not be loaded: " + e.getMessage(), e);
        }
    }

    public void initializeTransientData() {
        this.surfaceTerrain = new TerrainElevation();
    }

    public TerrainElevation getSurfaceTerrain() {
        return this.surfaceTerrain;
    }

    public double getSurfaceSunlight(Coordinates location) {
        Mars mars = Simulation.instance().getMars();
        Coordinates sunDirection = mars.getOrbitInfo().getSunDirection();
        double angleFromSun = sunDirection.getAngle(location);
        double result = 0.0;
        double twilightzone = 0.2;
        if (angleFromSun < 1.5707963267948966 - twilightzone / 2.0) {
            result = 1.0;
        } else if (angleFromSun > 1.5707963267948966 + twilightzone / 2.0) {
            result = 0.0;
        } else {
            double twilightAngle = angleFromSun - (1.5707963267948966 - twilightzone / 2.0);
            result = 1.0 - twilightAngle / twilightzone;
        }
        return result;
    }

    public boolean inDarkPolarRegion(Coordinates location) {
        boolean result = false;
        Mars mars = Simulation.instance().getMars();
        Coordinates sunDirection = mars.getOrbitInfo().getSunDirection();
        double sunPhi = sunDirection.getPhi();
        double darkPhi = 0.0;
        if (sunPhi < 1.5707963267948966) {
            darkPhi = Math.PI - (1.5707963267948966 - sunPhi);
            if (location.getPhi() >= darkPhi) {
                result = true;
            }
        } else {
            darkPhi = sunPhi - 1.5707963267948966;
            if (location.getPhi() < darkPhi) {
                result = true;
            }
        }
        return result;
    }

    public boolean inPolarRegion(Coordinates location) {
        double polarPhi = 0.3141592653589793;
        return location.getPhi() < polarPhi || location.getPhi() > Math.PI - polarPhi;
    }

    public List<Landmark> getLandmarks() {
        return this.landmarks;
    }

    public MineralMap getMineralMap() {
        return this.mineralMap;
    }

    public ExploredLocation addExploredLocation(Coordinates location, Map<String, Double> estimatedMineralConcentrations, Settlement settlement) {
        ExploredLocation result = new ExploredLocation(location, estimatedMineralConcentrations, settlement);
        this.exploredLocations.add(result);
        return result;
    }

    public List<ExploredLocation> getExploredLocations() {
        return this.exploredLocations;
    }

    public double getAreothermalPotential(Coordinates location) {
        return this.areothermalMap.getAreothermalPotential(location);
    }

    public void timePassing(double time) {
        for (ExploredLocation site : this.exploredLocations) {
            if (!site.isReserved()) continue;
            boolean goodMission = false;
            MissionManager missionManager = Simulation.instance().getMissionManager();
            for (Mission mission : missionManager.getMissions()) {
                if (!(mission instanceof Mining) || !site.equals(((Mining)mission).getMiningSite())) continue;
                goodMission = true;
            }
            if (goodMission) continue;
            site.setReserved(false);
        }
    }

    public void destroy() {
        this.surfaceTerrain = null;
        this.landmarks.clear();
        this.landmarks = null;
        this.mineralMap.destroy();
        this.mineralMap = null;
        this.exploredLocations.clear();
        this.exploredLocations = null;
        this.areothermalMap.destroy();
        this.areothermalMap = null;
    }
}

