/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.mars;

import java.awt.Color;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Direction;
import org.mars_sim.msp.mapdata.MapDataUtil;

public class TerrainElevation {
    private static final double OLYMPUS_MONS_CALDERA_PHI = 1.246165;
    private static final double OLYMPUS_MONS_CALDERA_THETA = 3.944444;
    private static final double ASCRAEUS_MONS_PHI = 1.363102;
    private static final double ASCRAEUS_MONS_THETA = 4.459316;

    TerrainElevation() {
    }

    public double determineTerrainDifficulty(Coordinates currentLocation, Direction currentDirection) {
        double newY = -1.5 * currentDirection.getCosDirection();
        double newX = 1.5 * currentDirection.getSinDirection();
        Coordinates sampleLocation = currentLocation.convertRectToSpherical(newX, newY);
        double elevationChange = this.getElevation(sampleLocation) - this.getElevation(currentLocation);
        double result = Math.atan(elevationChange / 11.1);
        return result;
    }

    public double getElevation(Coordinates location) {
        Color color = MapDataUtil.instance().getTopoMapData().getRGBColor(location.getPhi(), location.getTheta());
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float hue = hsb[0];
        float saturation = hsb[1];
        double elevation = 0.0;
        elevation = hue < 0.792f && hue > 0.033f ? -13801.99 * (double)hue + 2500.0 : -21527.78 * (double)saturation + 19375.0 + 2500.0;
        elevation /= 1000.0;
        elevation = this.patchElevation(elevation, location);
        return elevation;
    }

    private double patchElevation(double elevation, Coordinates location) {
        double result = elevation;
        if (Math.abs(location.getTheta() - 3.944444) < 0.04 && Math.abs(location.getPhi() - 1.246165) < 0.04 && elevation < 3.0) {
            result = 20.0;
        }
        if (Math.abs(location.getTheta() - 4.459316) < 0.02 && Math.abs(location.getPhi() - 1.363102) < 0.02 && elevation < 3.0) {
            result = 20.0;
        }
        return result;
    }
}

