/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;

public class PersonConfig
implements Serializable {
    private static final String PERSON_NAME_LIST = "person-name-list";
    private static final String PERSON_NAME = "person-name";
    private static final String GENDER = "gender";
    private static final String OXYGEN_CONSUMPTION_RATE = "oxygen-consumption-rate";
    private static final String WATER_CONSUMPTION_RATE = "water-consumption-rate";
    private static final String FOOD_CONSUMPTION_RATE = "food-consumption-rate";
    private static final String OXYGEN_DEPRIVATION_TIME = "oxygen-deprivation-time";
    private static final String WATER_DEPRIVATION_TIME = "water-deprivation-time";
    private static final String FOOD_DEPRIVATION_TIME = "food-deprivation-time";
    private static final String STARVATION_START_TIME = "starvation-start-time";
    private static final String MIN_AIR_PRESSURE = "min-air-pressure";
    private static final String DECOMPRESSION_TIME = "decompression-time";
    private static final String MIN_TEMPERATURE = "min-temperature";
    private static final String MAX_TEMPERATURE = "max-temperature";
    private static final String FREEZING_TIME = "freezing-time";
    private static final String STRESS_BREAKDOWN_CHANCE = "stress-breakdown-chance";
    private static final String GENDER_MALE_PERCENTAGE = "gender-male-percentage";
    private static final String PERSONALITY_TYPES = "personality-types";
    private static final String MBTI = "mbti";
    private static final String PERSON_LIST = "person-list";
    private static final String PERSON = "person";
    private static final String NAME = "name";
    private static final String PERSONALITY_TYPE = "personality-type";
    private static final String SETTLEMENT = "settlement";
    private static final String JOB = "job";
    private static final String NATURAL_ATTRIBUTE_LIST = "natural-attribute-list";
    private static final String NATURAL_ATTRIBUTE = "natural-attribute";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String SKILL_LIST = "skill-list";
    private static final String SKILL = "skill";
    private static final String LEVEL = "level";
    private static final String RELATIONSHIP_LIST = "relationship-list";
    private static final String RELATIONSHIP = "relationship";
    private static final String OPINION = "opinion";
    private static final String PERCENTAGE = "percentage";
    private Document personDoc;
    private List<String> nameList;

    public PersonConfig(Document personDoc) {
        this.personDoc = personDoc;
    }

    public List<String> getPersonNameList() {
        if (this.nameList == null) {
            this.nameList = new ArrayList<String>();
            Element root = this.personDoc.getRootElement();
            Element personNameList = root.getChild(PERSON_NAME_LIST);
            List personNames = personNameList.getChildren(PERSON_NAME);
            for (Element nameElement : personNames) {
                this.nameList.add(nameElement.getAttributeValue(VALUE));
            }
        }
        return this.nameList;
    }

    public String getPersonGender(String name) {
        String result = "unknown";
        Element root = this.personDoc.getRootElement();
        Element personNameList = root.getChild(PERSON_NAME_LIST);
        List personNames = personNameList.getChildren(PERSON_NAME);
        for (Element nameElement : personNames) {
            String personName = nameElement.getAttributeValue(VALUE);
            if (!personName.equals(name)) continue;
            result = nameElement.getAttributeValue(GENDER);
        }
        return result;
    }

    public double getOxygenConsumptionRate() {
        return this.getValueAsDouble(OXYGEN_CONSUMPTION_RATE);
    }

    public double getWaterConsumptionRate() {
        return this.getValueAsDouble(WATER_CONSUMPTION_RATE);
    }

    public double getFoodConsumptionRate() {
        return this.getValueAsDouble(FOOD_CONSUMPTION_RATE);
    }

    public double getOxygenDeprivationTime() {
        return this.getValueAsDouble(OXYGEN_DEPRIVATION_TIME);
    }

    public double getWaterDeprivationTime() {
        return this.getValueAsDouble(WATER_DEPRIVATION_TIME);
    }

    public double getFoodDeprivationTime() {
        return this.getValueAsDouble(FOOD_DEPRIVATION_TIME);
    }

    public double getStarvationStartTime() {
        return this.getValueAsDouble(STARVATION_START_TIME);
    }

    public double getMinAirPressure() {
        return this.getValueAsDouble(MIN_AIR_PRESSURE);
    }

    public double getDecompressionTime() {
        return this.getValueAsDouble(DECOMPRESSION_TIME);
    }

    public double getMinTemperature() {
        return this.getValueAsDouble(MIN_TEMPERATURE);
    }

    public double getMaxTemperature() {
        return this.getValueAsDouble(MAX_TEMPERATURE);
    }

    public double getFreezingTime() {
        return this.getValueAsDouble(FREEZING_TIME);
    }

    public double getStressBreakdownChance() {
        return this.getValueAsDouble(STRESS_BREAKDOWN_CHANCE);
    }

    public double getGenderRatio() {
        return this.getValueAsDouble(GENDER_MALE_PERCENTAGE) / 100.0;
    }

    public double getPersonalityTypePercentage(String personalityType) {
        double result = 0.0;
        Element root = this.personDoc.getRootElement();
        Element personalityTypeList = root.getChild(PERSONALITY_TYPES);
        List personalityTypes = personalityTypeList.getChildren(MBTI);
        for (Element mbtiElement : personalityTypes) {
            String type = mbtiElement.getAttributeValue(TYPE);
            if (!type.equals(personalityType)) continue;
            result = Double.parseDouble(mbtiElement.getAttributeValue(PERCENTAGE));
            break;
        }
        return result;
    }

    public int getNumberOfConfiguredPeople() {
        Element root = this.personDoc.getRootElement();
        Element personList = root.getChild(PERSON_LIST);
        List personNodes = personList.getChildren(PERSON);
        if (personNodes != null) {
            return personNodes.size();
        }
        return 0;
    }

    public String getConfiguredPersonName(int index) {
        return this.getValueAsString(index, NAME);
    }

    public String getConfiguredPersonGender(int index) {
        return this.getValueAsString(index, GENDER);
    }

    public String getConfiguredPersonPersonalityType(int index) {
        return this.getValueAsString(index, PERSONALITY_TYPE);
    }

    public String getConfiguredPersonSettlement(int index) {
        return this.getValueAsString(index, SETTLEMENT);
    }

    public String getConfiguredPersonJob(int index) {
        return this.getValueAsString(index, JOB);
    }

    public Map<String, Integer> getNaturalAttributeMap(int index) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Element root = this.personDoc.getRootElement();
        Element personList = root.getChild(PERSON_LIST);
        Element personElement = (Element)personList.getChildren(PERSON).get(index);
        List naturalAttributeListNodes = personElement.getChildren(NATURAL_ATTRIBUTE_LIST);
        if (naturalAttributeListNodes != null && naturalAttributeListNodes.size() > 0) {
            Element naturalAttributeList = (Element)naturalAttributeListNodes.get(0);
            int attributeNum = naturalAttributeList.getChildren(NATURAL_ATTRIBUTE).size();
            for (int x = 0; x < attributeNum; ++x) {
                Element naturalAttributeElement = (Element)naturalAttributeList.getChildren(NATURAL_ATTRIBUTE).get(x);
                String name = naturalAttributeElement.getAttributeValue(NAME);
                Integer value = new Integer(naturalAttributeElement.getAttributeValue(VALUE));
                result.put(name, value);
            }
        }
        return result;
    }

    private String getValueAsString(int index, String param) {
        Element root = this.personDoc.getRootElement();
        Element personList = root.getChild(PERSON_LIST);
        Element personElement = (Element)personList.getChildren(PERSON).get(index);
        return personElement.getAttributeValue(param);
    }

    private double getValueAsDouble(String child) {
        Element root = this.personDoc.getRootElement();
        Element element = root.getChild(child);
        String str = element.getAttributeValue(VALUE);
        return Double.parseDouble(str);
    }

    public Map<String, Integer> getSkillMap(int index) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Element root = this.personDoc.getRootElement();
        Element personList = root.getChild(PERSON_LIST);
        Element personElement = (Element)personList.getChildren(PERSON).get(index);
        List skillListNodes = personElement.getChildren(SKILL_LIST);
        if (skillListNodes != null && skillListNodes.size() > 0) {
            Element skillList = (Element)skillListNodes.get(0);
            int skillNum = skillList.getChildren(SKILL).size();
            for (int x = 0; x < skillNum; ++x) {
                Element skillElement = (Element)skillList.getChildren(SKILL).get(x);
                String name = skillElement.getAttributeValue(NAME);
                Integer level = new Integer(skillElement.getAttributeValue(LEVEL));
                result.put(name, level);
            }
        }
        return result;
    }

    public Map<String, Integer> getRelationshipMap(int index) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Element root = this.personDoc.getRootElement();
        Element personList = root.getChild(PERSON_LIST);
        Element personElement = (Element)personList.getChildren(PERSON).get(index);
        List relationshipListNodes = personElement.getChildren(RELATIONSHIP_LIST);
        if (relationshipListNodes != null && relationshipListNodes.size() > 0) {
            Element relationshipList = (Element)relationshipListNodes.get(0);
            int relationshipNum = relationshipList.getChildren(RELATIONSHIP).size();
            for (int x = 0; x < relationshipNum; ++x) {
                Element relationshipElement = (Element)relationshipList.getChildren(RELATIONSHIP).get(x);
                String personName = relationshipElement.getAttributeValue(PERSON_NAME);
                Integer opinion = new Integer(relationshipElement.getAttributeValue(OPINION));
                result.put(personName, opinion);
            }
        }
        return result;
    }

    public void destroy() {
        this.personDoc = null;
        if (this.nameList != null) {
            this.nameList.clear();
            this.nameList = null;
        }
    }
}

