/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.PersonalityType;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.job.JobManager;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.task.TaskManager;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class Mind
implements Serializable {
    private static Logger logger = Logger.getLogger(Mind.class.getName());
    public static final String JOB_EVENT = "job event";
    public static final String MISSION_EVENT = "mission event";
    private Person person;
    private TaskManager taskManager;
    private Mission mission;
    private Job job;
    private boolean jobLock;
    private PersonalityType personality;
    private SkillManager skillManager;

    public Mind(Person person) {
        this.person = person;
        this.mission = null;
        this.job = null;
        this.jobLock = false;
        this.personality = new PersonalityType(person);
        this.taskManager = new TaskManager(this);
        this.skillManager = new SkillManager(person);
    }

    public void timePassing(double time) {
        if (!this.jobLock) {
            this.setJob(JobManager.getNewJob(this.person), false);
        }
        this.takeAction(time);
        this.personality.updateStress(time);
        Simulation.instance().getRelationshipManager().timePassing(this.person, time);
    }

    public void takeAction(double time) {
        if (this.mission != null && this.mission.isDone()) {
            this.mission = null;
        }
        boolean activeMission = this.mission != null;
        boolean overrideMission = false;
        if (this.person.getLocationSituation().equals("In Settlement")) {
            overrideMission = this.person.getSettlement().getMissionCreationOverride();
        }
        if (this.taskManager.hasActiveTask()) {
            double remainingTime = this.taskManager.performTask(time, this.person.getPerformanceRating());
            if (remainingTime > 0.0) {
                this.takeAction(remainingTime);
            }
        } else {
            if (activeMission) {
                this.mission.performMission(this.person);
            }
            if (!this.taskManager.hasActiveTask()) {
                try {
                    this.getNewAction(true, !activeMission && !overrideMission);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get new action", e);
                    e.printStackTrace(System.err);
                }
            }
            if (this.taskManager.hasActiveTask() || this.hasActiveMission()) {
                this.takeAction(time);
            }
        }
    }

    public Person getPerson() {
        return this.person;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public Mission getMission() {
        return this.mission;
    }

    public Job getJob() {
        return this.job;
    }

    public boolean getJobLock() {
        return this.jobLock;
    }

    public void setJob(Job newJob, boolean locked) {
        this.jobLock = locked;
        if (!newJob.equals(this.job)) {
            this.job = newJob;
            this.person.fireUnitUpdate(JOB_EVENT, newJob);
        }
    }

    public boolean hasActiveMission() {
        return this.mission != null && !this.mission.isDone();
    }

    public void setInactive() {
        this.taskManager.clearTask();
        if (this.hasActiveMission()) {
            this.mission.removePerson(this.person);
            this.mission = null;
        }
    }

    public void setMission(Mission newMission) {
        if (newMission != this.mission) {
            if (this.mission != null) {
                this.mission.removePerson(this.person);
            }
            this.mission = newMission;
            if (newMission != null) {
                newMission.addPerson(this.person);
            }
            this.person.fireUnitUpdate(MISSION_EVENT, newMission);
        }
    }

    public void getNewAction(boolean tasks, boolean missions) {
        MissionManager missionManager = Simulation.instance().getMissionManager();
        if (this.person.getPerformanceRating() < 0.5) {
            missions = false;
        }
        this.enterSettlementIfInRover();
        double taskWeights = 0.0;
        double missionWeights = 0.0;
        double weightSum = 0.0;
        if (tasks) {
            taskWeights = this.taskManager.getTotalTaskProbability(false);
            weightSum += taskWeights;
        }
        if (missions) {
            missionWeights = missionManager.getTotalMissionProbability(this.person);
            weightSum += missionWeights;
        }
        if (weightSum <= 0.0 || weightSum == Double.NaN || weightSum == Double.POSITIVE_INFINITY) {
            throw new IllegalStateException("Mind.getNewAction(): weight sum: " + weightSum);
        }
        double rand = RandomUtil.getRandomDouble(weightSum);
        if (tasks) {
            if (rand < taskWeights) {
                this.taskManager.addTask(this.taskManager.getNewTask());
                return;
            }
            rand -= taskWeights;
        }
        if (missions) {
            if (rand < missionWeights) {
                Mission newMission;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this.person.getName() + " starting a new mission.");
                }
                if ((newMission = missionManager.getNewMission(this.person)) != null) {
                    missionManager.addMission(newMission);
                    this.setMission(newMission);
                }
                return;
            }
            rand -= missionWeights;
        }
        logger.severe(this.person.getName() + " couldn't determine new action - taskWeights: " + taskWeights + ", missionWeights: " + missionWeights);
    }

    private void enterSettlementIfInRover() {
        Vehicle vehicle;
        if (this.mission == null && this.person.getLocationSituation().equals("In Vehicle") && (vehicle = this.person.getVehicle()).getSettlement() != null) {
            Settlement settlement = vehicle.getSettlement();
            vehicle.getInventory().retrieveUnit(this.person);
            settlement.getInventory().storeUnit(this.person);
            BuildingManager.addToRandomBuilding(this.person, settlement);
        }
    }

    public PersonalityType getPersonalityType() {
        return this.personality;
    }

    public SkillManager getSkillManager() {
        return this.skillManager;
    }

    public void destroy() {
        this.person = null;
        this.taskManager.destroy();
        if (this.mission != null) {
            this.mission.destroy();
        }
        this.mission = null;
        this.job = null;
        this.personality.destroy();
        this.personality = null;
        this.skillManager.destroy();
        this.skillManager = null;
    }
}

