/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.PhysicalCondition;

public class PersonalityType
implements Serializable {
    private static final String ISTP = "ISTP";
    private static final String ISTJ = "ISTJ";
    private static final String ISFP = "ISFP";
    private static final String ISFJ = "ISFJ";
    private static final String INTP = "INTP";
    private static final String INTJ = "INTJ";
    private static final String INFP = "INFP";
    private static final String INFJ = "INFJ";
    private static final String ESTP = "ESTP";
    private static final String ESTJ = "ESTJ";
    private static final String ESFP = "ESFP";
    private static final String ESFJ = "ESFJ";
    private static final String ENTP = "ENTP";
    private static final String ENTJ = "ENTJ";
    private static final String ENFP = "ENFP";
    private static final String ENFJ = "ENFJ";
    private static final double BASE_SOLITUDE_STRESS_MODIFIER = 0.1;
    private static final double BASE_COMPANY_STRESS_MODIFIER = 0.1;
    private static Map<String, Double> personalityTypes = null;
    private String personalityType;
    private Person person;

    PersonalityType(Person person) {
        this.person = person;
        if (personalityTypes == null) {
            this.loadPersonalityTypes();
        }
        double randValue = RandomUtil.getRandomDouble(100.0);
        for (String type : personalityTypes.keySet()) {
            double percentage = personalityTypes.get(type);
            if (randValue <= percentage) {
                this.personalityType = type;
                break;
            }
            randValue -= percentage;
        }
        if (this.personalityType == null) {
            throw new IllegalStateException("PersonalityType.constructor(): Unable to determine personality type.");
        }
    }

    public String getTypeString() {
        return this.personalityType;
    }

    public void setTypeString(String newPersonalityType) {
        if (!personalityTypes.containsKey(newPersonalityType)) {
            throw new IllegalArgumentException("Personality type: " + newPersonalityType + " invalid.");
        }
        this.personalityType = newPersonalityType;
    }

    public String toString() {
        return this.personalityType;
    }

    public int getPersonalityDifference(String otherPersonality) {
        int diff = 0;
        for (int x = 0; x < 4; ++x) {
            if (this.personalityType.substring(x, x + 1).equals(otherPersonality.substring(x, x + 1))) continue;
            ++diff;
        }
        return diff;
    }

    public boolean isIntrovert() {
        return this.personalityType.substring(0, 1).equals("I");
    }

    public boolean isExtrovert() {
        return this.personalityType.substring(0, 1).equals("E");
    }

    public boolean isSensor() {
        return this.personalityType.substring(1, 2).equals("S");
    }

    public boolean isIntuitive() {
        return this.personalityType.substring(1, 2).equals("N");
    }

    public boolean isThinker() {
        return this.personalityType.substring(2, 3).equals("T");
    }

    public boolean isFeeler() {
        return this.personalityType.substring(2, 3).equals("F");
    }

    public boolean isJudger() {
        return this.personalityType.substring(3, 4).equals("J");
    }

    public boolean isPerceiver() {
        return this.personalityType.substring(3, 4).equals("P");
    }

    private void loadPersonalityTypes() {
        PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
        personalityTypes = new HashMap<String, Double>(16);
        personalityTypes.put(ISTP, config.getPersonalityTypePercentage(ISTP));
        personalityTypes.put(ISTJ, config.getPersonalityTypePercentage(ISTJ));
        personalityTypes.put(ISFP, config.getPersonalityTypePercentage(ISFP));
        personalityTypes.put(ISFJ, config.getPersonalityTypePercentage(ISFJ));
        personalityTypes.put(INTP, config.getPersonalityTypePercentage(INTP));
        personalityTypes.put(INTJ, config.getPersonalityTypePercentage(INTJ));
        personalityTypes.put(INFP, config.getPersonalityTypePercentage(INFP));
        personalityTypes.put(INFJ, config.getPersonalityTypePercentage(INFJ));
        personalityTypes.put(ESTP, config.getPersonalityTypePercentage(ESTP));
        personalityTypes.put(ESTJ, config.getPersonalityTypePercentage(ESTJ));
        personalityTypes.put(ESFP, config.getPersonalityTypePercentage(ESFP));
        personalityTypes.put(ESFJ, config.getPersonalityTypePercentage(ESFJ));
        personalityTypes.put(ENTP, config.getPersonalityTypePercentage(ENTP));
        personalityTypes.put(ENTJ, config.getPersonalityTypePercentage(ENTJ));
        personalityTypes.put(ENFP, config.getPersonalityTypePercentage(ENFP));
        personalityTypes.put(ENFJ, config.getPersonalityTypePercentage(ENFJ));
        Iterator<String> i = personalityTypes.keySet().iterator();
        double count = 0.0;
        while (i.hasNext()) {
            count += personalityTypes.get(i.next()).doubleValue();
        }
        if (count != 100.0) {
            throw new IllegalStateException("PersonalityType.loadPersonalityTypes(): percentages don't add up to 100%. (total: " + count + ")");
        }
    }

    public void updateStress(double time) {
        Collection<Person> localGroup = this.person.getLocalGroup();
        PhysicalCondition condition = this.person.getPhysicalCondition();
        if (this.isIntrovert() && localGroup.size() == 0) {
            double solitudeStressModifier = 0.1 * time;
            condition.setStress(condition.getStress() - solitudeStressModifier);
        }
        if (this.isExtrovert() && localGroup.size() > 0) {
            double companyStressModifier = 0.1 * time;
            condition.setStress(condition.getStress() - companyStressModifier);
        }
    }

    public void destroy() {
        if (personalityTypes != null) {
            personalityTypes.clear();
        }
        personalityTypes = null;
        this.personalityType = null;
        this.person = null;
    }
}

