/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.job;

import java.io.Serializable;
import java.util.logging.Logger;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.BuildingConstructionMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingSalvageMission;
import org.mars_sim.msp.core.person.ai.mission.EmergencySupplyMission;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.TravelToSettlement;
import org.mars_sim.msp.core.person.ai.task.AssistScientificStudyResearcher;
import org.mars_sim.msp.core.person.ai.task.CompileScientificStudyResults;
import org.mars_sim.msp.core.person.ai.task.DigLocalIce;
import org.mars_sim.msp.core.person.ai.task.InviteStudyCollaborator;
import org.mars_sim.msp.core.person.ai.task.ObserveAstronomicalObjects;
import org.mars_sim.msp.core.person.ai.task.PeerReviewStudyPaper;
import org.mars_sim.msp.core.person.ai.task.PerformLaboratoryResearch;
import org.mars_sim.msp.core.person.ai.task.ProposeScientificStudy;
import org.mars_sim.msp.core.person.ai.task.ResearchScientificStudy;
import org.mars_sim.msp.core.person.ai.task.RespondToStudyInvitation;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.AstronomicalObservation;
import org.mars_sim.msp.core.structure.building.function.Research;

public class Astronomer
extends Job
implements Serializable {
    private static Logger logger = Logger.getLogger(Astronomer.class.getName());

    public Astronomer() {
        super("Astronomer");
        this.jobTasks.add(AssistScientificStudyResearcher.class);
        this.jobTasks.add(CompileScientificStudyResults.class);
        this.jobTasks.add(InviteStudyCollaborator.class);
        this.jobTasks.add(ObserveAstronomicalObjects.class);
        this.jobTasks.add(PeerReviewStudyPaper.class);
        this.jobTasks.add(PerformLaboratoryResearch.class);
        this.jobTasks.add(ProposeScientificStudy.class);
        this.jobTasks.add(ResearchScientificStudy.class);
        this.jobTasks.add(RespondToStudyInvitation.class);
        this.jobTasks.add(DigLocalIce.class);
        this.jobMissionStarts.add(TravelToSettlement.class);
        this.jobMissionJoins.add(TravelToSettlement.class);
        this.jobMissionStarts.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(BuildingConstructionMission.class);
        this.jobMissionJoins.add(BuildingSalvageMission.class);
        this.jobMissionStarts.add(EmergencySupplyMission.class);
        this.jobMissionJoins.add(EmergencySupplyMission.class);
    }

    @Override
    public double getCapability(Person person) {
        double result = 0.0;
        int astronomySkill = person.getMind().getSkillManager().getSkillLevel("Astronomy");
        result = astronomySkill;
        NaturalAttributeManager attributes = person.getNaturalAttributeManager();
        int academicAptitude = attributes.getAttribute("Academic Aptitude");
        result += result * (((double)academicAptitude - 50.0) / 100.0);
        if (person.getPhysicalCondition().hasSeriousMedicalProblems()) {
            result = 0.0;
        }
        return result;
    }

    @Override
    public double getSettlementNeed(Settlement settlement) {
        double result = 0.0;
        BuildingManager manager = settlement.getBuildingManager();
        for (Building building : manager.getBuildings("Research")) {
            Research lab = (Research)building.getFunction("Research");
            if (!lab.hasSpeciality("Astronomy")) continue;
            result += (double)(lab.getLaboratorySize() * lab.getTechnologyLevel()) / 2.0;
        }
        for (Building building : manager.getBuildings(AstronomicalObservation.NAME)) {
            AstronomicalObservation observatory = (AstronomicalObservation)building.getFunction(AstronomicalObservation.NAME);
            result += (double)(observatory.getObservatoryCapacity() * observatory.getTechnologyLevel()) * 2.0;
        }
        return result;
    }
}

