/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.job;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.BuildingConstructionMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingSalvageMission;
import org.mars_sim.msp.core.person.ai.mission.EmergencySupplyMission;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.TravelToSettlement;
import org.mars_sim.msp.core.person.ai.task.AssistScientificStudyResearcher;
import org.mars_sim.msp.core.person.ai.task.CompileScientificStudyResults;
import org.mars_sim.msp.core.person.ai.task.DigLocalIce;
import org.mars_sim.msp.core.person.ai.task.InviteStudyCollaborator;
import org.mars_sim.msp.core.person.ai.task.PeerReviewStudyPaper;
import org.mars_sim.msp.core.person.ai.task.PerformLaboratoryExperiment;
import org.mars_sim.msp.core.person.ai.task.PerformLaboratoryResearch;
import org.mars_sim.msp.core.person.ai.task.ProposeScientificStudy;
import org.mars_sim.msp.core.person.ai.task.ResearchScientificStudy;
import org.mars_sim.msp.core.person.ai.task.RespondToStudyInvitation;
import org.mars_sim.msp.core.person.ai.task.TendGreenhouse;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.Farming;
import org.mars_sim.msp.core.structure.building.function.Research;

public class Botanist
extends Job
implements Serializable {
    private static Logger logger = Logger.getLogger(Botanist.class.getName());

    public Botanist() {
        super("Botanist");
        this.jobTasks.add(AssistScientificStudyResearcher.class);
        this.jobTasks.add(CompileScientificStudyResults.class);
        this.jobTasks.add(InviteStudyCollaborator.class);
        this.jobTasks.add(PeerReviewStudyPaper.class);
        this.jobTasks.add(PerformLaboratoryExperiment.class);
        this.jobTasks.add(PerformLaboratoryResearch.class);
        this.jobTasks.add(ProposeScientificStudy.class);
        this.jobTasks.add(ResearchScientificStudy.class);
        this.jobTasks.add(RespondToStudyInvitation.class);
        this.jobTasks.add(TendGreenhouse.class);
        this.jobTasks.add(DigLocalIce.class);
        this.jobMissionStarts.add(TravelToSettlement.class);
        this.jobMissionJoins.add(TravelToSettlement.class);
        this.jobMissionStarts.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(BuildingConstructionMission.class);
        this.jobMissionJoins.add(BuildingSalvageMission.class);
        this.jobMissionStarts.add(EmergencySupplyMission.class);
        this.jobMissionJoins.add(EmergencySupplyMission.class);
    }

    @Override
    public double getCapability(Person person) {
        double result = 0.0;
        int botanySkill = person.getMind().getSkillManager().getSkillLevel("Botany");
        result = botanySkill;
        NaturalAttributeManager attributes = person.getNaturalAttributeManager();
        int academicAptitude = attributes.getAttribute("Academic Aptitude");
        int experienceAptitude = attributes.getAttribute("Experience Aptitude");
        double averageAptitude = (double)(academicAptitude + experienceAptitude) / 2.0;
        result += result * ((averageAptitude - 50.0) / 100.0);
        if (person.getPhysicalCondition().hasSeriousMedicalProblems()) {
            result = 0.0;
        }
        return result;
    }

    @Override
    public double getSettlementNeed(Settlement settlement) {
        double result = 0.0;
        List<Building> laboratoryBuildings = settlement.getBuildingManager().getBuildings("Research");
        for (Building building : laboratoryBuildings) {
            Research lab = (Research)building.getFunction("Research");
            if (!lab.hasSpeciality("Botany")) continue;
            result += (double)(lab.getResearcherNum() * lab.getTechnologyLevel()) / 2.0;
        }
        List<Building> greenhouseBuildings = settlement.getBuildingManager().getBuildings("Farming");
        for (Building building : greenhouseBuildings) {
            Farming farm = (Farming)building.getFunction("Farming");
            result += farm.getGrowingArea() / 25.0;
        }
        return result;
    }
}

