/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.job;

import java.io.Serializable;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.BuildingConstructionMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingSalvageMission;
import org.mars_sim.msp.core.person.ai.mission.CollectIce;
import org.mars_sim.msp.core.person.ai.mission.CollectRegolith;
import org.mars_sim.msp.core.person.ai.mission.EmergencySupplyMission;
import org.mars_sim.msp.core.person.ai.mission.Exploration;
import org.mars_sim.msp.core.person.ai.mission.Mining;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.Trade;
import org.mars_sim.msp.core.person.ai.mission.TravelToSettlement;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.DigLocalIce;
import org.mars_sim.msp.core.person.ai.task.EnterAirlock;
import org.mars_sim.msp.core.person.ai.task.ExitAirlock;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleGarage;
import org.mars_sim.msp.core.person.ai.task.MaintainGroundVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.MaintainGroundVehicleGarage;
import org.mars_sim.msp.core.person.ai.task.RepairEVAMalfunction;
import org.mars_sim.msp.core.person.ai.task.RepairMalfunction;
import org.mars_sim.msp.core.person.ai.task.UnloadVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.UnloadVehicleGarage;
import org.mars_sim.msp.core.structure.Settlement;

public class Driver
extends Job
implements Serializable {
    public Driver() {
        super("Driver");
        this.jobTasks.add(MaintainGroundVehicleGarage.class);
        this.jobTasks.add(MaintainGroundVehicleEVA.class);
        this.jobTasks.add(RepairMalfunction.class);
        this.jobTasks.add(RepairEVAMalfunction.class);
        this.jobTasks.add(LoadVehicleGarage.class);
        this.jobTasks.add(UnloadVehicleGarage.class);
        this.jobTasks.add(LoadVehicleEVA.class);
        this.jobTasks.add(UnloadVehicleEVA.class);
        this.jobTasks.add(EnterAirlock.class);
        this.jobTasks.add(ExitAirlock.class);
        this.jobTasks.add(DigLocalIce.class);
        this.jobMissionJoins.add(Exploration.class);
        this.jobMissionJoins.add(CollectIce.class);
        this.jobMissionJoins.add(CollectRegolith.class);
        this.jobMissionJoins.add(Trade.class);
        this.jobMissionStarts.add(TravelToSettlement.class);
        this.jobMissionJoins.add(TravelToSettlement.class);
        this.jobMissionStarts.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(Mining.class);
        this.jobMissionJoins.add(BuildingConstructionMission.class);
        this.jobMissionJoins.add(BuildingSalvageMission.class);
        this.jobMissionStarts.add(EmergencySupplyMission.class);
        this.jobMissionJoins.add(EmergencySupplyMission.class);
    }

    @Override
    public double getCapability(Person person) {
        double result = 0.0;
        int areologySkill = person.getMind().getSkillManager().getSkillLevel("Driving");
        result = areologySkill;
        NaturalAttributeManager attributes = person.getNaturalAttributeManager();
        int experienceAptitude = attributes.getAttribute("Experience Aptitude");
        result += result * (((double)experienceAptitude - 50.0) / 100.0);
        if (person.getPhysicalCondition().hasSeriousMedicalProblems()) {
            result = 0.0;
        }
        return result;
    }

    @Override
    public double getSettlementNeed(Settlement settlement) {
        double result = 0.0;
        double settlementVehicleNum = settlement.getParkedVehicleNum();
        MissionManager missionManager = Simulation.instance().getMissionManager();
        for (Mission mission : missionManager.getMissionsForSettlement(settlement)) {
            if (!(mission instanceof VehicleMission)) continue;
            settlementVehicleNum += 1.0;
        }
        result = settlementVehicleNum;
        return result;
    }
}

