/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.job;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.BuildingConstructionMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingSalvageMission;
import org.mars_sim.msp.core.person.ai.mission.EmergencySupplyMission;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.TravelToSettlement;
import org.mars_sim.msp.core.person.ai.task.DigLocalIce;
import org.mars_sim.msp.core.person.ai.task.DigLocalRegolith;
import org.mars_sim.msp.core.person.ai.task.ManufactureGood;
import org.mars_sim.msp.core.person.ai.task.SalvageGood;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.Manufacture;

public class Engineer
extends Job
implements Serializable {
    private static Logger logger = Logger.getLogger(Engineer.class.getName());

    public Engineer() {
        super("Engineer");
        this.jobTasks.add(ManufactureGood.class);
        this.jobTasks.add(DigLocalRegolith.class);
        this.jobTasks.add(DigLocalIce.class);
        this.jobTasks.add(SalvageGood.class);
        this.jobMissionStarts.add(TravelToSettlement.class);
        this.jobMissionJoins.add(TravelToSettlement.class);
        this.jobMissionStarts.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(BuildingConstructionMission.class);
        this.jobMissionJoins.add(BuildingSalvageMission.class);
        this.jobMissionStarts.add(EmergencySupplyMission.class);
        this.jobMissionJoins.add(EmergencySupplyMission.class);
    }

    @Override
    public double getCapability(Person person) {
        double result = 0.0;
        int materialsScienceSkill = person.getMind().getSkillManager().getSkillLevel("Materials Science");
        result = materialsScienceSkill;
        NaturalAttributeManager attributes = person.getNaturalAttributeManager();
        int academicAptitude = attributes.getAttribute("Academic Aptitude");
        int experienceAptitude = attributes.getAttribute("Experience Aptitude");
        double averageAptitude = (double)(academicAptitude + experienceAptitude) / 2.0;
        result += result * ((averageAptitude - 50.0) / 100.0);
        if (person.getPhysicalCondition().hasSeriousMedicalProblems()) {
            result = 0.0;
        }
        return result;
    }

    @Override
    public double getSettlementNeed(Settlement settlement) {
        double result = 0.0;
        List<Building> manufactureBuildings = settlement.getBuildingManager().getBuildings("Manufacture");
        for (Building building : manufactureBuildings) {
            Manufacture workshop = (Manufacture)building.getFunction("Manufacture");
            result += (double)(workshop.getTechLevel() * workshop.getConcurrentProcesses()) / 2.0;
        }
        return result;
    }
}

