/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.job;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.structure.Settlement;

public abstract class Job
implements Serializable {
    private static final double NON_JOB_TASK_PENALTY = 0.01;
    private static final double NON_JOB_MISSION_START_PENALTY = 0.01;
    private static final double NON_JOB_MISSION_JOIN_PENALTY = 0.01;
    private String name;
    protected List<Class> jobTasks;
    protected List<Class> jobMissionStarts;
    protected List<Class> jobMissionJoins;

    public Job(String name) {
        this.name = name;
        this.jobTasks = new ArrayList<Class>();
        this.jobMissionStarts = new ArrayList<Class>();
        this.jobMissionJoins = new ArrayList<Class>();
    }

    public String getName() {
        return this.name;
    }

    public abstract double getCapability(Person var1);

    public double getStartTaskProbabilityModifier(Class taskClass) {
        double result = 1.0;
        if (!this.jobTasks.contains(taskClass)) {
            result = 0.01;
        }
        return result;
    }

    public double getStartMissionProbabilityModifier(Class missionClass) {
        double result = 1.0;
        if (!this.jobMissionStarts.contains(missionClass)) {
            result = 0.01;
        }
        return result;
    }

    public double getJoinMissionProbabilityModifier(Class missionClass) {
        double result = 1.0;
        if (!this.jobMissionJoins.contains(missionClass)) {
            result = 0.01;
        }
        return result;
    }

    public abstract double getSettlementNeed(Settlement var1);

    public boolean isJobRelatedTask(Class taskClass) {
        return this.jobTasks.contains(taskClass);
    }
}

