/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.job;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Architect;
import org.mars_sim.msp.core.person.ai.job.Areologist;
import org.mars_sim.msp.core.person.ai.job.Astronomer;
import org.mars_sim.msp.core.person.ai.job.Biologist;
import org.mars_sim.msp.core.person.ai.job.Botanist;
import org.mars_sim.msp.core.person.ai.job.Chef;
import org.mars_sim.msp.core.person.ai.job.Chemist;
import org.mars_sim.msp.core.person.ai.job.Doctor;
import org.mars_sim.msp.core.person.ai.job.Driver;
import org.mars_sim.msp.core.person.ai.job.Engineer;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.job.Mathematician;
import org.mars_sim.msp.core.person.ai.job.Meteorologist;
import org.mars_sim.msp.core.person.ai.job.Physicist;
import org.mars_sim.msp.core.person.ai.job.Technician;
import org.mars_sim.msp.core.person.ai.job.Trader;
import org.mars_sim.msp.core.structure.Settlement;

public final class JobManager
implements Serializable {
    private static String CLASS_NAME = "org.mars_sim.msp.simulation.person.ai.job.JobManager";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private static List<Job> jobs;

    private JobManager() {
    }

    private static void loadJobs() {
        jobs = new ArrayList<Job>();
        jobs.add(new Botanist());
        jobs.add(new Areologist());
        jobs.add(new Doctor());
        jobs.add(new Engineer());
        jobs.add(new Driver());
        jobs.add(new Chef());
        jobs.add(new Trader());
        jobs.add(new Technician());
        jobs.add(new Architect());
        jobs.add(new Biologist());
        jobs.add(new Astronomer());
        jobs.add(new Chemist());
        jobs.add(new Physicist());
        jobs.add(new Mathematician());
        jobs.add(new Meteorologist());
    }

    public static List<Job> getJobs() {
        if (jobs == null) {
            JobManager.loadJobs();
        }
        return new ArrayList<Job>(jobs);
    }

    public static Job getJob(String jobName) {
        Job result = null;
        for (Job job : JobManager.getJobs()) {
            if (!job.getName().equalsIgnoreCase(jobName)) continue;
            result = job;
        }
        return result;
    }

    public static double getRemainingSettlementNeed(Settlement settlement, Job job) {
        double result = job.getSettlementNeed(settlement);
        for (Person person : settlement.getAllAssociatedPeople()) {
            if (person.getMind().getJob() != job) continue;
            result -= job.getCapability(person);
        }
        return result;
    }

    public static Job getNewJob(Person person) {
        Job originalJob = person.getMind().getJob();
        Settlement settlement = null;
        if (person.getLocationSituation().equals("In Settlement")) {
            settlement = person.getSettlement();
        } else if (person.getMind().hasActiveMission()) {
            settlement = person.getMind().getMission().getAssociatedSettlement();
        }
        Job newJob = null;
        double newJobProspect = -2.147483648E9;
        if (settlement != null) {
            for (Job job : JobManager.getJobs()) {
                double jobProspect = JobManager.getJobProspect(person, job, settlement, true);
                if (!(jobProspect >= newJobProspect)) continue;
                newJob = job;
                newJobProspect = jobProspect;
            }
            if (logger.isLoggable(Level.FINEST)) {
                if (newJob != null && newJob != originalJob) {
                    logger.finest(person.getName() + " changed jobs to " + newJob.getName());
                } else {
                    logger.finest(person.getName() + " keeping old job of " + originalJob.getName());
                }
            }
        } else {
            newJob = originalJob;
        }
        return newJob;
    }

    public static double getJobProspect(Person person, Job job, Settlement settlement, boolean isHomeSettlement) {
        double jobCapability = 0.0;
        if (job != null) {
            jobCapability = job.getCapability(person);
        }
        double remainingNeed = JobManager.getRemainingSettlementNeed(settlement, job);
        if (job == person.getMind().getJob() && isHomeSettlement) {
            remainingNeed += jobCapability;
        }
        return (jobCapability + 1.0) * remainingNeed;
    }

    public static double getBestJobProspect(Person person, Settlement settlement, boolean isHomeSettlement) {
        double bestProspect = Double.MIN_VALUE;
        for (Job job : JobManager.getJobs()) {
            double prospect = JobManager.getJobProspect(person, job, settlement, isHomeSettlement);
            if (!(prospect > bestProspect)) continue;
            bestProspect = prospect;
        }
        return bestProspect;
    }
}

